/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.status;

import com.codahale.metrics.Counter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import org.visallo.core.status.MetricsManager;

public class JmxMetricsManager
implements MetricsManager {
    private static final MetricRegistry REGISTRY;
    private static final JmxReporter JMX_REPORTER;
    private static final AtomicInteger ID;

    private static int nextId() {
        return ID.getAndIncrement();
    }

    @Override
    public MetricRegistry getRegistry() {
        return REGISTRY;
    }

    @Override
    public String getNamePrefix(Object obj) {
        return String.format("%s.%d.", obj.getClass().getName(), JmxMetricsManager.nextId());
    }

    @Override
    public String getNamePrefix(Object obj, String qualifier) {
        return String.format("%s.%s-%d.", obj.getClass().getName(), qualifier, JmxMetricsManager.nextId());
    }

    @Override
    public Counter counter(String name) {
        return this.getRegistry().counter(name);
    }

    @Override
    public Timer timer(String name) {
        return this.getRegistry().timer(name);
    }

    static {
        ID = new AtomicInteger(0);
        REGISTRY = new MetricRegistry();
        JMX_REPORTER = JmxReporter.forRegistry((MetricRegistry)REGISTRY).build();
        JMX_REPORTER.start();
    }
}

