/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.visallo.core.exception.VisalloException;

public class ExecutorServiceUtil {
    private static final ExecutorService pool = Executors.newCachedThreadPool();

    public static <T> T[] runAllAndWait(Callable<T> ... tasks) {
        try {
            ArrayList<T> results = new ArrayList<T>(tasks.length);
            List<Future<T>> futures = pool.invokeAll(Arrays.asList(tasks));
            for (Future<T> future : futures) {
                results.add(future.get());
            }
            return results.toArray();
        }
        catch (Exception ex) {
            throw new VisalloException("Failed to execute tasks", ex);
        }
    }
}

