/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Strings;
import com.v5analytics.simpleorm.SimpleOrmSession;
import org.vertexium.Graph;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class ModelUtil {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ModelUtil.class);

    public static void drop(Graph graph, SimpleOrmSession simpleOrmSession, UserRepository userRepository, WorkQueueRepository workQueueRepository, AuthorizationRepository authorizationRepository, User user) {
        ModelUtil.clearTables(userRepository, simpleOrmSession, user);
        workQueueRepository.format();
        LOGGER.debug("BEGIN remove all authorizations", new Object[0]);
        for (String auth : authorizationRepository.getGraphAuthorizations()) {
            LOGGER.debug("removing auth %s", auth);
            authorizationRepository.removeAuthorizationFromGraph(auth);
        }
        LOGGER.debug("END remove all authorizations", new Object[0]);
        graph.drop();
    }

    public static void clearTables(UserRepository userRepository, SimpleOrmSession simpleOrmSession, User user) {
        LOGGER.warn("BEGIN clearing tables", new Object[0]);
        String tablePrefix = simpleOrmSession.getTablePrefix();
        if (Strings.isNullOrEmpty((String)tablePrefix)) {
            throw new VisalloException("Unable to format without a SimpleOrmSession table prefix");
        }
        for (String table : simpleOrmSession.getTableList(userRepository.getSimpleOrmContext(user))) {
            if (!table.startsWith(tablePrefix)) continue;
            LOGGER.warn("clearing table: %s", table);
            simpleOrmSession.clearTable(table, userRepository.getSimpleOrmContext(user));
        }
        LOGGER.warn("END clearing tables", new Object[0]);
    }
}

