/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.longRunningProcess;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Path;
import org.vertexium.ProgressCallback;
import org.visallo.core.model.Description;
import org.visallo.core.model.Name;
import org.visallo.core.model.longRunningProcess.FindPathLongRunningProcessQueueItem;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRepository;
import org.visallo.core.model.longRunningProcess.LongRunningProcessWorker;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.web.clientapi.model.ClientApiVertexFindPathResponse;

@Name(value="Find Path")
@Description(value="Finds a path between two vertices")
public class FindPathLongRunningProcessWorker
extends LongRunningProcessWorker {
    private final Graph graph;
    private final LongRunningProcessRepository longRunningProcessRepository;

    @Inject
    public FindPathLongRunningProcessWorker(Graph graph, LongRunningProcessRepository longRunningProcessRepository) {
        this.graph = graph;
        this.longRunningProcessRepository = longRunningProcessRepository;
    }

    @Override
    public boolean isHandled(JSONObject longRunningProcessQueueItem) {
        return longRunningProcessQueueItem.getString("type").equals("findPath");
    }

    @Override
    public void processInternal(final JSONObject longRunningProcessQueueItem) {
        FindPathLongRunningProcessQueueItem findPath = (FindPathLongRunningProcessQueueItem)ClientApiConverter.toClientApi((String)longRunningProcessQueueItem.toString(), FindPathLongRunningProcessQueueItem.class);
        Authorizations authorizations = this.getAuthorizations(findPath.getAuthorizations());
        String[] labels = findPath.getLabels();
        int hops = findPath.getHops();
        ClientApiVertexFindPathResponse results = new ClientApiVertexFindPathResponse();
        ProgressCallback progressCallback = new ProgressCallback(){

            public void progress(double progressPercent, ProgressCallback.Step step, Integer edgeIndex, Integer vertexCount) {
                FindPathLongRunningProcessWorker.this.longRunningProcessRepository.reportProgress(longRunningProcessQueueItem, progressPercent, step.formatMessage(edgeIndex, vertexCount));
            }
        };
        Iterable paths = this.graph.findPaths(findPath.getOutVertexId(), findPath.getInVertexId(), labels, hops, progressCallback, authorizations);
        for (Path path : paths) {
            ArrayList<String> clientApiVertexPath = new ArrayList<String>();
            for (String s : path) {
                clientApiVertexPath.add(s);
            }
            results.getPaths().add(clientApiVertexPath);
        }
        String resultsString = ClientApiConverter.clientApiToString((Object)results);
        JSONObject resultsJson = new JSONObject(resultsString);
        longRunningProcessQueueItem.put("results", (Object)resultsJson);
        longRunningProcessQueueItem.put("resultsCount", results.getPaths().size());
    }

    private Authorizations getAuthorizations(String[] authorizations) {
        return this.graph.createAuthorizations(authorizations);
    }
}

