/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.atteo.evo.inflector.English;
import org.vertexium.Authorizations;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.HasOntologyProperties;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.web.clientapi.model.ClientApiOntology;

public abstract class Concept
implements HasOntologyProperties {
    private final String parentConceptIRI;
    private final Collection<OntologyProperty> properties;

    protected Concept(String parentConceptIRI, Collection<OntologyProperty> properties) {
        this.parentConceptIRI = parentConceptIRI;
        this.properties = properties;
    }

    public abstract String getTitle();

    public abstract boolean hasGlyphIconResource();

    public abstract boolean hasGlyphIconSelectedResource();

    public abstract String getColor();

    public abstract String getDisplayName();

    public abstract String getDisplayType();

    public abstract String getTitleFormula();

    public abstract Boolean getSearchable();

    public abstract String getSubtitleFormula();

    public abstract String getTimeFormula();

    public abstract boolean getUserVisible();

    public abstract boolean getDeleteable();

    public abstract boolean getUpdateable();

    public abstract Map<String, String> getMetadata();

    public abstract List<String> getAddRelatedConceptWhiteList();

    @Override
    public Collection<OntologyProperty> getProperties() {
        return this.properties;
    }

    public String getParentConceptIRI() {
        return this.parentConceptIRI;
    }

    public ClientApiOntology.Concept toClientApi() {
        try {
            ClientApiOntology.Concept concept = new ClientApiOntology.Concept();
            concept.setId(this.getIRI());
            concept.setTitle(this.getTitle());
            concept.setDisplayName(this.getDisplayName());
            if (this.getDisplayType() != null) {
                concept.setDisplayType(this.getDisplayType());
            }
            if (this.getTitleFormula() != null) {
                concept.setTitleFormula(this.getTitleFormula());
            }
            if (this.getSearchable() != null) {
                concept.setSearchable(this.getSearchable());
            }
            if (this.getSubtitleFormula() != null) {
                concept.setSubtitleFormula(this.getSubtitleFormula());
            }
            if (this.getTimeFormula() != null) {
                concept.setTimeFormula(this.getTimeFormula());
            }
            if (this.getParentConceptIRI() != null) {
                concept.setParentConcept(this.getParentConceptIRI());
            }
            if (this.getDisplayName() != null) {
                concept.setPluralDisplayName(English.plural((String)this.getDisplayName()));
            }
            if (!this.getUserVisible()) {
                concept.setUserVisible(Boolean.valueOf(this.getUserVisible()));
            }
            concept.setDeleteable(Boolean.valueOf(this.getDeleteable()));
            concept.setUpdateable(Boolean.valueOf(this.getUpdateable()));
            if (this.hasGlyphIconResource()) {
                concept.setGlyphIconHref("resource?id=" + URLEncoder.encode(this.getIRI(), "utf8"));
            }
            if (this.hasGlyphIconSelectedResource()) {
                concept.setGlyphIconSelectedHref("resource?state=selected&id=" + URLEncoder.encode(this.getIRI(), "utf8"));
            }
            if (this.getColor() != null) {
                concept.setColor(this.getColor());
            }
            if (this.getAddRelatedConceptWhiteList() != null) {
                concept.getAddRelatedConceptWhiteList().addAll(this.getAddRelatedConceptWhiteList());
            }
            if (this.getIntents() != null) {
                concept.getIntents().addAll(Arrays.asList(this.getIntents()));
            }
            if (this.properties != null) {
                for (OntologyProperty ontologyProperty : this.properties) {
                    concept.getProperties().add(ontologyProperty.getTitle());
                }
            }
            for (Map.Entry entry : this.getMetadata().entrySet()) {
                concept.getMetadata().put(entry.getKey(), entry.getValue());
            }
            return concept;
        }
        catch (UnsupportedEncodingException e) {
            throw new VisalloException("bad encoding", e);
        }
    }

    public String toString() {
        return String.format("%s (%s)", this.getDisplayName(), this.getIRI());
    }

    public static Collection<ClientApiOntology.Concept> toClientApiConcepts(Iterable<Concept> concepts) {
        ArrayList<ClientApiOntology.Concept> results = new ArrayList<ClientApiOntology.Concept>();
        for (Concept concept : concepts) {
            results.add(concept.toClientApi());
        }
        return results;
    }

    public abstract void setProperty(String var1, Object var2, Authorizations var3);

    public abstract void removeProperty(String var1, Authorizations var2);

    public abstract byte[] getGlyphIcon();

    public abstract byte[] getGlyphIconSelected();

    public abstract byte[] getMapGlyphIcon();

    public abstract String getIRI();

    public abstract String[] getIntents();

    public abstract void addIntent(String var1, Authorizations var2);

    public abstract void removeIntent(String var1, Authorizations var2);

    public void updateIntents(String[] newIntents, Authorizations authorizations) {
        ArrayList toBeRemovedIntents = Lists.newArrayList((Object[])this.getIntents());
        for (String newIntent : newIntents) {
            if (toBeRemovedIntents.contains(newIntent)) {
                toBeRemovedIntents.remove(newIntent);
                continue;
            }
            this.addIntent(newIntent, authorizations);
        }
        for (String toBeRemovedIntent : toBeRemovedIntents) {
            this.removeIntent(toBeRemovedIntent, authorizations);
        }
    }

    public int hashCode() {
        return this.getIRI().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Concept)) {
            return false;
        }
        Concept other = (Concept)obj;
        return this.getIRI().equals(other.getIRI());
    }
}

