/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.ReaderDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.vertexium.Authorizations;
import org.vertexium.DefinePropertyBuilder;
import org.vertexium.Graph;
import org.vertexium.TextIndexHint;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.query.Contains;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.util.CloseableUtils;
import org.vertexium.util.ConvertingIterable;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyProperties;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyPropertyDefinition;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.properties.types.VisalloProperty;
import org.visallo.core.util.ExecutorServiceUtil;
import org.visallo.core.util.JSONUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.PropertyType;

public abstract class OntologyRepositoryBase
implements OntologyRepository {
    public static final String BASE_OWL_IRI = "http://visallo.org";
    public static final String COMMENT_OWL_IRI = "http://visallo.org/comment";
    public static final String RESOURCE_ENTITY_PNG = "entity.png";
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(OntologyRepositoryBase.class);
    private static final String OBJECT_PROPERTY_DOMAIN_IRI = "http://visallo.org#objectPropertyDomain";
    private static final String TOP_OBJECT_PROPERTY_IRI = "http://www.w3.org/2002/07/owl#topObjectProperty";
    private final Configuration configuration;
    private final LockRepository lockRepository;

    @Inject
    protected OntologyRepositoryBase(Configuration configuration, LockRepository lockRepository) {
        this.configuration = configuration;
        this.lockRepository = lockRepository;
    }

    public static String getLabel(OWLOntology o, OWLEntity owlEntity) {
        String bestLabel = owlEntity.getIRI().toString();
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)owlEntity, (OWLOntology)o)) {
            if (!annotation.getProperty().isLabel()) continue;
            OWLLiteral value = (OWLLiteral)annotation.getValue();
            bestLabel = value.getLiteral();
            if (!value.getLang().equals("") && !value.getLang().equals("en")) continue;
            return bestLabel;
        }
        return bestLabel;
    }

    public static String[] getIntents(OWLOntology o, OWLEntity owlEntity) {
        return OntologyRepositoryBase.getAnnotationValuesByUri(o, owlEntity, OntologyProperties.INTENT.getPropertyName());
    }

    protected static String[] getAnnotationValuesByUri(OWLOntology o, OWLEntity owlEntity, String uri) {
        ArrayList<String> results = new ArrayList<String>();
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)owlEntity, (OWLOntology)o)) {
            if (!annotation.getProperty().getIRI().toString().equals(uri)) continue;
            OWLLiteral value = (OWLLiteral)annotation.getValue();
            results.add(value.getLiteral());
        }
        return results.toArray(new String[results.size()]);
    }

    public void loadOntologies(Configuration config, Authorizations authorizations) throws Exception {
        this.lockRepository.lock("ontology", () -> {
            Concept rootConcept = this.getOrCreateConcept(null, "http://visallo.org#root", "root", null);
            Concept entityConcept = this.getOrCreateConcept(rootConcept, "http://www.w3.org/2002/07/owl#Thing", "thing", null);
            this.getOrCreateTopObjectPropertyRelationship(authorizations);
            this.clearCache();
            this.addEntityGlyphIcon(entityConcept);
            this.importResourceOwl("base.owl", BASE_OWL_IRI, authorizations);
            this.importResourceOwl("user.owl", "http://visallo.org/user", authorizations);
            this.importResourceOwl("termMention.owl", "http://visallo.org/termMention", authorizations);
            this.importResourceOwl("workspace.owl", "http://visallo.org/workspace", authorizations);
            this.importResourceOwl("comment.owl", COMMENT_OWL_IRI, authorizations);
            this.importResourceOwl("search.owl", "http://visallo.org/search", authorizations);
            this.importResourceOwl("longRunningProcess.owl", "http://visallo.org/longRunningProcess", authorizations);
            this.importResourceOwl("ping.owl", "http://visallo.org/ping", authorizations);
            for (Map.Entry<String, Map<String, String>> owlGroup : config.getMultiValue("repository.ontology.owl").entrySet()) {
                String iri = owlGroup.getValue().get("iri");
                String dir = owlGroup.getValue().get("dir");
                String file = owlGroup.getValue().get("file");
                if (iri == null) {
                    throw new VisalloException("iri is required for group repository.ontology.owl." + owlGroup.getKey());
                }
                if (dir == null && file == null) {
                    throw new VisalloException("dir or file is required for repository.ontology.owl." + owlGroup.getKey());
                }
                if (dir != null && file != null) {
                    throw new VisalloException("you cannot specify both dir and file for repository.ontology.owl." + owlGroup.getKey());
                }
                if (dir != null) {
                    File owlFile = this.findOwlFile(new File(dir));
                    if (owlFile == null) {
                        throw new VisalloResourceNotFoundException("could not find owl file in directory " + new File(dir).getAbsolutePath());
                    }
                    this.importFile(owlFile, IRI.create((String)iri), authorizations);
                    continue;
                }
                this.writePackage(new File(file), IRI.create((String)iri), authorizations);
            }
            return true;
        });
    }

    private Relationship getOrCreateTopObjectPropertyRelationship(Authorizations authorizations) {
        Relationship topObjectProperty = this.getOrCreateRelationshipType(null, Collections.emptyList(), Collections.emptyList(), TOP_OBJECT_PROPERTY_IRI);
        if (topObjectProperty.getUserVisible()) {
            topObjectProperty.setProperty(OntologyProperties.USER_VISIBLE.getPropertyName(), false, authorizations);
        }
        return topObjectProperty;
    }

    private void importResourceOwl(String fileName, String iri, Authorizations authorizations) {
        this.importResourceOwl(OntologyRepositoryBase.class, fileName, iri, authorizations);
    }

    @Override
    public void importResourceOwl(Class baseClass, String fileName, String iri, Authorizations authorizations) {
        if (this.isOntologyDefined(iri)) {
            LOGGER.debug("Ontology %s (iri: %s) is already defined", fileName, iri);
            return;
        }
        LOGGER.debug("importResourceOwl %s (iri: %s)", fileName, iri);
        InputStream owlFileIn = baseClass.getResourceAsStream(fileName);
        Preconditions.checkNotNull((Object)owlFileIn, (Object)("Could not load resource " + baseClass.getResource(fileName) + " [" + fileName + "]"));
        try {
            IRI documentIRI = IRI.create((String)iri);
            byte[] inFileData = IOUtils.toByteArray((InputStream)owlFileIn);
            try {
                this.importFileData(inFileData, documentIRI, null, authorizations);
            }
            catch (OWLOntologyAlreadyExistsException ex) {
                LOGGER.warn("Ontology was already defined but not stored: " + fileName + " (iri: " + iri + ")", ex);
                this.storeOntologyFile(new ByteArrayInputStream(inFileData), documentIRI);
            }
        }
        catch (Exception ex) {
            throw new VisalloException("Could not import ontology file: " + fileName + " (iri: " + iri + ")", ex);
        }
        finally {
            CloseableUtils.closeQuietly((Closeable)owlFileIn);
        }
    }

    @Override
    public abstract boolean isOntologyDefined(String var1);

    private void addEntityGlyphIcon(Concept entityConcept) {
        if (entityConcept.getGlyphIcon() != null) {
            LOGGER.debug("entityConcept GlyphIcon already set. skipping addEntityGlyphIcon.", new Object[0]);
            return;
        }
        LOGGER.debug("addEntityGlyphIcon", new Object[0]);
        InputStream entityGlyphIconInputStream = OntologyRepositoryBase.class.getResourceAsStream(RESOURCE_ENTITY_PNG);
        Preconditions.checkNotNull((Object)entityGlyphIconInputStream, (Object)"Could not load resource entity.png");
        try {
            ByteArrayOutputStream imgOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)entityGlyphIconInputStream, (OutputStream)imgOut);
            byte[] rawImg = imgOut.toByteArray();
            this.addEntityGlyphIconToEntityConcept(entityConcept, rawImg);
        }
        catch (IOException e) {
            throw new VisalloException("invalid stream for glyph icon");
        }
    }

    protected abstract void addEntityGlyphIconToEntityConcept(Concept var1, byte[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String guessDocumentIRIFromPackage(File file) throws IOException, ZipException {
        ZipFile zipped = new ZipFile(file);
        if (zipped.isValidZipFile()) {
            File tempDir = Files.createTempDir();
            try {
                LOGGER.info("Extracting: %s to %s", file.getAbsoluteFile(), tempDir.getAbsolutePath());
                zipped.extractAll(tempDir.getAbsolutePath());
                File owlFile = this.findOwlFile(tempDir);
                String string = this.guessDocumentIRIFromFile(owlFile);
                return string;
            }
            finally {
                FileUtils.deleteDirectory((File)tempDir);
            }
        }
        if (file.isDirectory()) {
            file = this.findOwlFile(file);
        }
        return this.guessDocumentIRIFromFile(file);
    }

    public String guessDocumentIRIFromFile(File owlFile) throws IOException {
        try (FileInputStream owlFileIn = new FileInputStream(owlFile);){
            String owlContents = IOUtils.toString((InputStream)owlFileIn);
            Pattern iriRegex = Pattern.compile("<owl:Ontology rdf:about=\"(.*?)\">");
            Matcher m = iriRegex.matcher(owlContents);
            if (m.find()) {
                String string = m.group(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Override
    public void importFile(File inFile, IRI documentIRI, Authorizations authorizations) throws Exception {
        Preconditions.checkNotNull((Object)inFile, (Object)"inFile cannot be null");
        if (!inFile.exists()) {
            throw new VisalloException("File " + inFile + " does not exist");
        }
        File inDir = inFile.getParentFile();
        try (FileInputStream inFileIn = new FileInputStream(inFile);){
            LOGGER.debug("importing %s", inFile.getAbsolutePath());
            byte[] inFileData = IOUtils.toByteArray((InputStream)inFileIn);
            this.importFileData(inFileData, documentIRI, inDir, authorizations);
        }
    }

    @Override
    public void importFileData(byte[] inFileData, IRI documentIRI, File inDir, Authorizations authorizations) throws Exception {
        InputStreamReader inFileReader = new InputStreamReader(new ByteArrayInputStream(inFileData));
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        OWLOntologyManager m = this.createOwlOntologyManager(config, documentIRI);
        ReaderDocumentSource documentSource = new ReaderDocumentSource((Reader)inFileReader, documentIRI);
        OWLOntology o = m.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)documentSource, config);
        long totalStartTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        this.importOntologyAnnotationProperties(o, inDir, authorizations);
        this.clearCache();
        long endTime = System.currentTimeMillis();
        long importAnnotationPropertiesTime = endTime - startTime;
        startTime = System.currentTimeMillis();
        this.importOntologyClasses(o, inDir, authorizations);
        this.clearCache();
        endTime = System.currentTimeMillis();
        long importConceptsTime = endTime - startTime;
        startTime = System.currentTimeMillis();
        this.importObjectProperties(o, authorizations);
        this.clearCache();
        endTime = System.currentTimeMillis();
        long importObjectPropertiesTime = endTime - startTime;
        startTime = System.currentTimeMillis();
        this.importInverseOfObjectProperties(o);
        endTime = System.currentTimeMillis();
        long importInverseOfObjectPropertiesTime = endTime - startTime;
        long totalEndTime = System.currentTimeMillis();
        startTime = System.currentTimeMillis();
        this.importDataProperties(o);
        endTime = System.currentTimeMillis();
        long importDataPropertiesTime = endTime - startTime;
        LOGGER.debug("import annotation properties time: %dms", importAnnotationPropertiesTime);
        LOGGER.debug("import concepts time: %dms", importConceptsTime);
        LOGGER.debug("import data properties time: %dms", importDataPropertiesTime);
        LOGGER.debug("import object properties time: %dms", importObjectPropertiesTime);
        LOGGER.debug("import inverse of object properties time: %dms", importInverseOfObjectPropertiesTime);
        LOGGER.debug("import total time: %dms", totalEndTime - totalStartTime);
        this.storeOntologyFile(new ByteArrayInputStream(inFileData), documentIRI);
        this.clearCache();
    }

    private void importInverseOfObjectProperties(OWLOntology o) {
        for (OWLObjectProperty objectProperty : o.getObjectPropertiesInSignature()) {
            if (!o.isDeclared((OWLEntity)objectProperty, Imports.EXCLUDED)) continue;
            this.importInverseOf(o, objectProperty);
        }
    }

    private void importObjectProperties(OWLOntology o, Authorizations authorizations) {
        for (OWLObjectProperty objectProperty : o.getObjectPropertiesInSignature()) {
            this.importObjectProperty(o, objectProperty, authorizations);
        }
    }

    private void importDataProperties(OWLOntology o) {
        for (OWLDataProperty dataTypeProperty : o.getDataPropertiesInSignature()) {
            this.importDataProperty(o, dataTypeProperty);
        }
    }

    protected void importOntologyAnnotationProperties(OWLOntology o, File inDir, Authorizations authorizations) {
        for (OWLAnnotationProperty annotation : o.getAnnotationPropertiesInSignature()) {
            this.importOntologyAnnotationProperty(o, annotation, inDir, authorizations);
        }
    }

    protected void importOntologyAnnotationProperty(OWLOntology o, OWLAnnotationProperty annotationProperty, File inDir, Authorizations authorizations) {
    }

    private void importOntologyClasses(OWLOntology o, File inDir, Authorizations authorizations) throws IOException {
        for (OWLClass ontologyClass : o.getClassesInSignature()) {
            this.importOntologyClass(o, ontologyClass, inDir, authorizations);
        }
    }

    @Override
    public OWLOntologyManager createOwlOntologyManager(OWLOntologyLoaderConfiguration config, IRI excludeDocumentIRI) throws Exception {
        OWLOntologyManager m = OWLManager.createOWLOntologyManager();
        config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        this.loadOntologyFiles(m, config, excludeDocumentIRI);
        return m;
    }

    protected abstract void storeOntologyFile(InputStream var1, IRI var2);

    protected abstract List<OWLOntology> loadOntologyFiles(OWLOntologyManager var1, OWLOntologyLoaderConfiguration var2, IRI var3) throws Exception;

    private OWLOntology findOntology(List<OWLOntology> loadedOntologies, IRI documentIRI) {
        for (OWLOntology o : loadedOntologies) {
            Optional oIRI = o.getOntologyID().getOntologyIRI();
            if (!oIRI.isPresent() || !documentIRI.equals(oIRI.get())) continue;
            return o;
        }
        return null;
    }

    protected Concept importOntologyClass(OWLOntology o, OWLClass ontologyClass, File inDir, Authorizations authorizations) throws IOException {
        String uri = ontologyClass.getIRI().toString();
        if ("http://www.w3.org/2002/07/owl#Thing".equals(uri)) {
            return this.getEntityConcept();
        }
        String label = OntologyRepositoryBase.getLabel(o, (OWLEntity)ontologyClass);
        Preconditions.checkNotNull((Object)label, (Object)("label cannot be null or empty: " + uri));
        LOGGER.info("Importing ontology class " + uri + " (label: " + label + ")", new Object[0]);
        boolean isDeclaredInOntology = o.isDeclared((OWLEntity)ontologyClass);
        Concept parent = this.getParentConcept(o, ontologyClass, inDir, authorizations);
        Concept result = this.getOrCreateConcept(parent, uri, label, inDir, isDeclaredInOntology);
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)ontologyClass, (OWLOntology)o)) {
            boolean searchable;
            String annotationIri = annotation.getProperty().getIRI().toString();
            OWLLiteral valueLiteral = (OWLLiteral)annotation.getValue();
            String valueString = valueLiteral.getLiteral();
            if (annotationIri.equals(OntologyProperties.INTENT.getPropertyName())) {
                result.addIntent(valueString, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.SEARCHABLE.getPropertyName())) {
                searchable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.SEARCHABLE.getPropertyName(), searchable, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.SORTABLE.getPropertyName())) {
                boolean sortable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.SORTABLE.getPropertyName(), sortable, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.ADDABLE.getPropertyName())) {
                searchable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.ADDABLE.getPropertyName(), searchable, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.USER_VISIBLE.getPropertyName())) {
                boolean userVisible = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.USER_VISIBLE.getPropertyName(), userVisible, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.GLYPH_ICON_FILE_NAME.getPropertyName())) {
                this.setIconProperty(result, inDir, valueString, OntologyProperties.GLYPH_ICON.getPropertyName(), authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.GLYPH_ICON_SELECTED_FILE_NAME.getPropertyName())) {
                this.setIconProperty(result, inDir, valueString, OntologyProperties.GLYPH_ICON_SELECTED.getPropertyName(), authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.MAP_GLYPH_ICON_FILE_NAME.getPropertyName())) {
                this.setIconProperty(result, inDir, valueString, OntologyProperties.MAP_GLYPH_ICON.getPropertyName(), authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyName())) {
                if (valueString.trim().length() == 0) continue;
                result.setProperty(OntologyProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyName(), valueString.trim(), authorizations);
                continue;
            }
            if (annotationIri.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                result.setProperty(OntologyProperties.DISPLAY_NAME.getPropertyName(), valueString, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.UPDATEABLE.getPropertyName())) {
                boolean updateable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.UPDATEABLE.getPropertyName(), updateable, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.DELETEABLE.getPropertyName())) {
                boolean deleteable = Boolean.parseBoolean(valueString);
                result.setProperty(OntologyProperties.DELETEABLE.getPropertyName(), deleteable, authorizations);
                continue;
            }
            result.setProperty(annotationIri, valueString, authorizations);
        }
        return result;
    }

    protected void setIconProperty(Concept concept, File inDir, String glyphIconFileName, String propertyKey, Authorizations authorizations) throws IOException {
        if (glyphIconFileName != null) {
            File iconFile = new File(inDir, glyphIconFileName);
            if (!iconFile.exists()) {
                throw new RuntimeException("Could not find icon file: " + iconFile.toString());
            }
            try (FileInputStream iconFileIn = new FileInputStream(iconFile);){
                StreamingPropertyValue value = new StreamingPropertyValue((InputStream)iconFileIn, byte[].class);
                value.searchIndex(false);
                value.store(true);
                concept.setProperty(propertyKey, value, authorizations);
            }
        }
    }

    protected Concept getParentConcept(OWLOntology o, OWLClass ontologyClass, File inDir, Authorizations authorizations) throws IOException {
        Collection superClasses = EntitySearcher.getSuperClasses((OWLClass)ontologyClass, (OWLOntology)o);
        if (superClasses.size() == 0) {
            return this.getEntityConcept();
        }
        if (superClasses.size() == 1) {
            OWLClassExpression superClassExpr = (OWLClassExpression)superClasses.iterator().next();
            OWLClass superClass = superClassExpr.asOWLClass();
            String superClassUri = superClass.getIRI().toString();
            Concept parent = this.getConceptByIRI(superClassUri);
            if (parent != null) {
                return parent;
            }
            parent = this.importOntologyClass(o, superClass, inDir, authorizations);
            if (parent == null) {
                throw new VisalloException("Could not find or create parent: " + superClass);
            }
            return parent;
        }
        throw new VisalloException("Unhandled multiple super classes. Found " + superClasses.size() + ", expected 0 or 1.");
    }

    protected void importDataProperty(OWLOntology o, OWLDataProperty dataTypeProperty) {
        String propertyIRI = dataTypeProperty.getIRI().toString();
        try {
            String domainClassUri;
            String propertyDisplayName = OntologyRepositoryBase.getLabel(o, (OWLEntity)dataTypeProperty);
            PropertyType propertyType = this.getPropertyType(o, dataTypeProperty);
            boolean userVisible = this.getUserVisible(o, (OWLEntity)dataTypeProperty);
            boolean searchable = this.getSearchable(o, (OWLEntity)dataTypeProperty);
            boolean addable = this.getAddable(o, (OWLEntity)dataTypeProperty);
            boolean sortable = this.getSortable(o, (OWLEntity)dataTypeProperty);
            String displayType = this.getDisplayType(o, (OWLEntity)dataTypeProperty);
            String propertyGroup = this.getPropertyGroup(o, (OWLEntity)dataTypeProperty);
            String validationFormula = this.getValidationFormula(o, (OWLEntity)dataTypeProperty);
            String displayFormula = this.getDisplayFormula(o, (OWLEntity)dataTypeProperty);
            ImmutableList<String> dependentPropertyIris = this.getDependentPropertyIris(o, (OWLEntity)dataTypeProperty);
            Double boost = this.getBoost(o, (OWLEntity)dataTypeProperty);
            String[] intents = OntologyRepositoryBase.getIntents(o, (OWLEntity)dataTypeProperty);
            boolean deleteable = this.getDeleteable(o, (OWLEntity)dataTypeProperty);
            boolean updateable = this.getUpdateable(o, (OWLEntity)dataTypeProperty);
            if (propertyType == null) {
                throw new VisalloException("Could not get property type on data property " + propertyIRI);
            }
            ArrayList<Concept> domainConcepts = new ArrayList<Concept>();
            for (Object domainClassExpr : EntitySearcher.getDomains((OWLDataProperty)dataTypeProperty, (OWLOntology)o)) {
                OWLClass domainClass = domainClassExpr.asOWLClass();
                domainClassUri = domainClass.getIRI().toString();
                Concept domainConcept = this.getConceptByIRI(domainClassUri);
                if (domainConcept == null) {
                    LOGGER.error("Could not find class with uri: %s", domainClassUri);
                    continue;
                }
                LOGGER.info("Adding data property " + propertyIRI + " to class " + domainConcept.getIRI(), new Object[0]);
                domainConcepts.add(domainConcept);
            }
            ArrayList<Relationship> domainRelationships = new ArrayList<Relationship>();
            for (OWLAnnotation domainAnnotation : this.getObjectPropertyDomains(o, dataTypeProperty)) {
                domainClassUri = this.removeExtraQuotes(domainAnnotation.getValue().toString());
                Relationship domainRelationship = this.getRelationshipByIRI(domainClassUri);
                if (domainRelationship == null) {
                    LOGGER.error("Could not find relationship with uri: %s", domainClassUri);
                    continue;
                }
                LOGGER.info("Adding data property " + propertyIRI + " to relationship " + domainRelationship.getIRI(), new Object[0]);
                domainRelationships.add(domainRelationship);
            }
            Map<String, String> possibleValues = this.getPossibleValues(o, (OWLEntity)dataTypeProperty);
            Collection<TextIndexHint> textIndexHints = this.getTextIndexHints(o, dataTypeProperty);
            this.addPropertyTo(domainConcepts, domainRelationships, propertyIRI, propertyDisplayName, propertyType, possibleValues, textIndexHints, userVisible, searchable, addable, sortable, displayType, propertyGroup, boost, validationFormula, displayFormula, dependentPropertyIris, intents, deleteable, updateable);
        }
        catch (Throwable ex) {
            throw new VisalloException("Failed to load data property: " + propertyIRI, ex);
        }
    }

    private String removeExtraQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    @Override
    public OntologyProperty getOrCreateProperty(OntologyPropertyDefinition ontologyPropertyDefinition) {
        OntologyProperty property = this.getPropertyByIRI(ontologyPropertyDefinition.getPropertyIri());
        if (property != null) {
            return property;
        }
        return this.addPropertyTo(ontologyPropertyDefinition.getConcepts(), ontologyPropertyDefinition.getRelationships(), ontologyPropertyDefinition.getPropertyIri(), ontologyPropertyDefinition.getDisplayName(), ontologyPropertyDefinition.getDataType(), ontologyPropertyDefinition.getPossibleValues(), ontologyPropertyDefinition.getTextIndexHints(), ontologyPropertyDefinition.isUserVisible(), ontologyPropertyDefinition.isSearchable(), ontologyPropertyDefinition.isAddable(), ontologyPropertyDefinition.isSortable(), ontologyPropertyDefinition.getDisplayType(), ontologyPropertyDefinition.getPropertyGroup(), ontologyPropertyDefinition.getBoost(), ontologyPropertyDefinition.getValidationFormula(), ontologyPropertyDefinition.getDisplayFormula(), ontologyPropertyDefinition.getDependentPropertyIris(), ontologyPropertyDefinition.getIntents(), ontologyPropertyDefinition.getDeleteable(), ontologyPropertyDefinition.getUpdateable());
    }

    protected abstract OntologyProperty addPropertyTo(List<Concept> var1, List<Relationship> var2, String var3, String var4, PropertyType var5, Map<String, String> var6, Collection<TextIndexHint> var7, boolean var8, boolean var9, boolean var10, boolean var11, String var12, String var13, Double var14, String var15, String var16, ImmutableList<String> var17, String[] var18, boolean var19, boolean var20);

    protected Relationship importObjectProperty(OWLOntology o, OWLObjectProperty objectProperty, Authorizations authorizations) {
        String iri = objectProperty.getIRI().toString();
        String label = OntologyRepositoryBase.getLabel(o, (OWLEntity)objectProperty);
        Preconditions.checkNotNull((Object)label, (Object)("label cannot be null or empty for " + iri));
        LOGGER.info("Importing ontology object property " + iri + " (label: " + label + ")", new Object[0]);
        Relationship parent = this.getParentObjectProperty(o, objectProperty, authorizations);
        Relationship relationship = this.getOrCreateRelationshipType(parent, this.getDomainsConcepts(o, objectProperty), this.getRangesConcepts(o, objectProperty), iri);
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)objectProperty, (OWLOntology)o)) {
            String annotationIri = annotation.getProperty().getIRI().toString();
            OWLLiteral valueLiteral = (OWLLiteral)annotation.getValue();
            String valueString = valueLiteral.getLiteral();
            if (annotationIri.equals(OntologyProperties.INTENT.getPropertyName())) {
                relationship.addIntent(valueString, authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.USER_VISIBLE.getPropertyName())) {
                relationship.setProperty(OntologyProperties.USER_VISIBLE.getPropertyName(), Boolean.parseBoolean(valueString), authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.DELETEABLE.getPropertyName())) {
                relationship.setProperty(OntologyProperties.DELETEABLE.getPropertyName(), Boolean.parseBoolean(valueString), authorizations);
                continue;
            }
            if (annotationIri.equals(OntologyProperties.UPDATEABLE.getPropertyName())) {
                relationship.setProperty(OntologyProperties.UPDATEABLE.getPropertyName(), Boolean.parseBoolean(valueString), authorizations);
                continue;
            }
            if (annotationIri.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                relationship.setProperty(OntologyProperties.DISPLAY_NAME.getPropertyName(), valueString, authorizations);
                continue;
            }
            relationship.setProperty(annotationIri, valueString, authorizations);
        }
        return relationship;
    }

    private Relationship getParentObjectProperty(OWLOntology o, OWLObjectProperty objectProperty, Authorizations authorizations) {
        Collection superProperties = EntitySearcher.getSuperProperties((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o);
        if (superProperties.size() == 0) {
            return this.getOrCreateTopObjectPropertyRelationship(authorizations);
        }
        if (superProperties.size() == 1) {
            OWLObjectPropertyExpression superPropertyExpr = (OWLObjectPropertyExpression)superProperties.iterator().next();
            OWLObjectProperty superProperty = superPropertyExpr.asOWLObjectProperty();
            String superPropertyUri = superProperty.getIRI().toString();
            Relationship parent = this.getRelationshipByIRI(superPropertyUri);
            if (parent != null) {
                return parent;
            }
            parent = this.importObjectProperty(o, superProperty, authorizations);
            if (parent == null) {
                throw new VisalloException("Could not find or create parent: " + superProperty);
            }
            return parent;
        }
        throw new VisalloException("Unhandled multiple super properties. Found " + superProperties.size() + ", expected 0 or 1.");
    }

    protected void importInverseOf(OWLOntology o, OWLObjectProperty objectProperty) {
        String iri = objectProperty.getIRI().toString();
        Relationship fromRelationship = null;
        for (OWLObjectPropertyExpression inverseOf : EntitySearcher.getInverses((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o)) {
            if (!(inverseOf instanceof OWLObjectProperty)) continue;
            if (fromRelationship == null) {
                fromRelationship = this.getRelationshipByIRI(iri);
                Preconditions.checkNotNull((Object)fromRelationship, (Object)("could not find from relationship: " + iri));
            }
            OWLObjectProperty inverseOfOWLObjectProperty = (OWLObjectProperty)inverseOf;
            String inverseOfIri = inverseOfOWLObjectProperty.getIRI().toString();
            Relationship inverseOfRelationship = this.getRelationshipByIRI(inverseOfIri);
            this.getOrCreateInverseOfRelationship(fromRelationship, inverseOfRelationship);
        }
    }

    protected abstract void getOrCreateInverseOfRelationship(Relationship var1, Relationship var2);

    private Iterable<Concept> getRangesConcepts(OWLOntology o, OWLObjectProperty objectProperty) {
        ArrayList<Concept> ranges = new ArrayList<Concept>();
        for (OWLClassExpression rangeClassExpr : EntitySearcher.getRanges((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o)) {
            OWLClass rangeClass = rangeClassExpr.asOWLClass();
            String rangeClassUri = rangeClass.getIRI().toString();
            Concept ontologyClass = this.getConceptByIRI(rangeClassUri);
            if (ontologyClass == null) {
                LOGGER.error("Could not find class with uri: %s", rangeClassUri);
                continue;
            }
            ranges.add(ontologyClass);
        }
        return ranges;
    }

    private Iterable<Concept> getDomainsConcepts(OWLOntology o, OWLObjectProperty objectProperty) {
        ArrayList<Concept> domains = new ArrayList<Concept>();
        for (OWLClassExpression domainClassExpr : EntitySearcher.getDomains((OWLObjectPropertyExpression)objectProperty, (OWLOntology)o)) {
            OWLClass rangeClass = domainClassExpr.asOWLClass();
            String rangeClassUri = rangeClass.getIRI().toString();
            Concept ontologyClass = this.getConceptByIRI(rangeClassUri);
            if (ontologyClass == null) {
                LOGGER.error("Could not find class with uri: %s", rangeClassUri);
                continue;
            }
            domains.add(ontologyClass);
        }
        return domains;
    }

    protected PropertyType getPropertyType(OWLOntology o, OWLDataProperty dataTypeProperty) {
        Collection ranges = EntitySearcher.getRanges((OWLDataProperty)dataTypeProperty, (OWLOntology)o);
        if (ranges.size() == 0) {
            return null;
        }
        if (ranges.size() > 1) {
            throw new VisalloException("Unexpected number of ranges on data property " + dataTypeProperty.getIRI().toString());
        }
        for (OWLDataRange range : ranges) {
            if (!(range instanceof OWLDatatype)) continue;
            OWLDatatype datatype = (OWLDatatype)range;
            return this.getPropertyType(datatype.getIRI().toString());
        }
        throw new VisalloException("Could not find range on data property " + dataTypeProperty.getIRI().toString());
    }

    private PropertyType getPropertyType(String iri) {
        if ("http://www.w3.org/2001/XMLSchema#string".equals(iri)) {
            return PropertyType.STRING;
        }
        if ("http://www.w3.org/2001/XMLSchema#dateTime".equals(iri)) {
            return PropertyType.DATE;
        }
        if ("http://www.w3.org/2001/XMLSchema#date".equals(iri)) {
            return PropertyType.DATE;
        }
        if ("http://www.w3.org/2001/XMLSchema#gYear".equals(iri)) {
            return PropertyType.DATE;
        }
        if ("http://www.w3.org/2001/XMLSchema#gYearMonth".equals(iri)) {
            return PropertyType.DATE;
        }
        if ("http://www.w3.org/2001/XMLSchema#int".equals(iri)) {
            return PropertyType.DOUBLE;
        }
        if ("http://www.w3.org/2001/XMLSchema#double".equals(iri)) {
            return PropertyType.DOUBLE;
        }
        if ("http://www.w3.org/2001/XMLSchema#float".equals(iri)) {
            return PropertyType.DOUBLE;
        }
        if ("http://visallo.org#geolocation".equals(iri)) {
            return PropertyType.GEO_LOCATION;
        }
        if ("http://visallo.org#directory/entity".equals(iri)) {
            return PropertyType.DIRECTORY_ENTITY;
        }
        if ("http://visallo.org#currency".equals(iri)) {
            return PropertyType.CURRENCY;
        }
        if ("http://visallo.org#image".equals(iri)) {
            return PropertyType.IMAGE;
        }
        if ("http://www.w3.org/2001/XMLSchema#hexBinary".equals(iri)) {
            return PropertyType.BINARY;
        }
        if ("http://www.w3.org/2001/XMLSchema#boolean".equals(iri)) {
            return PropertyType.BOOLEAN;
        }
        if ("http://www.w3.org/2001/XMLSchema#integer".equals(iri)) {
            return PropertyType.INTEGER;
        }
        if ("http://www.w3.org/2001/XMLSchema#nonNegativeInteger".equals(iri)) {
            return PropertyType.INTEGER;
        }
        if ("http://www.w3.org/2001/XMLSchema#positiveInteger".equals(iri)) {
            return PropertyType.INTEGER;
        }
        if ("http://www.w3.org/2001/XMLSchema#unsignedLong".equals(iri)) {
            return PropertyType.INTEGER;
        }
        if ("http://www.w3.org/2001/XMLSchema#unsignedByte".equals(iri)) {
            return PropertyType.INTEGER;
        }
        throw new VisalloException("Unhandled property type " + iri);
    }

    protected Iterable<OWLAnnotation> getObjectPropertyDomains(OWLOntology o, OWLDataProperty owlDataTypeProperty) {
        ArrayList<OWLAnnotation> results = new ArrayList<OWLAnnotation>();
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)owlDataTypeProperty, (OWLOntology)o)) {
            if (!annotation.getProperty().getIRI().toString().equals(OBJECT_PROPERTY_DOMAIN_IRI)) continue;
            results.add(annotation);
        }
        return results;
    }

    protected String getDisplayType(OWLOntology o, OWLEntity owlEntity) {
        return this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.DISPLAY_TYPE.getPropertyName());
    }

    protected String getPropertyGroup(OWLOntology o, OWLEntity owlEntity) {
        return this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.PROPERTY_GROUP.getPropertyName());
    }

    protected String getValidationFormula(OWLOntology o, OWLEntity owlEntity) {
        return this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.VALIDATION_FORMULA.getPropertyName());
    }

    protected String getDisplayFormula(OWLOntology o, OWLEntity owlEntity) {
        return this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.DISPLAY_FORMULA.getPropertyName());
    }

    protected ImmutableList<String> getDependentPropertyIris(OWLOntology o, OWLEntity owlEntity) {
        ArrayList<String> results = new ArrayList<String>();
        ImmutableList<String> dependentPropertyIris = this.getAnnotationValuesByUriOrNull(o, owlEntity, "http://visallo.org#dependentPropertyIris");
        this.addAllDependentPropertyIris(results, dependentPropertyIris);
        ImmutableList<String> dependentPropertyIri = this.getAnnotationValuesByUriOrNull(o, owlEntity, "http://visallo.org#dependentPropertyIri");
        this.addAllDependentPropertyIris(results, dependentPropertyIri);
        if (results.size() == 0) {
            return null;
        }
        return ImmutableList.copyOf(results);
    }

    private void addAllDependentPropertyIris(List<String> results, ImmutableList<String> dependentPropertyIris) {
        if (dependentPropertyIris == null) {
            return;
        }
        for (String dependentPropertyIri : dependentPropertyIris) {
            if ((dependentPropertyIri = dependentPropertyIri.trim()).startsWith("[")) {
                JSONArray array = new JSONArray(dependentPropertyIri);
                for (int i = 0; i < array.length(); ++i) {
                    results.add(array.getString(i));
                }
                continue;
            }
            results.add(dependentPropertyIri);
        }
    }

    protected Double getBoost(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.BOOST.getPropertyName());
        if (val == null) {
            return null;
        }
        return Double.parseDouble(val);
    }

    protected boolean getUserVisible(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.USER_VISIBLE.getPropertyName());
        return val == null || Boolean.parseBoolean(val);
    }

    protected boolean getSearchable(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.SEARCHABLE.getPropertyName());
        return val == null || Boolean.parseBoolean(val);
    }

    protected boolean getAddable(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.ADDABLE.getPropertyName());
        return val == null || Boolean.parseBoolean(val);
    }

    protected boolean getSortable(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.SORTABLE.getPropertyName());
        return val == null || Boolean.parseBoolean(val);
    }

    protected boolean getUpdateable(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.UPDATEABLE.getPropertyName());
        return val == null || Boolean.parseBoolean(val);
    }

    protected boolean getDeleteable(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.DELETEABLE.getPropertyName());
        return val == null || Boolean.parseBoolean(val);
    }

    protected Map<String, String> getPossibleValues(OWLOntology o, OWLEntity owlEntity) {
        String val = this.getAnnotationValueByUri(o, owlEntity, OntologyProperties.POSSIBLE_VALUES.getPropertyName());
        if (val == null || val.trim().length() == 0) {
            return null;
        }
        return JSONUtil.toStringMap(new JSONObject(val));
    }

    protected Collection<TextIndexHint> getTextIndexHints(OWLOntology o, OWLDataProperty owlEntity) {
        return TextIndexHint.parse((String)this.getAnnotationValueByUri(o, (OWLEntity)owlEntity, OntologyProperties.TEXT_INDEX_HINTS.getPropertyName()));
    }

    protected String getAnnotationValueByUri(OWLOntology o, OWLEntity owlEntity, String uri) {
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)owlEntity, (OWLOntology)o)) {
            if (!annotation.getProperty().getIRI().toString().equals(uri)) continue;
            OWLLiteral value = (OWLLiteral)annotation.getValue();
            return value.getLiteral();
        }
        return null;
    }

    protected ImmutableList<String> getAnnotationValuesByUriOrNull(OWLOntology o, OWLEntity owlEntity, String uri) {
        ArrayList<String> values = new ArrayList<String>();
        for (OWLAnnotation annotation : EntitySearcher.getAnnotations((OWLEntity)owlEntity, (OWLOntology)o)) {
            if (!annotation.getProperty().getIRI().toString().equals(uri)) continue;
            OWLLiteral value = (OWLLiteral)annotation.getValue();
            values.add(value.getLiteral());
        }
        if (values.size() == 0) {
            return null;
        }
        return ImmutableList.copyOf(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePackage(File file, IRI documentIRI, Authorizations authorizations) throws Exception {
        if (!file.exists()) {
            throw new VisalloException("OWL file does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new VisalloException("OWL file is not a file: " + file.getAbsolutePath());
        }
        ZipFile zipped = new ZipFile(file);
        if (zipped.isValidZipFile()) {
            File tempDir = Files.createTempDir();
            try {
                LOGGER.info("Extracting: %s to %s", file.getAbsoluteFile(), tempDir.getAbsolutePath());
                zipped.extractAll(tempDir.getAbsolutePath());
                File owlFile = this.findOwlFile(tempDir);
                this.importFile(owlFile, documentIRI, authorizations);
            }
            finally {
                FileUtils.deleteDirectory((File)tempDir);
            }
        } else {
            this.importFile(file, documentIRI, authorizations);
        }
    }

    protected File findOwlFile(File fileOrDir) {
        if (fileOrDir.isFile()) {
            return fileOrDir;
        }
        File[] files = fileOrDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File child : files) {
            if (child.isDirectory()) {
                File found = this.findOwlFile(child);
                if (found == null) continue;
                return found;
            }
            if (!child.getName().toLowerCase().endsWith(".owl")) continue;
            return child;
        }
        return null;
    }

    @Override
    public Set<Concept> getConceptAndAllChildrenByIri(String conceptIRI) {
        Concept concept = this.getConceptByIRI(conceptIRI);
        if (concept == null) {
            return null;
        }
        return this.getConceptAndAllChildren(concept);
    }

    @Override
    public Set<Concept> getConceptAndAllChildren(Concept concept) {
        List<Concept> childConcepts = this.getChildConcepts(concept);
        HashSet result = Sets.newHashSet((Object[])new Concept[]{concept});
        if (childConcepts.size() > 0) {
            ArrayList<Concept> childrenList = new ArrayList<Concept>();
            for (Concept childConcept : childConcepts) {
                Set<Concept> child = this.getConceptAndAllChildren(childConcept);
                childrenList.addAll(child);
            }
            result.addAll(childrenList);
        }
        return result;
    }

    protected abstract List<Concept> getChildConcepts(Concept var1);

    @Override
    public Set<Relationship> getRelationshipAndAllChildren(Relationship relationship) {
        List<Relationship> childRelationships = this.getChildRelationships(relationship);
        HashSet result = Sets.newHashSet((Object[])new Relationship[]{relationship});
        if (childRelationships.size() > 0) {
            ArrayList<Relationship> childrenList = new ArrayList<Relationship>();
            for (Relationship childRelationship : childRelationships) {
                Set<Relationship> child = this.getRelationshipAndAllChildren(childRelationship);
                childrenList.addAll(child);
            }
            result.addAll(childrenList);
        }
        return result;
    }

    protected abstract List<Relationship> getChildRelationships(Relationship var1);

    @Override
    public void resolvePropertyIds(JSONArray filterJson) throws JSONException {
        for (int i = 0; i < filterJson.length(); ++i) {
            JSONObject filter = filterJson.getJSONObject(i);
            if (!filter.has("propertyId") || filter.has("propertyName")) continue;
            String propertyVertexId = filter.getString("propertyId");
            OntologyProperty property = this.getPropertyByIRI(propertyVertexId);
            if (property == null) {
                throw new RuntimeException("Could not find property with id: " + propertyVertexId);
            }
            filter.put("propertyName", (Object)property.getTitle());
            filter.put("propertyDataType", (Object)property.getDataType());
        }
    }

    @Override
    public Concept getConceptByIRI(String conceptIRI) {
        for (Concept concept : this.getConceptsWithProperties()) {
            if (!concept.getIRI().equals(conceptIRI)) continue;
            return concept;
        }
        return null;
    }

    @Override
    public OntologyProperty getPropertyByIRI(String propertyIRI) {
        for (OntologyProperty prop : this.getProperties()) {
            if (!prop.getTitle().equals(propertyIRI)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public OntologyProperty getRequiredPropertyByIRI(String propertyIRI) {
        OntologyProperty property = this.getPropertyByIRI(propertyIRI);
        if (property == null) {
            throw new VisalloException("Could not find property by IRI: " + propertyIRI);
        }
        return property;
    }

    @Override
    public Relationship getRelationshipByIRI(String relationshipIRI) {
        for (Relationship rel : this.getRelationships()) {
            if (!rel.getIRI().equals(relationshipIRI)) continue;
            return rel;
        }
        return null;
    }

    @Override
    public Concept getConceptByIntent(String intent) {
        String configurationKey = "ontology.intent.concept." + intent;
        String conceptIri = this.getConfiguration().get(configurationKey, null);
        if (conceptIri != null) {
            Concept concept = this.getConceptByIRI(conceptIri);
            if (concept == null) {
                throw new VisalloException("Could not find concept by configuration key: " + configurationKey);
            }
            return concept;
        }
        List<Concept> concepts = this.findLoadedConceptsByIntent(intent);
        if (concepts.size() == 0) {
            return null;
        }
        if (concepts.size() == 1) {
            return concepts.get(0);
        }
        String iris = Joiner.on((char)',').join((Iterable)new ConvertingIterable<Concept, String>(concepts){

            protected String convert(Concept o) {
                return o.getIRI();
            }
        });
        throw new VisalloException("Found multiple concepts for intent: " + intent + " (" + iris + ")");
    }

    @Override
    public String getConceptIRIByIntent(String intent) {
        Concept concept = this.getConceptByIntent(intent);
        if (concept != null) {
            return concept.getIRI();
        }
        return null;
    }

    @Override
    public Concept getRequiredConceptByIntent(String intent) {
        Concept concept = this.getConceptByIntent(intent);
        if (concept == null) {
            throw new VisalloException("Could not find concept by intent: " + intent);
        }
        return concept;
    }

    @Override
    public String getRequiredConceptIRIByIntent(String intent) {
        return this.getRequiredConceptByIntent(intent).getIRI();
    }

    @Override
    public Concept getRequiredConceptByIRI(String iri) {
        Concept concept = this.getConceptByIRI(iri);
        if (concept == null) {
            throw new VisalloException("Could not find concept by IRI: " + iri);
        }
        return concept;
    }

    private List<Concept> findLoadedConceptsByIntent(String intent) {
        ArrayList<Concept> results = new ArrayList<Concept>();
        for (Concept concept : this.getConceptsWithProperties()) {
            String[] conceptIntents = concept.getIntents();
            if (!Arrays.asList(conceptIntents).contains(intent)) continue;
            results.add(concept);
        }
        return results;
    }

    @Override
    public Relationship getRelationshipByIntent(String intent) {
        String configurationKey = "ontology.intent.relationship." + intent;
        String relationshipIri = this.getConfiguration().get(configurationKey, null);
        if (relationshipIri != null) {
            Relationship relationship = this.getRelationshipByIRI(relationshipIri);
            if (relationship == null) {
                throw new VisalloException("Could not find relationship by configuration key: " + configurationKey);
            }
            return relationship;
        }
        List<Relationship> relationships = this.findLoadedRelationshipsByIntent(intent);
        if (relationships.size() == 0) {
            return null;
        }
        if (relationships.size() == 1) {
            return relationships.get(0);
        }
        String iris = Joiner.on((char)',').join((Iterable)new ConvertingIterable<Relationship, String>(relationships){

            protected String convert(Relationship o) {
                return o.getIRI();
            }
        });
        throw new VisalloException("Found multiple relationships for intent: " + intent + " (" + iris + ")");
    }

    @Override
    public String getRelationshipIRIByIntent(String intent) {
        Relationship relationship = this.getRelationshipByIntent(intent);
        if (relationship != null) {
            return relationship.getIRI();
        }
        return null;
    }

    @Override
    public Relationship getRequiredRelationshipByIntent(String intent) {
        Relationship relationship = this.getRelationshipByIntent(intent);
        if (relationship == null) {
            throw new VisalloException("Could not find relationship by intent: " + intent);
        }
        return relationship;
    }

    @Override
    public String getRequiredRelationshipIRIByIntent(String intent) {
        return this.getRequiredRelationshipByIntent(intent).getIRI();
    }

    private List<Relationship> findLoadedRelationshipsByIntent(String intent) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship relationship : this.getRelationships()) {
            String[] relationshipIntents = relationship.getIntents();
            if (!Arrays.asList(relationshipIntents).contains(intent)) continue;
            results.add(relationship);
        }
        return results;
    }

    @Override
    public OntologyProperty getPropertyByIntent(String intent) {
        String configurationKey = "ontology.intent.property." + intent;
        String propertyIri = this.getConfiguration().get(configurationKey, null);
        if (propertyIri != null) {
            OntologyProperty property = this.getPropertyByIRI(propertyIri);
            if (property == null) {
                throw new VisalloException("Could not find property by configuration key: " + configurationKey);
            }
            return property;
        }
        List<OntologyProperty> properties = this.getPropertiesByIntent(intent);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return properties.get(0);
        }
        String iris = Joiner.on((char)',').join((Iterable)new ConvertingIterable<OntologyProperty, String>(properties){

            protected String convert(OntologyProperty o) {
                return o.getTitle();
            }
        });
        throw new VisalloException("Found multiple properties for intent: " + intent + " (" + iris + ")");
    }

    @Override
    public String getPropertyIRIByIntent(String intent) {
        OntologyProperty prop = this.getPropertyByIntent(intent);
        if (prop != null) {
            return prop.getTitle();
        }
        return null;
    }

    @Override
    public OntologyProperty getRequiredPropertyByIntent(String intent) {
        OntologyProperty property = this.getPropertyByIntent(intent);
        if (property == null) {
            throw new VisalloException("Could not find property by intent: " + intent);
        }
        return property;
    }

    @Override
    public String getRequiredPropertyIRIByIntent(String intent) {
        return this.getRequiredPropertyByIntent(intent).getTitle();
    }

    @Override
    public OntologyProperty getDependentPropertyParent(String iri) {
        for (OntologyProperty property : this.getProperties()) {
            if (!property.getDependentPropertyIris().contains((Object)iri)) continue;
            return property;
        }
        return null;
    }

    @Override
    public <T extends VisalloProperty> T getVisalloPropertyByIntent(String intent, Class<T> visalloPropertyType) {
        String propertyIri = this.getPropertyIRIByIntent(intent);
        if (propertyIri == null) {
            LOGGER.warn("No property found for intent: %s", intent);
            return null;
        }
        try {
            Constructor<T> constructor = visalloPropertyType.getConstructor(String.class);
            return (T)((VisalloProperty)constructor.newInstance(propertyIri));
        }
        catch (Exception ex) {
            throw new VisalloException("Could not create property for intent: " + intent + " (propertyIri: " + propertyIri + ")");
        }
    }

    @Override
    public <T extends VisalloProperty> T getRequiredVisalloPropertyByIntent(String intent, Class<T> visalloPropertyType) {
        T result = this.getVisalloPropertyByIntent(intent, visalloPropertyType);
        if (result == null) {
            throw new VisalloException("Could not find property by intent: " + intent);
        }
        return result;
    }

    @Override
    public List<OntologyProperty> getPropertiesByIntent(String intent) {
        ArrayList<OntologyProperty> results = new ArrayList<OntologyProperty>();
        for (OntologyProperty property : this.getProperties()) {
            String[] propertyIntents = property.getIntents();
            if (!Arrays.asList(propertyIntents).contains(intent)) continue;
            results.add(property);
        }
        return results;
    }

    @Override
    public ClientApiOntology getClientApiObject() {
        T[] results = ExecutorServiceUtil.runAllAndWait(new Callable<Object>(){

            @Override
            public Object call() {
                Iterable<Concept> concepts = OntologyRepositoryBase.this.getConceptsWithProperties();
                return Concept.toClientApiConcepts(concepts);
            }
        }, new Callable<Object>(){

            @Override
            public Object call() {
                Iterable<OntologyProperty> properties = OntologyRepositoryBase.this.getProperties();
                return OntologyProperty.toClientApiProperties(properties);
            }
        }, new Callable<Object>(){

            @Override
            public Object call() {
                Iterable<Relationship> relationships = OntologyRepositoryBase.this.getRelationships();
                return Relationship.toClientApiRelationships(relationships);
            }
        });
        ClientApiOntology ontology = new ClientApiOntology();
        ontology.addAllConcepts((Collection)results[0]);
        ontology.addAllProperties((Collection)results[1]);
        ontology.addAllRelationships((Collection)results[2]);
        return ontology;
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    protected void definePropertyOnGraph(Graph graph, String propertyIri, PropertyType dataType, Collection<TextIndexHint> textIndexHints, Double boost, boolean sortable) {
        DefinePropertyBuilder definePropertyBuilder = graph.defineProperty(propertyIri).sortable(sortable);
        definePropertyBuilder.dataType(PropertyType.getTypeClass((PropertyType)dataType));
        if (dataType == PropertyType.DIRECTORY_ENTITY) {
            definePropertyBuilder.textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH});
        } else if (dataType == PropertyType.STRING) {
            definePropertyBuilder.textIndexHint(textIndexHints);
        }
        if (boost != null) {
            if (graph.isFieldBoostSupported()) {
                definePropertyBuilder.boost(boost.doubleValue());
            } else {
                LOGGER.warn("Field boosting is not support by the graph", new Object[0]);
            }
        }
        definePropertyBuilder.define();
    }

    protected boolean determineSearchable(String propertyIri, PropertyType dataType, Collection<TextIndexHint> textIndexHints, boolean searchable) {
        if (dataType == PropertyType.STRING) {
            Preconditions.checkNotNull(textIndexHints, (Object)"textIndexHints are required for string properties");
            if (searchable && (textIndexHints.isEmpty() || textIndexHints.equals(TextIndexHint.NONE))) {
                searchable = false;
            } else if (!(searchable || textIndexHints.isEmpty() && textIndexHints.equals(TextIndexHint.NONE))) {
                LOGGER.info("textIndexHints was specified for non-UI-searchable string property:: " + propertyIri, new Object[0]);
            }
        }
        return searchable;
    }

    @Override
    public void addConceptTypeFilterToQuery(Query query, String conceptTypeIri, boolean includeChildNodes) {
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        Preconditions.checkNotNull((Object)conceptTypeIri, (Object)"conceptTypeIri cannot be null");
        Concept concept = this.getConceptByIRI(conceptTypeIri);
        Preconditions.checkNotNull((Object)concept, (Object)("Could not find concept with IRI: " + conceptTypeIri));
        if (includeChildNodes) {
            Set<Concept> childConcepts = this.getConceptAndAllChildren(concept);
            if (childConcepts.size() > 0) {
                String[] conceptIds = new String[childConcepts.size()];
                int count = 0;
                for (Concept c : childConcepts) {
                    conceptIds[count] = c.getIRI();
                    ++count;
                }
                query.has(VisalloProperties.CONCEPT_TYPE.getPropertyName(), (Predicate)Contains.IN, (Object)conceptIds);
            }
        } else {
            query.has(VisalloProperties.CONCEPT_TYPE.getPropertyName(), (Object)conceptTypeIri);
        }
    }

    @Override
    public void addEdgeLabelFilterToQuery(Query query, String edgeLabel, boolean includeChildNodes) {
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        Preconditions.checkNotNull((Object)edgeLabel, (Object)"edgeLabel cannot be null");
        Relationship relationship = this.getRelationshipByIRI(edgeLabel);
        if (includeChildNodes) {
            Set<Relationship> childRelationships = this.getRelationshipAndAllChildren(relationship);
            if (childRelationships.size() > 0) {
                String[] relationshipIds = new String[childRelationships.size()];
                int count = 0;
                for (Relationship r : childRelationships) {
                    relationshipIds[count] = r.getIRI();
                    ++count;
                }
                query.hasEdgeLabel(relationshipIds);
            }
        } else {
            query.hasEdgeLabel(new String[]{edgeLabel});
        }
    }
}

