/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.user.AuthorizationContext;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.PrivilegesProvider;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.Privilege;

public abstract class PrivilegeRepositoryBase
implements PrivilegeRepository {
    private final Iterable<PrivilegesProvider> privilegesProviders;
    private UserRepository userRepository;

    protected PrivilegeRepositoryBase(Configuration configuration) {
        this.privilegesProviders = this.getPrivilegesProviders(configuration);
    }

    protected Iterable<PrivilegesProvider> getPrivilegesProviders(Configuration configuration) {
        return InjectHelper.getInjectedServices(PrivilegesProvider.class, configuration);
    }

    @Override
    public boolean hasPrivilege(User user, String privilege) {
        Set<String> privileges = this.getPrivileges(user);
        return privileges.contains(privilege);
    }

    @Override
    public boolean hasAllPrivileges(User user, Set<String> requiredPrivileges) {
        return Privilege.hasAll(this.getPrivileges(user), requiredPrivileges);
    }

    protected UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }

    @VisibleForTesting
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public abstract void updateUser(User var1, AuthorizationContext var2);

    @Override
    public abstract Set<String> getPrivileges(User var1);

    @Override
    public Set<Privilege> getAllPrivileges() {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        for (PrivilegesProvider privilegesProvider : this.privilegesProviders) {
            for (Privilege privilege : privilegesProvider.getPrivileges()) {
                privileges.add(privilege);
            }
        }
        return privileges;
    }

    protected Privilege findPrivilegeByName(String privilegeName) {
        for (Privilege p : this.getAllPrivileges()) {
            if (!p.getName().equals(privilegeName)) continue;
            return p;
        }
        return null;
    }
}

