/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.vertexium.Graph;
import org.vertexium.TextIndexHint;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configurable;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.notification.ExpirationAge;
import org.visallo.core.model.notification.UserNotification;
import org.visallo.core.model.notification.UserNotificationRepository;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyPropertyDefinition;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.user.AuthorizationContext;
import org.visallo.core.model.user.AuthorizationRepositoryBase;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.model.user.UserListener;
import org.visallo.core.model.user.UserPropertyAuthorizationRepositoryCliService;
import org.visallo.core.model.user.cli.AuthorizationRepositoryCliService;
import org.visallo.core.model.user.cli.AuthorizationRepositoryWithCliSupport;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.user.SystemUser;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.PropertyType;

public class UserPropertyAuthorizationRepository
extends AuthorizationRepositoryBase
implements AuthorizationRepositoryWithCliSupport {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(UserPropertyAuthorizationRepository.class);
    public static final String AUTHORIZATIONS_PROPERTY_IRI = "http://visallo.org/user#authorizations";
    public static final String CONFIGURATION_PREFIX = UserPropertyAuthorizationRepository.class.getName();
    private static final String SEPARATOR = ",";
    private final ImmutableSet<String> defaultAuthorizations;
    private final Configuration configuration;
    private final UserNotificationRepository userNotificationRepository;
    private final WorkQueueRepository workQueueRepository;
    private Collection<UserListener> userListeners;
    private GraphAuthorizationRepository authorizationRepository;

    @Inject
    public UserPropertyAuthorizationRepository(Graph graph, OntologyRepository ontologyRepository, Configuration configuration, UserNotificationRepository userNotificationRepository, WorkQueueRepository workQueueRepository, GraphAuthorizationRepository authorizationRepository) {
        super(graph);
        this.configuration = configuration;
        this.userNotificationRepository = userNotificationRepository;
        this.workQueueRepository = workQueueRepository;
        this.authorizationRepository = authorizationRepository;
        this.defineAuthorizationsProperty(ontologyRepository);
        Settings settings = new Settings();
        configuration.setConfigurables(settings, CONFIGURATION_PREFIX);
        this.defaultAuthorizations = this.parseAuthorizations(settings.defaultAuthorizations);
        if (settings.defaultAuthorizations.length() > 0) {
            authorizationRepository.addAuthorizationToGraph(settings.defaultAuthorizations.split(SEPARATOR));
        }
    }

    private void defineAuthorizationsProperty(OntologyRepository ontologyRepository) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        concepts.add(ontologyRepository.getConceptByIRI("http://visallo.org/user#user"));
        OntologyPropertyDefinition propertyDefinition = new OntologyPropertyDefinition(concepts, AUTHORIZATIONS_PROPERTY_IRI, "Authorizations", PropertyType.STRING);
        propertyDefinition.setUserVisible(false);
        propertyDefinition.setTextIndexHints(TextIndexHint.NONE);
        ontologyRepository.getOrCreateProperty(propertyDefinition);
    }

    private ImmutableSet<String> parseAuthorizations(String authorizations) {
        Preconditions.checkNotNull((Object)authorizations, (Object)"authorizations cannot be null");
        List auths = Lists.newArrayList((Object[])authorizations.split(SEPARATOR)).stream().map(String::trim).filter(a -> a.length() > 0).collect(Collectors.toList());
        return ImmutableSet.copyOf(auths);
    }

    @Override
    public void updateUser(User user, AuthorizationContext authorizationContext) {
    }

    @Override
    public Set<String> getAuthorizations(User user) {
        if (user instanceof SystemUser) {
            return Sets.newHashSet((Object[])new String[]{"visallo"});
        }
        String authorizations = (String)user.getProperty(AUTHORIZATIONS_PROPERTY_IRI);
        if (authorizations == null) {
            return new HashSet<String>((Collection<String>)this.defaultAuthorizations);
        }
        return Sets.newHashSet(this.parseAuthorizations(authorizations));
    }

    public void addAuthorization(User user, String auth, User authUser) {
        Set<String> auths = this.getAuthorizations(user);
        if (!auths.contains(auth)) {
            LOGGER.info("Adding authorization '%s' to user '%s' by '%s'", auth, user.getUsername(), authUser.getUsername());
            auths.add(auth);
            this.authorizationRepository.addAuthorizationToGraph(auth);
            this.getUserRepository().setPropertyOnUser(user, AUTHORIZATIONS_PROPERTY_IRI, Joiner.on((String)SEPARATOR).join(auths));
            this.sendNotificationToUserAboutAddAuthorization(user, auth, authUser);
            this.fireUserAddAuthorizationEvent(user, auth);
        }
    }

    public void removeAuthorization(User user, String auth, User authUser) {
        Set<String> auths = this.getAuthorizations(user);
        if (auths.contains(auth)) {
            LOGGER.info("Removing authorization '%s' to user '%s' by '%s'", auth, user.getUsername(), authUser.getUsername());
            auths.remove(auth);
            this.getUserRepository().setPropertyOnUser(user, AUTHORIZATIONS_PROPERTY_IRI, Joiner.on((String)SEPARATOR).join(auths));
            this.sendNotificationToUserAboutRemoveAuthorization(user, auth, authUser);
            this.fireUserRemoveAuthorizationEvent(user, auth);
        }
    }

    public void setAuthorizations(User user, Set<String> newAuthorizations, User authUser) {
        String[] newAuthorizationsArray = newAuthorizations.toArray(new String[newAuthorizations.size()]);
        this.authorizationRepository.addAuthorizationToGraph(newAuthorizationsArray);
        String newAuthorizationsString = Joiner.on((String)SEPARATOR).join(newAuthorizations);
        LOGGER.info("Setting authorizations '%s' to user '%s' by '%s'", newAuthorizationsString, user.getUsername(), authUser.getUsername());
        Set<String> currentAuthorizations = this.getAuthorizations(user);
        this.getUserRepository().setPropertyOnUser(user, AUTHORIZATIONS_PROPERTY_IRI, newAuthorizationsString);
        HashSet<String> addedAuthorizations = new HashSet<String>(newAuthorizations);
        addedAuthorizations.removeAll(currentAuthorizations);
        for (String auth : addedAuthorizations) {
            this.sendNotificationToUserAboutAddAuthorization(user, auth, authUser);
            this.fireUserAddAuthorizationEvent(user, auth);
        }
        HashSet<String> removedAuthorizations = new HashSet<String>(currentAuthorizations);
        removedAuthorizations.removeAll(newAuthorizations);
        for (String auth : removedAuthorizations) {
            this.sendNotificationToUserAboutRemoveAuthorization(user, auth, authUser);
            this.fireUserRemoveAuthorizationEvent(user, auth);
        }
    }

    private void sendNotificationToUserAboutAddAuthorization(User user, String auth, User authUser) {
        String title = "Authorization Added";
        String message = "Authorization Added: " + auth;
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.workQueueRepository.pushUserNotification(userNotification);
    }

    private void sendNotificationToUserAboutRemoveAuthorization(User user, String auth, User authUser) {
        String title = "Authorization Removed";
        String message = "Authorization Removed: " + auth;
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.workQueueRepository.pushUserNotification(userNotification);
    }

    private void fireUserAddAuthorizationEvent(User user, String auth) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userAddAuthorization(user, auth);
        }
    }

    private void fireUserRemoveAuthorizationEvent(User user, String auth) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userRemoveAuthorization(user, auth);
        }
    }

    private Collection<UserListener> getUserListeners() {
        if (this.userListeners == null) {
            this.userListeners = InjectHelper.getInjectedServices(UserListener.class, this.configuration);
        }
        return this.userListeners;
    }

    @Override
    public AuthorizationRepositoryCliService getCliService() {
        return new UserPropertyAuthorizationRepositoryCliService(this);
    }

    public ImmutableSet<String> getDefaultAuthorizations() {
        return this.defaultAuthorizations;
    }

    private static class Settings {
        @Configurable
        public String defaultAuthorizations;

        private Settings() {
        }
    }
}

