/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.security;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.HasOntologyProperties;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiEdge;
import org.visallo.web.clientapi.model.ClientApiEdgeMultipleResponse;
import org.visallo.web.clientapi.model.ClientApiEdgeSearchResponse;
import org.visallo.web.clientapi.model.ClientApiEdgeWithVertexData;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiElementAcl;
import org.visallo.web.clientapi.model.ClientApiElementSearchResponse;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.ClientApiProperty;
import org.visallo.web.clientapi.model.ClientApiPropertyAcl;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.clientapi.model.ClientApiVertexEdges;
import org.visallo.web.clientapi.model.ClientApiVertexMultipleResponse;
import org.visallo.web.clientapi.model.ClientApiWorkspaceVertices;

public abstract class ACLProvider {
    protected final Graph graph;
    protected final UserRepository userRepository;
    protected final OntologyRepository ontologyRepository;
    private final PrivilegeRepository privilegeRepository;
    private final AuthorizationRepository authorizationRepository;

    @Inject
    protected ACLProvider(Graph graph, UserRepository userRepository, OntologyRepository ontologyRepository, PrivilegeRepository privilegeRepository, AuthorizationRepository authorizationRepository) {
        this.graph = graph;
        this.userRepository = userRepository;
        this.ontologyRepository = ontologyRepository;
        this.privilegeRepository = privilegeRepository;
        this.authorizationRepository = authorizationRepository;
    }

    public abstract boolean canDeleteElement(Element var1, User var2);

    public abstract boolean canDeleteProperty(Element var1, String var2, String var3, User var4);

    public abstract boolean canUpdateElement(Element var1, User var2);

    public abstract boolean canUpdateProperty(Element var1, String var2, String var3, User var4);

    public abstract boolean canAddProperty(Element var1, String var2, String var3, User var4);

    public final void checkCanAddOrUpdateProperty(Element element, String propertyKey, String propertyName, User user) throws VisalloAccessDeniedException {
        boolean canAddOrUpdate;
        boolean isUpdate = element.getProperty(propertyKey, propertyName) != null;
        boolean bl = canAddOrUpdate = isUpdate ? this.internalCanUpdateProperty(element, propertyKey, propertyName, user) : this.internalCanAddProperty(element, propertyKey, propertyName, user);
        if (!canAddOrUpdate) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be added or updated due to ACL restriction", user, element.getId());
        }
    }

    public final void checkCanDeleteProperty(Element element, String propertyKey, String propertyName, User user) throws VisalloAccessDeniedException {
        boolean canDelete = this.internalCanDeleteProperty(element, propertyKey, propertyName, user);
        if (!canDelete) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be deleted due to ACL restriction", user, element.getId());
        }
    }

    public final ClientApiElementAcl elementACL(Element element, User user, OntologyRepository ontologyRepository) {
        Preconditions.checkNotNull((Object)element, (Object)"element is required");
        ClientApiElementAcl elementAcl = new ClientApiElementAcl();
        elementAcl.setAddable(true);
        elementAcl.setUpdateable(this.internalCanUpdateElement(element, user));
        elementAcl.setDeleteable(this.internalCanDeleteElement(element, user));
        List propertyAcls = elementAcl.getPropertyAcls();
        if (element instanceof Vertex) {
            String iri = (String)VisalloProperties.CONCEPT_TYPE.getPropertyValue(element);
            while (iri != null) {
                Concept concept = ontologyRepository.getConceptByIRI(iri);
                Preconditions.checkNotNull((Object)concept, (Object)("Could not find concept with iri: " + iri));
                this.populatePropertyAcls(concept, element, user, propertyAcls);
                iri = concept.getParentConceptIRI();
            }
        } else if (element instanceof Edge) {
            String iri = ((Edge)element).getLabel();
            while (iri != null) {
                Relationship relationship = ontologyRepository.getRelationshipByIRI(iri);
                Preconditions.checkNotNull((Object)relationship, (Object)("Could not find relationship with iri: " + iri));
                this.populatePropertyAcls(relationship, element, user, propertyAcls);
                iri = relationship.getParentIRI();
            }
        } else {
            throw new VisalloException("unsupported Element class " + element.getClass().getName());
        }
        return elementAcl;
    }

    public final ClientApiObject appendACL(ClientApiObject clientApiObject, User user) {
        if (clientApiObject instanceof ClientApiElement) {
            ClientApiElement apiElement = (ClientApiElement)clientApiObject;
            this.appendACL(apiElement, user);
        } else if (clientApiObject instanceof ClientApiWorkspaceVertices) {
            this.appendACL(((ClientApiWorkspaceVertices)clientApiObject).getVertices(), user);
        } else if (clientApiObject instanceof ClientApiVertexMultipleResponse) {
            this.appendACL(((ClientApiVertexMultipleResponse)clientApiObject).getVertices(), user);
        } else if (clientApiObject instanceof ClientApiEdgeMultipleResponse) {
            this.appendACL(((ClientApiEdgeMultipleResponse)clientApiObject).getEdges(), user);
        } else if (clientApiObject instanceof ClientApiElementSearchResponse) {
            this.appendACL(((ClientApiElementSearchResponse)clientApiObject).getElements(), user);
        } else if (clientApiObject instanceof ClientApiEdgeSearchResponse) {
            this.appendACL(((ClientApiEdgeSearchResponse)clientApiObject).getResults(), user);
        } else if (clientApiObject instanceof ClientApiVertexEdges) {
            ClientApiVertexEdges vertexEdges = (ClientApiVertexEdges)clientApiObject;
            this.appendACL(vertexEdges, user);
        }
        return clientApiObject;
    }

    protected final boolean isComment(String propertyName) {
        return VisalloProperties.COMMENT.isSameName(propertyName);
    }

    protected final boolean isAuthor(Element element, String propertyKey, String propertyName, User user) {
        Property property = element.getProperty(propertyKey, propertyName);
        if (property != null) {
            String authorUserId = (String)VisalloProperties.MODIFIED_BY_METADATA.getMetadataValue(property.getMetadata());
            return user.getUserId().equals(authorUserId);
        }
        return false;
    }

    protected final boolean hasPrivilege(User user, String privilege) {
        return this.privilegeRepository.hasPrivilege(user, privilege);
    }

    private void appendACL(Collection<? extends ClientApiObject> clientApiObject, User user) {
        for (ClientApiObject clientApiObject2 : clientApiObject) {
            this.appendACL(clientApiObject2, user);
        }
    }

    private void appendACL(ClientApiElement apiElement, User user) {
        Element element = this.findElement(apiElement);
        for (ClientApiProperty apiProperty : apiElement.getProperties()) {
            String key = apiProperty.getKey();
            String name = apiProperty.getName();
            apiProperty.setUpdateable(this.internalCanUpdateProperty(element, key, name, user));
            apiProperty.setDeleteable(this.internalCanDeleteProperty(element, key, name, user));
            apiProperty.setAddable(this.internalCanAddProperty(element, key, name, user));
        }
        apiElement.setUpdateable(Boolean.valueOf(this.internalCanUpdateElement(element, user)));
        apiElement.setDeleteable(Boolean.valueOf(this.internalCanDeleteElement(element, user)));
        apiElement.setAcl(this.elementACL(element, user, this.ontologyRepository));
        if (apiElement instanceof ClientApiEdgeWithVertexData) {
            this.appendACL((ClientApiElement)((ClientApiEdgeWithVertexData)apiElement).getSource(), user);
            this.appendACL((ClientApiElement)((ClientApiEdgeWithVertexData)apiElement).getTarget(), user);
        }
    }

    private void appendACL(ClientApiVertexEdges edges, User user) {
        for (ClientApiVertexEdges.Edge vertexEdge : edges.getRelationships()) {
            this.appendACL((ClientApiElement)vertexEdge.getRelationship(), user);
            this.appendACL((ClientApiElement)vertexEdge.getVertex(), user);
        }
    }

    private void populatePropertyAcls(HasOntologyProperties hasOntologyProperties, Element element, User user, List<ClientApiPropertyAcl> propertyAcls) {
        Collection<OntologyProperty> ontologyProperties = hasOntologyProperties.getProperties();
        HashSet<String> addedPropertyNames = new HashSet<String>();
        for (OntologyProperty ontologyProperty2 : ontologyProperties) {
            String name = ontologyProperty2.getTitle();
            List properties = IterableUtils.toList((Iterable)element.getProperties(name));
            for (Property property : properties) {
                propertyAcls.add(this.newClientApiPropertyAcl(element, property.getKey(), name, user));
                addedPropertyNames.add(name);
            }
        }
        propertyAcls.addAll(ontologyProperties.stream().filter(ontologyProperty -> !addedPropertyNames.contains(ontologyProperty.getTitle())).map(ontologyProperty -> this.newClientApiPropertyAcl(element, null, ontologyProperty.getTitle(), user)).collect(Collectors.toList()));
    }

    private ClientApiPropertyAcl newClientApiPropertyAcl(Element element, String key, String name, User user) {
        ClientApiPropertyAcl propertyAcl = new ClientApiPropertyAcl();
        propertyAcl.setKey(key);
        propertyAcl.setName(name);
        propertyAcl.setAddable(this.internalCanAddProperty(element, key, name, user));
        propertyAcl.setUpdateable(this.internalCanUpdateProperty(element, key, name, user));
        propertyAcl.setDeleteable(this.internalCanDeleteProperty(element, key, name, user));
        return propertyAcl;
    }

    private Element findElement(ClientApiElement apiElement) {
        Vertex element;
        Authorizations authorizations = this.authorizationRepository.getGraphAuthorizations(this.userRepository.getSystemUser(), new String[0]);
        if (apiElement instanceof ClientApiVertex) {
            element = this.graph.getVertex(apiElement.getId(), authorizations);
            Preconditions.checkNotNull((Object)element, (Object)("could not find vertex with id: " + apiElement.getId()));
        } else if (apiElement instanceof ClientApiEdge) {
            element = this.graph.getEdge(apiElement.getId(), authorizations);
            Preconditions.checkNotNull((Object)element, (Object)("could not find edge with id: " + apiElement.getId()));
        } else {
            throw new VisalloException("unexpected ClientApiElement type " + apiElement.getClass().getName());
        }
        return element;
    }

    private boolean internalCanDeleteElement(Element element, User user) {
        return this.hasPrivilege(user, "EDIT") && this.canDeleteElement(element, user);
    }

    private boolean internalCanUpdateElement(Element element, User user) {
        return this.hasPrivilege(user, "EDIT") && this.canUpdateElement(element, user);
    }

    private boolean internalCanDeleteProperty(Element element, String propertyKey, String propertyName, User user) {
        boolean canDelete;
        boolean bl = canDelete = this.hasEditOrCommentPrivilege(propertyName, user) && this.canDeleteProperty(element, propertyKey, propertyName, user);
        if (canDelete && this.isComment(propertyName)) {
            canDelete = this.hasPrivilege(user, "COMMENT_DELETE_ANY") || this.hasPrivilege(user, "COMMENT") && this.isAuthor(element, propertyKey, propertyName, user);
        }
        return canDelete;
    }

    private boolean internalCanUpdateProperty(Element element, String propertyKey, String propertyName, User user) {
        boolean canUpdate;
        boolean bl = canUpdate = this.hasEditOrCommentPrivilege(propertyName, user) && this.canUpdateProperty(element, propertyKey, propertyName, user);
        if (canUpdate && this.isComment(propertyName)) {
            canUpdate = this.hasPrivilege(user, "COMMENT_EDIT_ANY") || this.hasPrivilege(user, "COMMENT") && this.isAuthor(element, propertyKey, propertyName, user);
        }
        return canUpdate;
    }

    private boolean internalCanAddProperty(Element element, String propertyKey, String propertyName, User user) {
        boolean canAdd;
        boolean bl = canAdd = this.hasEditOrCommentPrivilege(propertyName, user) && this.canAddProperty(element, propertyKey, propertyName, user);
        if (canAdd && this.isComment(propertyName)) {
            canAdd = this.hasPrivilege(user, "COMMENT");
        }
        return canAdd;
    }

    private boolean hasEditOrCommentPrivilege(String propertyName, User user) {
        return this.hasPrivilege(user, "EDIT") || this.isComment(propertyName) && this.hasPrivilege(user, "COMMENT");
    }
}

