/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeInfo;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoRect;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.video.VideoFrameInfo;
import org.visallo.core.ingest.video.VideoPropertyHelper;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workspace.Dashboard;
import org.visallo.core.model.workspace.DashboardItem;
import org.visallo.core.util.ConfidencePropertyComparator;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.core.util.StreamUtil;
import org.visallo.web.clientapi.model.ClientApiDashboard;
import org.visallo.web.clientapi.model.ClientApiDashboards;
import org.visallo.web.clientapi.model.ClientApiEdge;
import org.visallo.web.clientapi.model.ClientApiEdgeInfo;
import org.visallo.web.clientapi.model.ClientApiEdgeWithVertexData;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiGeoPoint;
import org.visallo.web.clientapi.model.ClientApiGeoRect;
import org.visallo.web.clientapi.model.ClientApiHistoricalPropertyResults;
import org.visallo.web.clientapi.model.ClientApiProperty;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.VisibilityJson;

public class ClientApiConverter
extends org.visallo.web.clientapi.util.ClientApiConverter {
    public static final EnumSet<FetchHint> SEARCH_FETCH_HINTS = EnumSet.of(FetchHint.PROPERTIES, FetchHint.PROPERTY_METADATA, FetchHint.IN_EDGE_LABELS, FetchHint.OUT_EDGE_LABELS);
    private static final int HISTORICAL_PROPERTY_MAX_SPV_SIZE = 2000;

    public static List<ClientApiElement> toClientApi(Iterable<? extends Element> elements, String workspaceId, Authorizations authorizations) {
        return ClientApiConverter.toClientApi(elements, workspaceId, false, authorizations);
    }

    public static List<ClientApiElement> toClientApi(Iterable<? extends Element> elements, String workspaceId, boolean includeEdgeInfos, Authorizations authorizations) {
        ArrayList<ClientApiElement> clientApiElements = new ArrayList<ClientApiElement>();
        for (Element element : elements) {
            clientApiElements.add(ClientApiConverter.toClientApi(element, workspaceId, includeEdgeInfos, authorizations));
        }
        return clientApiElements;
    }

    public static List<ClientApiVertex> toClientApiVertices(Iterable<? extends Vertex> vertices, String workspaceId, Authorizations authorizations) {
        ArrayList<ClientApiVertex> clientApiElements = new ArrayList<ClientApiVertex>();
        for (Vertex vertex : vertices) {
            clientApiElements.add(ClientApiConverter.toClientApiVertex(vertex, workspaceId, authorizations));
        }
        return clientApiElements;
    }

    public static ClientApiElement toClientApi(Element element, String workspaceId, Authorizations authorizations) {
        return ClientApiConverter.toClientApi(element, workspaceId, false, authorizations);
    }

    public static ClientApiElement toClientApi(Element element, String workspaceId, boolean includeEdgeInfos, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)element, (Object)"element cannot be null");
        if (element instanceof Vertex) {
            return ClientApiConverter.toClientApiVertex((Vertex)element, workspaceId, null, includeEdgeInfos, authorizations);
        }
        if (element instanceof Edge) {
            return ClientApiConverter.toClientApiEdge((Edge)element, workspaceId);
        }
        throw new RuntimeException("Unexpected element type: " + element.getClass().getName());
    }

    public static ClientApiVertex toClientApiVertex(Vertex vertex, String workspaceId, Authorizations authorizations) {
        return ClientApiConverter.toClientApiVertex(vertex, workspaceId, null, authorizations);
    }

    public static ClientApiVertex toClientApiVertex(Vertex vertex, String workspaceId, Integer commonCount, Authorizations authorizations) {
        return ClientApiConverter.toClientApiVertex(vertex, workspaceId, commonCount, false, authorizations);
    }

    public static ClientApiVertex toClientApiVertex(Vertex vertex, String workspaceId, Integer commonCount, boolean includeEdgeInfos, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex is required");
        ClientApiVertex v = new ClientApiVertex();
        if (authorizations != null) {
            StreamUtil.stream(vertex.getEdgeLabels(Direction.BOTH, authorizations)).forEach(arg_0 -> ((ClientApiVertex)v).addEdgeLabel(arg_0));
            if (includeEdgeInfos) {
                StreamUtil.stream(vertex.getEdgeInfos(Direction.BOTH, authorizations)).map(ClientApiConverter::toClientApi).forEach(arg_0 -> ((ClientApiVertex)v).addEdgeInfo(arg_0));
            }
        }
        ClientApiConverter.populateClientApiElement((ClientApiElement)v, (Element)vertex, workspaceId);
        v.setCommonCount(commonCount);
        return v;
    }

    private static ClientApiEdgeInfo toClientApi(EdgeInfo edgeInfo) {
        return new ClientApiEdgeInfo(edgeInfo.getEdgeId(), edgeInfo.getLabel(), edgeInfo.getVertexId());
    }

    public static ClientApiEdge toClientApiEdge(Edge edge, String workspaceId) {
        ClientApiEdge e = new ClientApiEdge();
        ClientApiConverter.populateClientApiEdge(e, edge, workspaceId);
        return e;
    }

    public static ClientApiEdgeWithVertexData toClientApiEdgeWithVertexData(Edge edge, Vertex source, Vertex target, String workspaceId, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)source, (Object)"source vertex is required");
        Preconditions.checkNotNull((Object)target, (Object)"target vertex is required");
        ClientApiEdgeWithVertexData e = new ClientApiEdgeWithVertexData();
        e.setSource(ClientApiConverter.toClientApiVertex(source, workspaceId, authorizations));
        e.setTarget(ClientApiConverter.toClientApiVertex(target, workspaceId, authorizations));
        ClientApiConverter.populateClientApiEdge((ClientApiEdge)e, edge, workspaceId);
        return e;
    }

    public static void populateClientApiEdge(ClientApiEdge e, Edge edge, String workspaceId) {
        e.setLabel(edge.getLabel());
        e.setOutVertexId(edge.getVertexId(Direction.OUT));
        e.setInVertexId(edge.getVertexId(Direction.IN));
        ClientApiConverter.populateClientApiElement((ClientApiElement)e, (Element)edge, workspaceId);
    }

    private static void populateClientApiElement(ClientApiElement clientApiElement, Element element, String workspaceId) {
        clientApiElement.setId(element.getId());
        clientApiElement.getProperties().addAll(ClientApiConverter.toClientApiProperties(element.getProperties(), workspaceId));
        clientApiElement.setSandboxStatus(SandboxStatusUtil.getSandboxStatus(element, workspaceId));
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue(element);
        if (visibilityJson != null) {
            clientApiElement.setVisibilitySource(visibilityJson.getSource());
        }
        if (clientApiElement instanceof ClientApiVertex) {
            ClientApiVertex clientApiVertex = (ClientApiVertex)clientApiElement;
            String conceptType = VisalloProperties.CONCEPT_TYPE.getPropertyValue(element, null);
            clientApiVertex.setConceptType(conceptType);
        }
    }

    public static List<ClientApiProperty> toClientApiProperties(Iterable<Property> properties, String workspaceId) {
        ArrayList<ClientApiProperty> clientApiProperties = new ArrayList<ClientApiProperty>();
        List propertiesList = IterableUtils.toList(properties);
        Collections.sort(propertiesList, new ConfidencePropertyComparator());
        SandboxStatus[] sandboxStatuses = SandboxStatusUtil.getPropertySandboxStatuses(propertiesList, workspaceId);
        for (int i = 0; i < propertiesList.size(); ++i) {
            Property property = (Property)propertiesList.get(i);
            SandboxStatus sandboxStatus = sandboxStatuses[i];
            VideoFrameInfo videoFrameInfo = VideoPropertyHelper.getVideoFrameInfoFromProperty(property);
            if (videoFrameInfo != null) {
                String textDescription = VisalloProperties.TEXT_DESCRIPTION_METADATA.getMetadataValueOrDefault(property.getMetadata(), null);
                ClientApiConverter.addVideoFramePropertyToResults(clientApiProperties, videoFrameInfo.getPropertyKey(), textDescription, sandboxStatus);
                continue;
            }
            ClientApiProperty clientApiProperty = ClientApiConverter.toClientApiProperty(property);
            clientApiProperty.setSandboxStatus(sandboxStatus);
            clientApiProperties.add(clientApiProperty);
        }
        return clientApiProperties;
    }

    public static ClientApiProperty toClientApiProperty(Property property) {
        ClientApiProperty clientApiProperty = new ClientApiProperty();
        clientApiProperty.setKey(property.getKey());
        clientApiProperty.setName(property.getName());
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            clientApiProperty.setStreamingPropertyValue(true);
        } else {
            clientApiProperty.setValue(ClientApiConverter.toClientApiValue((Object)propertyValue));
        }
        for (Metadata.Entry entry : property.getMetadata().entrySet()) {
            clientApiProperty.getMetadata().put(entry.getKey(), ClientApiConverter.toClientApiValue((Object)entry.getValue()));
        }
        return clientApiProperty;
    }

    private static void addVideoFramePropertyToResults(List<ClientApiProperty> clientApiProperties, String propertyKey, String textDescription, SandboxStatus sandboxStatus) {
        ClientApiProperty clientApiProperty = ClientApiConverter.findProperty(clientApiProperties, MediaVisalloProperties.VIDEO_TRANSCRIPT.getPropertyName(), propertyKey);
        if (clientApiProperty == null) {
            clientApiProperty = new ClientApiProperty();
            clientApiProperty.setKey(propertyKey);
            clientApiProperty.setName(MediaVisalloProperties.VIDEO_TRANSCRIPT.getPropertyName());
            clientApiProperty.setSandboxStatus(sandboxStatus);
            clientApiProperty.getMetadata().put(VisalloProperties.TEXT_DESCRIPTION_METADATA.getMetadataKey(), textDescription);
            clientApiProperty.setStreamingPropertyValue(true);
            clientApiProperties.add(clientApiProperty);
        }
    }

    private static ClientApiProperty findProperty(List<ClientApiProperty> clientApiProperties, String propertyName, String propertyKey) {
        for (ClientApiProperty property : clientApiProperties) {
            if (!property.getName().equals(propertyName) || !property.getKey().equals(propertyKey)) continue;
            return property;
        }
        return null;
    }

    public static ClientApiHistoricalPropertyResults toClientApi(Iterable<HistoricalPropertyValue> historicalPropertyValues, Locale locale, ResourceBundle resourceBundle) {
        ClientApiHistoricalPropertyResults result = new ClientApiHistoricalPropertyResults();
        for (HistoricalPropertyValue historicalPropertyValue : historicalPropertyValues) {
            result.events.add(ClientApiConverter.toClientApi(historicalPropertyValue, locale, resourceBundle));
        }
        return result;
    }

    public static ClientApiHistoricalPropertyResults.Event toClientApi(HistoricalPropertyValue hpv, Locale locale, ResourceBundle resourceBundle) {
        ClientApiHistoricalPropertyResults.Event result = new ClientApiHistoricalPropertyResults.Event();
        result.timestamp = hpv.getTimestamp();
        for (Metadata.Entry entry : hpv.getMetadata().entrySet()) {
            result.metadata.put(entry.getKey(), ClientApiConverter.toClientApiValue((Object)entry.getValue()));
        }
        Object value = hpv.getValue();
        if (value instanceof StreamingPropertyValue) {
            value = ClientApiConverter.readStreamingPropertyValueForHistory((StreamingPropertyValue)value, locale, resourceBundle);
        }
        result.value = ClientApiConverter.toClientApiValue((Object)value);
        result.propertyKey = hpv.getPropertyKey();
        result.propertyName = hpv.getPropertyName();
        result.propertyVisibility = hpv.getPropertyVisibility().getVisibilityString();
        return result;
    }

    private static String readStreamingPropertyValueForHistory(StreamingPropertyValue spv, Locale locale, ResourceBundle resourceBundle) {
        if (spv.getValueType() == String.class) {
            return ClientApiConverter.readStreamingPropertyValueStringForHistory(spv);
        }
        return String.format(locale, resourceBundle.getString("history.nondisplayable"), spv.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readStreamingPropertyValueStringForHistory(StreamingPropertyValue spv) {
        try (InputStream in = spv.getInputStream();){
            byte[] buffer = new byte[2000];
            int bytesRead = in.read(buffer, 0, 2000);
            if (bytesRead < 0) {
                String string = "";
                return string;
            }
            String string = new String(buffer, 0, bytesRead);
            return string;
        }
        catch (IOException ex) {
            throw new VisalloException("Could not read StreamingPropertyValue", ex);
        }
    }

    public static ClientApiDashboards toClientApiDashboards(Collection<Dashboard> dashboards) {
        ClientApiDashboards result = new ClientApiDashboards();
        for (Dashboard dashboard : dashboards) {
            result.dashboards.add(ClientApiConverter.toClientApiDashboard(dashboard));
        }
        return result;
    }

    public static ClientApiDashboard toClientApiDashboard(Dashboard dashboard) {
        ClientApiDashboard result = new ClientApiDashboard();
        result.id = dashboard.getId();
        result.workspaceId = dashboard.getWorkspaceId();
        result.title = dashboard.getTitle();
        for (DashboardItem dashboardItem : dashboard.getItems()) {
            result.items.add(ClientApiConverter.toClientApiDashboardItem(dashboardItem));
        }
        return result;
    }

    private static ClientApiDashboard.Item toClientApiDashboardItem(DashboardItem dashboardItem) {
        ClientApiDashboard.Item result = new ClientApiDashboard.Item();
        result.id = dashboardItem.getId();
        result.extensionId = dashboardItem.getExtensionId();
        result.title = dashboardItem.getTitle();
        result.configuration = dashboardItem.getConfiguration();
        return result;
    }

    public static ClientApiGeoPoint toClientApiGeoPoint(GeoPoint geoPoint) {
        return new ClientApiGeoPoint(geoPoint.getLatitude(), geoPoint.getLongitude());
    }

    public static ClientApiGeoRect toClientApiGeoRect(GeoRect rect) {
        return new ClientApiGeoRect(ClientApiConverter.toClientApiGeoPoint(rect.getNorthWest()), ClientApiConverter.toClientApiGeoPoint(rect.getSouthEast()));
    }
}

