/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Collection;
import org.vertexium.Element;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkData;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorker;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerPrepareData;
import org.visallo.core.ingest.graphProperty.MimeTypeGraphPropertyWorkerConfiguration;
import org.visallo.core.ingest.graphProperty.PostMimeTypeWorker;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class MimeTypeGraphPropertyWorker
extends GraphPropertyWorker {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(MimeTypeGraphPropertyWorker.class);
    private static final String MULTI_VALUE_KEY = MimeTypeGraphPropertyWorker.class.getName();
    private final MimeTypeGraphPropertyWorkerConfiguration configuration;
    private Collection<PostMimeTypeWorker> postMimeTypeWorkers;

    @Inject
    protected MimeTypeGraphPropertyWorker(MimeTypeGraphPropertyWorkerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void prepare(GraphPropertyWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        this.postMimeTypeWorkers = InjectHelper.getInjectedServices(PostMimeTypeWorker.class, this.getConfiguration());
        for (PostMimeTypeWorker postMimeTypeWorker : this.postMimeTypeWorkers) {
            try {
                postMimeTypeWorker.prepare(workerPrepareData);
            }
            catch (Exception ex) {
                throw new VisalloException("Could not prepare post mime type worker " + postMimeTypeWorker.getClass().getName(), ex);
            }
        }
    }

    @Override
    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        if (VisalloProperties.MIME_TYPE.hasProperty(element, this.getMultiKey(property))) {
            return false;
        }
        return this.configuration.isHandled(element, property);
    }

    @Override
    public void execute(InputStream in, GraphPropertyWorkData data) throws Exception {
        String fileName = (String)VisalloProperties.FILE_NAME.getOnlyPropertyValue(data.getElement());
        String mimeType = this.getMimeType(in, fileName);
        if (mimeType == null) {
            return;
        }
        ExistingElementMutation m = ((Vertex)data.getElement()).prepareMutation();
        Metadata mimeTypeMetadata = data.createPropertyMetadata(this.getUser());
        VisalloProperties.MIME_TYPE.addPropertyValue((ElementMutation<?>)m, this.getMultiKey(data.getProperty()), mimeType, mimeTypeMetadata, data.getVisibility());
        m.setPropertyMetadata(data.getProperty(), VisalloProperties.MIME_TYPE.getPropertyName(), (Object)mimeType, this.getVisibilityTranslator().getDefaultVisibility());
        m.save(this.getAuthorizations());
        this.getGraph().flush();
        this.runPostMimeTypeWorkers(mimeType, data);
        this.getWorkQueueRepository().pushGraphPropertyQueue(data.getElement(), data.getProperty(), data.getWorkspaceId(), data.getVisibilitySource(), data.getPriority());
    }

    private String getMultiKey(Property property) {
        return MULTI_VALUE_KEY + property.getKey();
    }

    private void runPostMimeTypeWorkers(String mimeType, GraphPropertyWorkData data) {
        for (PostMimeTypeWorker postMimeTypeWorker : this.postMimeTypeWorkers) {
            try {
                LOGGER.debug("running PostMimeTypeWorker: %s on element: %s, mimeType: %s", postMimeTypeWorker.getClass().getName(), data.getElement().getId(), mimeType);
                postMimeTypeWorker.executeAndCleanup(mimeType, data, this.getAuthorizations());
            }
            catch (Exception ex) {
                throw new VisalloException("Failed running PostMimeTypeWorker " + postMimeTypeWorker.getClass().getName(), ex);
            }
        }
        if (this.postMimeTypeWorkers.size() > 0) {
            this.getGraph().flush();
        }
    }

    protected abstract String getMimeType(InputStream var1, String var2) throws Exception;
}

