/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.properties.types;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.core.model.properties.types.PropertyMetadata;
import org.visallo.core.model.properties.types.VisalloPropertyBase;
import org.visallo.core.model.properties.types.VisalloPropertyUpdate;
import org.visallo.core.model.properties.types.VisalloPropertyUpdateRemove;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class VisalloProperty<TRaw, TGraph>
extends VisalloPropertyBase<TRaw, TGraph> {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VisalloProperty.class);

    protected VisalloProperty(String propertyName) {
        super(propertyName);
    }

    public final void addPropertyValue(ElementMutation<?> mutation, String multiKey, TRaw value, Visibility visibility) {
        mutation.addPropertyValue(multiKey, this.getPropertyName(), this.wrap(value), visibility);
    }

    public final void addPropertyValue(Element element, String multiKey, TRaw value, Visibility visibility, Authorizations authorizations) {
        element.addPropertyValue(multiKey, this.getPropertyName(), this.wrap(value), visibility, authorizations);
    }

    public final void addPropertyValue(Element element, String multiKey, TRaw value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        element.addPropertyValue(multiKey, this.getPropertyName(), this.wrap(value), metadata, visibility, authorizations);
    }

    public final void addPropertyValue(ElementMutation<?> mutation, String multiKey, TRaw value, Metadata metadata, Visibility visibility) {
        this.addPropertyValue(mutation, multiKey, value, metadata, null, visibility);
    }

    public final void addPropertyValue(ElementMutation<?> mutation, String multiKey, TRaw value, Metadata metadata, Long timestamp, Visibility visibility) {
        mutation.addPropertyValue(multiKey, this.getPropertyName(), this.wrap(value), metadata, timestamp, visibility);
    }

    public final TRaw getPropertyValue(Element element, String propertyKey) {
        Object value = element != null ? element.getPropertyValue(propertyKey, this.getPropertyName()) : null;
        return (TRaw)(value != null ? this.getRawConverter().apply(value) : null);
    }

    @Override
    public final TRaw getPropertyValue(Property property) {
        Object value = property.getValue();
        return (TRaw)(value != null ? this.getRawConverter().apply(value) : null);
    }

    public final Iterable<TRaw> getPropertyValues(Element element) {
        Iterable values = element != null ? element.getPropertyValues(this.getPropertyName()) : null;
        return values != null ? Iterables.transform((Iterable)values, this.getRawConverter()) : Collections.EMPTY_LIST;
    }

    public boolean hasProperty(Element element, String propertyKey) {
        return element.getProperty(propertyKey, this.getPropertyName()) != null;
    }

    public boolean hasProperty(Element element) {
        return Iterables.size((Iterable)element.getProperties(this.getPropertyName())) > 0;
    }

    public Property getProperty(Element element, String key) {
        return element.getProperty(key, this.getPropertyName());
    }

    public Property getOnlyProperty(Element element) {
        return (Property)Iterables.getOnlyElement((Iterable)element.getProperties(this.getPropertyName()), null);
    }

    public Property getFirstProperty(Element element) {
        return (Property)Iterables.getFirst((Iterable)element.getProperties(this.getPropertyName()), null);
    }

    public TRaw getFirstPropertyValue(Element element) {
        Property property = this.getFirstProperty(element);
        if (property == null) {
            return null;
        }
        return this.getPropertyValue(property);
    }

    public Iterable<Property> getProperties(Element element) {
        return element.getProperties(this.getPropertyName());
    }

    public void removeProperty(Element element, String key, Authorizations authorizations) {
        element.softDeleteProperty(key, this.getPropertyName(), authorizations);
    }

    public void removeProperty(ElementMutation m, String key, Visibility visibility) {
        m.softDeleteProperty(key, this.getPropertyName(), visibility);
    }

    public void alterVisibility(ExistingElementMutation<?> elementMutation, String propertyKey, Visibility newVisibility) {
        elementMutation.alterPropertyVisibility(propertyKey, this.getPropertyName(), newVisibility);
    }

    public void removeProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, String propertyKey, Visibility visibility) {
        TRaw currentValue = this.getPropertyValue(element, propertyKey);
        if (currentValue != null) {
            long beforeDeletionTimestamp = System.currentTimeMillis() - 1L;
            this.removeProperty(m, propertyKey, visibility);
            changedPropertiesOut.add(new VisalloPropertyUpdateRemove(this, propertyKey, beforeDeletionTimestamp, true, false));
        }
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, String propertyKey, TRaw newValue, PropertyMetadata metadata, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, propertyKey, newValue, metadata, null, visibility);
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, String propertyKey, TRaw newValue, PropertyMetadata metadata, Long timestamp, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, propertyKey, newValue, metadata.createMetadata(), timestamp, visibility);
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, String propertyKey, TRaw newValue, Metadata metadata, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, propertyKey, newValue, metadata, null, visibility);
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, String propertyKey, TRaw newValue, Metadata metadata, Long timestamp, Visibility visibility) {
        if (newValue == null) {
            LOGGER.error("passing a null value to updateProperty will not be allowed in the future: %s", this);
            return;
        }
        if (newValue instanceof String && ((String)newValue).length() == 0) {
            LOGGER.error("passing an empty string value to updateProperty will not be allowed in the future: %s", this);
            return;
        }
        Object currentValue = null;
        if (element != null) {
            currentValue = this.getPropertyValue(element, propertyKey);
        }
        if (currentValue == null || !newValue.equals(currentValue)) {
            this.addPropertyValue(m, propertyKey, newValue, metadata, timestamp, visibility);
            changedPropertiesOut.add(new VisalloPropertyUpdate(this, propertyKey));
        }
    }

    public TRaw getOnlyPropertyValue(Element element) {
        Object value = Iterables.getOnlyElement((Iterable)element.getPropertyValues(this.getPropertyName()), null);
        if (value != null) {
            return this.unwrap(value);
        }
        return null;
    }
}

