/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.query.Aggregation;
import org.vertexium.query.Compare;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.StatisticsAggregation;
import org.vertexium.query.StatisticsResult;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.ping.PingLongRunningProcessQueueItem;
import org.visallo.core.ping.PingOntology;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;

public class PingUtil {
    public static final String VISIBILITY_STRING = "ping";
    public static final Visibility VISIBILITY = new VisalloVisibility("ping").getVisibility();
    private final User systemUser;
    private final VisibilityTranslator visibilityTranslator;

    @Inject
    public PingUtil(GraphAuthorizationRepository graphAuthorizationRepository, UserRepository userRepository, VisibilityTranslator visibilityTranslator) {
        graphAuthorizationRepository.addAuthorizationToGraph(VISIBILITY_STRING);
        this.systemUser = userRepository.getSystemUser();
        this.visibilityTranslator = visibilityTranslator;
    }

    public String search(Graph graph, Authorizations authorizations) {
        Query query = graph.query(authorizations).limit(Integer.valueOf(1));
        ArrayList vertices = Lists.newArrayList((Iterable)query.vertices());
        if (vertices.size() == 0) {
            throw new VisalloException("query returned no vertices");
        }
        if (vertices.size() > 1) {
            throw new VisalloException("query returned more than one vertex");
        }
        return ((Vertex)vertices.get(0)).getId();
    }

    public void retrieve(String vertexId, Graph graph, Authorizations authorizations) {
        Vertex retrievedVertex = graph.getVertex(vertexId, authorizations);
        if (retrievedVertex == null) {
            throw new VisalloException("failed to retrieve vertex by id: " + vertexId);
        }
    }

    public Vertex createVertex(String remoteAddr, long searchTime, long retrievalTime, Graph graph, Authorizations authorizations) {
        Date createDate = new Date();
        String vertexId = PingOntology.getVertexId(createDate);
        VertexBuilder mutation = graph.prepareVertex(vertexId, VISIBILITY);
        VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation<?>)mutation, "http://visallo.org/ping#ping", this.visibilityTranslator.getDefaultVisibility());
        PingOntology.CREATE_DATE.setProperty((ElementMutation<?>)mutation, createDate, VISIBILITY);
        PingOntology.CREATE_REMOTE_ADDR.setProperty((ElementMutation<?>)mutation, remoteAddr, VISIBILITY);
        PingOntology.SEARCH_TIME_MS.setProperty((ElementMutation<?>)mutation, searchTime, VISIBILITY);
        PingOntology.RETRIEVAL_TIME_MS.setProperty((ElementMutation<?>)mutation, retrievalTime, VISIBILITY);
        Vertex vertex = (Vertex)mutation.save(authorizations);
        graph.flush();
        return vertex;
    }

    public void enqueueToWorkQueue(Vertex vertex, WorkQueueRepository workQueueRepository, Priority priority) {
        workQueueRepository.pushElement((Element)vertex, priority);
    }

    public void gpwUpdate(Vertex vertex, Graph graph, Authorizations authorizations) {
        Date updateDate = new Date();
        Long waitTimeMs = updateDate.getTime() - ((Date)PingOntology.CREATE_DATE.getPropertyValueRequired((Element)vertex)).getTime();
        ExistingElementMutation mutation = vertex.prepareMutation();
        PingOntology.GRAPH_PROPERTY_WORKER_DATE.setProperty((ElementMutation<?>)mutation, updateDate, VISIBILITY);
        PingOntology.GRAPH_PROPERTY_WORKER_HOSTNAME.setProperty((ElementMutation<?>)mutation, this.getHostname(), VISIBILITY);
        PingOntology.GRAPH_PROPERTY_WORKER_HOST_ADDRESS.setProperty((ElementMutation<?>)mutation, this.getHostAddress(), VISIBILITY);
        PingOntology.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.setProperty((ElementMutation<?>)mutation, waitTimeMs, VISIBILITY);
        mutation.save(authorizations);
        graph.flush();
    }

    public void enqueueToLongRunningProcess(Vertex vertex, LongRunningProcessRepository longRunningProcessRepository, Authorizations authorizations) {
        longRunningProcessRepository.enqueue(new PingLongRunningProcessQueueItem(vertex).toJson(), this.systemUser, authorizations);
    }

    public void lrpUpdate(Vertex vertex, Graph graph, Authorizations authorizations) {
        Date updateDate = new Date();
        Long waitTimeMs = updateDate.getTime() - ((Date)PingOntology.CREATE_DATE.getPropertyValueRequired((Element)vertex)).getTime();
        ExistingElementMutation mutation = vertex.prepareMutation();
        PingOntology.LONG_RUNNING_PROCESS_DATE.setProperty((ElementMutation<?>)mutation, updateDate, VISIBILITY);
        PingOntology.LONG_RUNNING_PROCESS_HOSTNAME.setProperty((ElementMutation<?>)mutation, this.getHostname(), VISIBILITY);
        PingOntology.LONG_RUNNING_PROCESS_HOST_ADDRESS.setProperty((ElementMutation<?>)mutation, this.getHostAddress(), VISIBILITY);
        PingOntology.LONG_RUNNING_PROCESS_WAIT_TIME_MS.setProperty((ElementMutation<?>)mutation, waitTimeMs, VISIBILITY);
        mutation.save(authorizations);
        graph.flush();
    }

    public JSONObject getAverages(int minutes, Graph graph, Authorizations authorizations) {
        Date minutesAgo = new Date(System.currentTimeMillis() - (long)(minutes * 60 * 1000));
        Query q = graph.query(authorizations).has(VisalloProperties.CONCEPT_TYPE.getPropertyName(), (Object)"http://visallo.org/ping#ping").has(PingOntology.CREATE_DATE.getPropertyName(), (Predicate)Compare.GREATER_THAN, (Object)minutesAgo).limit(Integer.valueOf(0));
        q.addAggregation((Aggregation)new StatisticsAggregation(PingOntology.SEARCH_TIME_MS.getPropertyName(), PingOntology.SEARCH_TIME_MS.getPropertyName()));
        q.addAggregation((Aggregation)new StatisticsAggregation(PingOntology.RETRIEVAL_TIME_MS.getPropertyName(), PingOntology.RETRIEVAL_TIME_MS.getPropertyName()));
        q.addAggregation((Aggregation)new StatisticsAggregation(PingOntology.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.getPropertyName(), PingOntology.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.getPropertyName()));
        q.addAggregation((Aggregation)new StatisticsAggregation(PingOntology.LONG_RUNNING_PROCESS_WAIT_TIME_MS.getPropertyName(), PingOntology.LONG_RUNNING_PROCESS_WAIT_TIME_MS.getPropertyName()));
        QueryResultsIterable vertices = q.vertices();
        StatisticsResult searchTimeAgg = (StatisticsResult)vertices.getAggregationResult(PingOntology.SEARCH_TIME_MS.getPropertyName(), StatisticsResult.class);
        StatisticsResult retrievalTimeAgg = (StatisticsResult)vertices.getAggregationResult(PingOntology.RETRIEVAL_TIME_MS.getPropertyName(), StatisticsResult.class);
        StatisticsResult gpwWaitTimeAgg = (StatisticsResult)vertices.getAggregationResult(PingOntology.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.getPropertyName(), StatisticsResult.class);
        StatisticsResult lrpWaitTimeAgg = (StatisticsResult)vertices.getAggregationResult(PingOntology.LONG_RUNNING_PROCESS_WAIT_TIME_MS.getPropertyName(), StatisticsResult.class);
        JSONObject json = new JSONObject();
        json.put("pingCount", searchTimeAgg.getCount());
        json.put("averageSearchTime", searchTimeAgg.getAverage());
        json.put("averageRetrievalTime", retrievalTimeAgg.getAverage());
        json.put("graphPropertyWorkerCount", gpwWaitTimeAgg.getCount());
        json.put("averageGraphPropertyWorkerWaitTime", gpwWaitTimeAgg.getAverage());
        json.put("longRunningProcessCount", lrpWaitTimeAgg.getCount());
        json.put("averageLongRunningProcessWaitTime", lrpWaitTimeAgg.getAverage());
        return json;
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    private String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }
}

