/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.status.model;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.status.model.ExternalResourceRunnerStatus;
import org.visallo.core.status.model.GraphPropertyRunnerStatus;
import org.visallo.core.status.model.LongRunningProcessRunnerStatus;
import org.visallo.core.status.model.QueueStatus;
import org.visallo.web.clientapi.model.ClientApiObject;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExternalResourceRunnerStatus.class, name="externalResourceRunner"), @JsonSubTypes.Type(value=GraphPropertyRunnerStatus.class, name="graphPropertyRunner"), @JsonSubTypes.Type(value=LongRunningProcessRunnerStatus.class, name="longRunningProcessRunner"), @JsonSubTypes.Type(value=QueueStatus.class, name="queue")})
public abstract class Status
implements ClientApiObject {
    private String className;
    private String name;
    private String description;
    private String projectVersion;
    private String gitRevision;
    private String builtBy;
    private Date builtOn;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getGitRevision() {
        return this.gitRevision;
    }

    public void setGitRevision(String gitRevision) {
        this.gitRevision = gitRevision;
    }

    public String getBuiltBy() {
        return this.builtBy;
    }

    public void setBuiltBy(String builtBy) {
        this.builtBy = builtBy;
    }

    public Date getBuiltOn() {
        return this.builtOn;
    }

    public void setBuiltOn(Date builtOn) {
        this.builtOn = builtOn;
    }

    @JsonTypeName(value="timer")
    public static class TimerMetric
    extends Metric {
        private long count;
        private double meanRate;
        private double oneMinuteRate;
        private double fiveMinuteRate;
        private double fifteenMinuteRate;

        public TimerMetric() {
        }

        public TimerMetric(Timer metric) {
            this.count = metric.getCount();
            this.meanRate = metric.getMeanRate();
            this.oneMinuteRate = metric.getOneMinuteRate();
            this.fiveMinuteRate = metric.getFiveMinuteRate();
            this.fifteenMinuteRate = metric.getFifteenMinuteRate();
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public double getMeanRate() {
            return this.meanRate;
        }

        public void setMeanRate(double meanRate) {
            this.meanRate = meanRate;
        }

        public double getOneMinuteRate() {
            return this.oneMinuteRate;
        }

        public void setOneMinuteRate(double oneMinuteRate) {
            this.oneMinuteRate = oneMinuteRate;
        }

        public double getFiveMinuteRate() {
            return this.fiveMinuteRate;
        }

        public void setFiveMinuteRate(double fiveMinuteRate) {
            this.fiveMinuteRate = fiveMinuteRate;
        }

        public double getFifteenMinuteRate() {
            return this.fifteenMinuteRate;
        }

        public void setFifteenMinuteRate(double fifteenMinuteRate) {
            this.fifteenMinuteRate = fifteenMinuteRate;
        }
    }

    @JsonTypeName(value="counter")
    public static class CounterMetric
    extends Metric {
        private long count;

        public CounterMetric() {
        }

        public CounterMetric(Counter counter) {
            this.count = counter.getCount();
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CounterMetric.class, name="counter"), @JsonSubTypes.Type(value=TimerMetric.class, name="timer")})
    public static abstract class Metric {
        public static Metric create(com.codahale.metrics.Metric metric) {
            if (metric instanceof Counter) {
                return new CounterMetric((Counter)metric);
            }
            if (metric instanceof Timer) {
                return new TimerMetric((Timer)metric);
            }
            throw new VisalloException("Unhandled metric: " + metric.getClass().getName());
        }
    }
}

