/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;

public class ClassUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static <T> Class<? extends T> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new VisalloException("Could not load class " + className, e);
        }
    }

    public static Method findMethod(Class clazz, String methodName, Class[] parameters) {
        while (clazz != null) {
            try {
                return ClassUtil.getDeclaredMethod(clazz, methodName, parameters);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static void logClasspath(ClassLoader classLoader) {
        ClassUtil.logClasspath(classLoader, System.out);
    }

    public static void logClasspath(ClassLoader classLoader, PrintStream printStream) {
        ClassUtil.outputClasspath(classLoader, printStream);
    }

    public static void logClasspath(ClassLoader classLoader, VisalloLogger visalloLogger) {
        ClassUtil.outputClasspath(classLoader, visalloLogger);
    }

    private static void outputClasspath(ClassLoader classLoader, Object outputObject) {
        StringBuilder sb = new StringBuilder();
        if (classLoader instanceof URLClassLoader) {
            sb.append(classLoader.getClass().getName());
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                sb.append(LINE_SEPARATOR).append(url.toString());
            }
        } else {
            sb.append("unable to enumerate entries for ").append(classLoader.getClass().getName());
        }
        if (outputObject instanceof PrintStream) {
            ((PrintStream)outputObject).println(sb.toString());
        } else if (outputObject instanceof VisalloLogger) {
            ((VisalloLogger)outputObject).debug(sb.toString(), new Object[0]);
        } else {
            throw new VisalloException("unexpected outputObject");
        }
        ClassLoader parentClassLoader = classLoader.getParent();
        if (parentClassLoader != null) {
            ClassUtil.outputClasspath(parentClassLoader, outputObject);
        }
    }

    private static Method getDeclaredMethod(Class clazz, String methodName, Class[] parameters) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(methodName, parameters);
    }
}

