/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.LoggingThread;
import org.visallo.core.util.Pipe;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class ProcessRunner {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ProcessRunner.class);

    public String executeToString(String programName, String[] programArgs) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.execute(programName, programArgs, out, "executeToString");
            return new String(out.toByteArray());
        }
        catch (Exception ex) {
            throw new VisalloException("Could not run " + programName + " " + Joiner.on((String)" ").join((Object[])programArgs), ex);
        }
    }

    public Process execute(String programName, String[] programArgs, OutputStream out, String logPrefix) throws IOException, InterruptedException {
        return this.execute(null, programName, programArgs, out, logPrefix);
    }

    public Process execute(File workingDirectory, String programName, String[] programArgs, OutputStream out, String logPrefix) throws IOException, InterruptedException {
        ArrayList arguments = Lists.newArrayList((Object[])new String[]{programName});
        for (String programArg : programArgs) {
            if (programArg == null) {
                throw new NullPointerException("Argument was null in argument list [ " + Joiner.on((String)", ").useForNull("null").join((Object[])programArgs) + " ]");
            }
            arguments.add(programArg);
        }
        ProcessBuilder procBuilder = new ProcessBuilder(arguments);
        if (workingDirectory != null) {
            procBuilder.directory(workingDirectory);
        }
        TreeMap<String, String> sortedEnv = new TreeMap<String, String>(procBuilder.environment());
        LOGGER.info("%s Running: %s", logPrefix, ProcessRunner.arrayToString(arguments));
        if (!sortedEnv.isEmpty()) {
            LOGGER.info("%s Spawned program environment: ", logPrefix);
            for (Map.Entry entry : sortedEnv.entrySet()) {
                LOGGER.info("%s %s:%s", logPrefix, entry.getKey(), entry.getValue());
            }
        } else {
            LOGGER.info("%s Running program environment is empty", logPrefix);
        }
        Process proc = procBuilder.start();
        LoggingThread stderrThread = new LoggingThread(proc.getErrorStream(), LOGGER, logPrefix + programName + "(stderr): ");
        stderrThread.start();
        final Exception[] pipeException = new Exception[1];
        Pipe pipe = null;
        LoggingThread stdoutThread = null;
        if (out == null) {
            stdoutThread = new LoggingThread(proc.getInputStream(), LOGGER, logPrefix + programName + "(stdout): ");
            stdoutThread.start();
        } else {
            Pipe.StatusHandler statusHandler = new Pipe.StatusHandler(){

                @Override
                public void handleException(Exception e) {
                    pipeException[0] = e;
                }
            };
            pipe = new Pipe().pipe(proc.getInputStream(), out, statusHandler);
        }
        Thread.sleep(100L);
        proc.waitFor();
        stderrThread.join(10000L);
        if (stdoutThread != null) {
            stdoutThread.join(10000L);
        }
        if (pipe != null) {
            pipe.waitForCompletion(10000L, TimeUnit.MILLISECONDS);
        }
        proc.getOutputStream().close();
        proc.getInputStream().close();
        proc.getErrorStream().close();
        LOGGER.info(logPrefix + programName + "(returncode): " + proc.exitValue(), new Object[0]);
        if (proc.exitValue() != 0) {
            throw new VisalloException("unexpected return code: " + proc.exitValue() + " for command " + ProcessRunner.arrayToString(arguments));
        }
        if (pipeException[0] != null) {
            throw new VisalloException("pipe exception", pipeException[0]);
        }
        return proc;
    }

    private static String arrayToString(List<String> arr) {
        StringBuilder result = new StringBuilder();
        for (String s : arr) {
            result.append(s).append(' ');
        }
        return result.toString();
    }
}

