/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.visallo.core.exception.VisalloException;

public class VisalloDate {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final String year;
    private final String month;
    private final String date;

    public VisalloDate(String year, String month, String date) {
        this.year = VisalloDate.cleanYearString(year);
        this.month = VisalloDate.cleanMonthString(month);
        this.date = VisalloDate.cleanDateString(date);
    }

    private static String cleanDateString(String date) {
        String string = date = date == null ? "??" : date;
        if (date.length() == 1) {
            date = date.charAt(0) == '?' ? "?" + date : "0" + date;
        }
        return date;
    }

    private static String cleanMonthString(String month) {
        String string = month = month == null ? "??" : month;
        if (month.length() == 1) {
            month = month.charAt(0) == '?' ? "?" + month : "0" + month;
        }
        return month;
    }

    private static String cleanYearString(String year) {
        String string = year = year == null ? "????" : year;
        if (year.length() == 2) {
            year = "20" + year;
        }
        return year;
    }

    public VisalloDate(Integer year, Integer month, Integer date) {
        this(year == null ? null : year.toString(), month == null ? null : month.toString(), date == null ? null : date.toString());
    }

    public static VisalloDate create(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return VisalloDate.parse((String)obj);
        }
        if (obj instanceof Date) {
            return VisalloDate.create((Date)obj);
        }
        throw new VisalloException("Invalid object type to convert to " + VisalloDate.class.getSimpleName() + ": " + obj.getClass().getName());
    }

    public static VisalloDate create(Date date) {
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTime(date);
        return new VisalloDate(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    private static VisalloDate parse(String str) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            sdf.setTimeZone(GMT);
            return VisalloDate.create(sdf.parse(str));
        }
        catch (ParseException e) {
            throw new VisalloException("Could not parse date: " + str, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisalloDate that = (VisalloDate)o;
        if (!this.year.equals(that.year)) {
            return false;
        }
        if (!this.month.equals(that.month)) {
            return false;
        }
        return this.date.equals(that.date);
    }

    public int hashCode() {
        int result = this.year.hashCode();
        result = 31 * result + this.month.hashCode();
        result = 31 * result + this.date.hashCode();
        return result;
    }

    public String toString() {
        return this.getYear() + "-" + this.getMonth() + "-" + this.getDate();
    }

    public Date toDate() {
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTimeInMillis(0L);
        cal.set(this.getYearInt(), this.getMonthInt() - 1, this.getDateInt(), 0, 0, 0);
        return cal.getTime();
    }

    public int getDateInt() {
        return Integer.parseInt(this.getDate());
    }

    public int getMonthInt() {
        return Integer.parseInt(this.getMonth());
    }

    public int getYearInt() {
        return Integer.parseInt(this.getYear());
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDate() {
        return this.date;
    }

    public long getEpoch() {
        return this.toDate().getTime();
    }

    public static enum Unit {
        DAY;

    }
}

