/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.google.common.collect.Lists;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.util.JSONUtil;

public class GraphPropertyMessage {
    public static final String PROPERTY_KEY = "propertyKey";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String GRAPH_VERTEX_ID = "graphVertexId";
    public static final String GRAPH_EDGE_ID = "graphEdgeId";
    public static final String WORKSPACE_ID = "workspaceId";
    public static final String VISIBILITY_SOURCE = "visibilitySource";
    public static final String PRIORITY = "priority";
    public static final String STATUS = "status";
    public static final String BEFORE_ACTION_TIMESTAMP = "beforeActionTimestamp";
    private JSONObject _obj;

    public boolean isValid() {
        return this.canHandleVertex() || this.canHandleEdge();
    }

    public GraphPropertyMessage(JSONObject obj) {
        this._obj = obj;
    }

    public String getWorkspaceId() {
        return this._obj.optString(WORKSPACE_ID, null);
    }

    public String getVisibilitySource() {
        return this._obj.optString(VISIBILITY_SOURCE, null);
    }

    public Priority getPriority() {
        String priorityString = this._obj.optString(PRIORITY, null);
        return Priority.safeParse(priorityString);
    }

    public String getPropertyKey() {
        return this._obj.optString(PROPERTY_KEY, "");
    }

    public String getPropertyName() {
        return this._obj.optString(PROPERTY_NAME, "");
    }

    public List<String> getVertexIds() {
        return GraphPropertyMessage.getListOfItemsFromJSONKey(this._obj, GRAPH_VERTEX_ID);
    }

    public List<String> getEdgeIds() {
        return GraphPropertyMessage.getListOfItemsFromJSONKey(this._obj, GRAPH_EDGE_ID);
    }

    public ElementOrPropertyStatus getStatus() {
        String status = this._obj.optString(STATUS, null);
        return ElementOrPropertyStatus.safeParse(status);
    }

    public long getBeforeActionTimestamp() {
        return this._obj.optLong(BEFORE_ACTION_TIMESTAMP, -1L);
    }

    public boolean canHandleVertex() {
        return GraphPropertyMessage.canHandleElementById(this.getVertexIds());
    }

    public boolean canHandleEdge() {
        return GraphPropertyMessage.canHandleElementById(this.getEdgeIds());
    }

    public boolean canHandleByProperty() {
        return this._obj.has(PROPERTY_KEY) || this._obj.has(PROPERTY_NAME);
    }

    public ProcessingType findProcessingType() {
        if (this.canHandleByProperty()) {
            return ProcessingType.PROPERTY;
        }
        if (this.canHandleVertex() || this.canHandleEdge()) {
            return ProcessingType.ELEMENT;
        }
        throw new VisalloException(String.format("Unable to determine processing type from invalid message %s", this._obj.toString()));
    }

    private static boolean canHandleElementById(List<String> id) {
        return id != null && !id.isEmpty();
    }

    private static List<String> getListOfItemsFromJSONKey(JSONObject obj, String key) {
        Object edges = obj.opt(key);
        if (edges == null) {
            return Lists.newArrayList();
        }
        if (edges instanceof JSONArray) {
            return JSONUtil.toStringList((JSONArray)edges);
        }
        if (edges instanceof String) {
            return Lists.newArrayList((Object[])new String[]{(String)edges});
        }
        throw new VisalloException("unknown format to parse messages");
    }

    public static enum ProcessingType {
        PROPERTY,
        ELEMENT;

    }
}

