/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.util.IterableUtils;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.ingest.graphProperty.GraphPropertyMessage;
import org.visallo.core.ingest.graphProperty.GraphPropertyThreadedWrapper;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkData;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorker;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerInitializer;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerPrepareData;
import org.visallo.core.ingest.graphProperty.TermMentionFilter;
import org.visallo.core.ingest.graphProperty.TermMentionFilterPrepareData;
import org.visallo.core.ingest.graphProperty.VerifyResults;
import org.visallo.core.model.WorkQueueNames;
import org.visallo.core.model.WorkerBase;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.status.StatusRepository;
import org.visallo.core.status.StatusServer;
import org.visallo.core.status.model.GraphPropertyRunnerStatus;
import org.visallo.core.status.model.ProcessStatus;
import org.visallo.core.user.User;
import org.visallo.core.util.ServiceLoaderUtil;
import org.visallo.core.util.TeeInputStream;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

@Singleton
public class GraphPropertyRunner
extends WorkerBase {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphPropertyRunner.class);
    private final StatusRepository statusRepository;
    private final AuthorizationRepository authorizationRepository;
    private Graph graph;
    private Authorizations authorizations;
    private List<GraphPropertyThreadedWrapper> workerWrappers = Lists.newArrayList();
    private User user;
    private UserRepository userRepository;
    private WorkQueueNames workQueueNames;
    private Configuration configuration;
    private VisibilityTranslator visibilityTranslator;
    private AtomicLong lastProcessedPropertyTime = new AtomicLong(0L);
    private List<GraphPropertyWorker> graphPropertyWorkers = Lists.newArrayList();

    @Inject
    protected GraphPropertyRunner(WorkQueueRepository workQueueRepository, StatusRepository statusRepository, Configuration configuration, AuthorizationRepository authorizationRepository) {
        super(workQueueRepository, configuration);
        this.statusRepository = statusRepository;
        this.authorizationRepository = authorizationRepository;
    }

    @Override
    public void process(Object messageId, JSONObject json) throws Exception {
        GraphPropertyMessage message = new GraphPropertyMessage(json);
        if (!message.isValid()) {
            throw new VisalloException(String.format("Cannot process unknown type of gpw message %s", json.toString()));
        }
        if (message.canHandleByProperty()) {
            this.safeExecuteHandlePropertyOnElements(message);
        } else {
            this.safeExecuteHandleAllEntireElements(message);
        }
    }

    public void prepare(User user) {
        this.prepare(user, new GraphPropertyWorkerInitializer());
    }

    public void prepare(User user, GraphPropertyWorkerInitializer repository) {
        this.setUser(user);
        this.setAuthorizations(this.authorizationRepository.getGraphAuthorizations(user, new String[0]));
        this.prepareWorkers(repository);
        this.getWorkQueueRepository().setGraphPropertyRunner(this);
    }

    public void prepareWorkers(GraphPropertyWorkerInitializer initializer) {
        List<TermMentionFilter> termMentionFilters = this.loadTermMentionFilters();
        GraphPropertyWorkerPrepareData workerPrepareData = new GraphPropertyWorkerPrepareData(this.configuration.toMap(), termMentionFilters, this.user, this.authorizations, InjectHelper.getInjector());
        Collection<GraphPropertyWorker> workers = InjectHelper.getInjectedServices(GraphPropertyWorker.class, this.configuration);
        for (GraphPropertyWorker worker : workers) {
            try {
                LOGGER.debug("verifying: %s", worker.getClass().getName());
                VerifyResults verifyResults = worker.verify();
                if (verifyResults != null && verifyResults.getFailures().size() > 0) {
                    LOGGER.error("graph property worker %s had errors verifying", worker.getClass().getName());
                    for (VerifyResults.Failure failure : verifyResults.getFailures()) {
                        LOGGER.error("  %s", failure.getMessage());
                    }
                }
                if (initializer == null) continue;
                initializer.initialize(worker);
            }
            catch (Exception ex) {
                LOGGER.error("Could not verify graph property worker %s", worker.getClass().getName(), ex);
            }
        }
        boolean failedToPrepareAtLeastOneGraphPropertyWorker = false;
        ArrayList wrappers = Lists.newArrayList();
        for (GraphPropertyWorker worker : workers) {
            try {
                LOGGER.debug("preparing: %s", worker.getClass().getName());
                worker.prepare(workerPrepareData);
            }
            catch (Exception ex) {
                LOGGER.error("Could not prepare graph property worker %s", worker.getClass().getName(), ex);
                failedToPrepareAtLeastOneGraphPropertyWorker = true;
            }
            GraphPropertyThreadedWrapper wrapper = new GraphPropertyThreadedWrapper(worker);
            InjectHelper.inject(wrapper);
            wrappers.add(wrapper);
            Thread thread = new Thread(wrapper);
            String workerName = worker.getClass().getName();
            thread.setName("graphPropertyWorker-" + workerName);
            thread.start();
        }
        this.addGraphPropertyThreadedWrappers(wrappers);
        this.graphPropertyWorkers.addAll(workers);
        if (failedToPrepareAtLeastOneGraphPropertyWorker) {
            throw new VisalloException("Failed to initialize at least one graph property worker. See the log for more details.");
        }
    }

    public void addGraphPropertyThreadedWrappers(List<GraphPropertyThreadedWrapper> wrappers) {
        this.workerWrappers.addAll(wrappers);
    }

    public void addGraphPropertyThreadedWrappers(GraphPropertyThreadedWrapper ... wrappers) {
        this.workerWrappers.addAll(Lists.newArrayList((Object[])wrappers));
    }

    private List<TermMentionFilter> loadTermMentionFilters() {
        TermMentionFilterPrepareData termMentionFilterPrepareData = new TermMentionFilterPrepareData(this.configuration.toMap(), this.user, this.authorizations, InjectHelper.getInjector());
        List termMentionFilters = IterableUtils.toList(ServiceLoaderUtil.load(TermMentionFilter.class, this.configuration));
        for (TermMentionFilter termMentionFilter : termMentionFilters) {
            try {
                termMentionFilter.prepare(termMentionFilterPrepareData);
            }
            catch (Exception ex) {
                throw new VisalloException("Could not initialize term mention filter: " + termMentionFilter.getClass().getName(), ex);
            }
        }
        return termMentionFilters;
    }

    @Override
    protected StatusServer createStatusServer() throws Exception {
        return new StatusServer(this.configuration, this.statusRepository, "graphProperty", GraphPropertyRunner.class){

            @Override
            protected ProcessStatus createStatus() {
                GraphPropertyRunnerStatus status = new GraphPropertyRunnerStatus();
                for (GraphPropertyThreadedWrapper graphPropertyThreadedWrapper : GraphPropertyRunner.this.workerWrappers) {
                    status.getRunningWorkers().add(graphPropertyThreadedWrapper.getStatus());
                }
                return status;
            }
        };
    }

    private void safeExecuteHandleAllEntireElements(GraphPropertyMessage message) throws Exception {
        List<Element> elements = this.getElement(message);
        for (Element element : elements) {
            this.safeExecuteHandleEntireElement(element, message);
        }
    }

    private void safeExecuteHandleEntireElement(Element element, GraphPropertyMessage message) throws Exception {
        this.safeExecuteHandlePropertyOnElement(element, null, message);
        for (Property property : element.getProperties()) {
            this.safeExecuteHandlePropertyOnElement(element, property, message);
        }
    }

    private List<Element> getVerticesFromMessage(GraphPropertyMessage message) {
        LinkedList vertices = Lists.newLinkedList();
        for (String vertexId : message.getVertexIds()) {
            Vertex vertex = message.getStatus() == ElementOrPropertyStatus.DELETION || message.getStatus() == ElementOrPropertyStatus.HIDDEN ? this.graph.getVertex(vertexId, FetchHint.ALL, Long.valueOf(message.getBeforeActionTimestamp()), this.authorizations) : this.graph.getVertex(vertexId, this.authorizations);
            if (this.doesExist((Element)vertex)) {
                vertices.add(vertex);
                continue;
            }
            LOGGER.warn("Could not find vertex with id %s", vertexId);
        }
        return vertices;
    }

    private List<Element> getEdgesFromMessage(GraphPropertyMessage message) {
        LinkedList edges = Lists.newLinkedList();
        for (String edgeId : message.getEdgeIds()) {
            Edge edge = message.getStatus() == ElementOrPropertyStatus.DELETION || message.getStatus() == ElementOrPropertyStatus.HIDDEN ? this.graph.getEdge(edgeId, FetchHint.ALL, Long.valueOf(message.getBeforeActionTimestamp()), this.authorizations) : this.graph.getEdge(edgeId, this.authorizations);
            if (this.doesExist((Element)edge)) {
                edges.add(edge);
                continue;
            }
            LOGGER.warn("Could not find edge with id %s", edgeId);
        }
        return edges;
    }

    private boolean doesExist(Element element) {
        return element != null;
    }

    private void safeExecuteHandlePropertyOnElements(GraphPropertyMessage message) throws Exception {
        List<Element> elements = this.getElement(message);
        for (Element element : elements) {
            Property property = this.getProperty(element, message);
            if (property != null) {
                this.safeExecuteHandlePropertyOnElement(element, property, message);
                continue;
            }
            LOGGER.error("Could not find property [%s]:[%s] on vertex with id %s", message.getPropertyKey(), message.getPropertyName(), element.getId());
        }
    }

    private Property getProperty(Element element, GraphPropertyMessage message) {
        if (message.getPropertyName() == null) {
            return null;
        }
        Iterable properties = message.getPropertyKey() == null ? element.getProperties(message.getPropertyName()) : element.getProperties(message.getPropertyKey(), message.getPropertyName());
        Property result = null;
        for (Property property : properties) {
            if (message.getWorkspaceId() != null && property.getVisibility().hasAuthorization(message.getWorkspaceId())) {
                result = property;
                continue;
            }
            if (result != null) continue;
            result = property;
        }
        return result;
    }

    private void safeExecuteHandlePropertyOnElement(Element element, Property property, GraphPropertyMessage message) throws Exception {
        String propertyText = this.getPropertyText(property);
        ElementOrPropertyStatus status = message.getStatus();
        List<GraphPropertyThreadedWrapper> interestedWorkerWrappers = this.findInterestedWorkers(element, property, status);
        if (interestedWorkerWrappers.size() == 0) {
            LOGGER.debug("Could not find interested workers for %s %s property %s (%s)", new Object[]{element instanceof Vertex ? "vertex" : "edge", element.getId(), propertyText, status});
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            for (GraphPropertyThreadedWrapper interestedWorkerWrapper : interestedWorkerWrappers) {
                LOGGER.debug("interested worker for %s %s property %s: %s (%s)", new Object[]{element instanceof Vertex ? "vertex" : "edge", element.getId(), propertyText, interestedWorkerWrapper.getWorker().getClass().getName(), status});
            }
        }
        GraphPropertyWorkData workData = new GraphPropertyWorkData(this.visibilityTranslator, element, property, message.getWorkspaceId(), message.getVisibilitySource(), message.getPriority(), message.getBeforeActionTimestamp(), status);
        LOGGER.debug("Begin work on element %s property %s", element.getId(), propertyText);
        if (property != null && property.getValue() instanceof StreamingPropertyValue) {
            StreamingPropertyValue spb = (StreamingPropertyValue)property.getValue();
            this.safeExecuteStreamingPropertyValue(interestedWorkerWrappers, workData, spb);
        } else {
            this.safeExecuteNonStreamingProperty(interestedWorkerWrappers, workData);
        }
        this.lastProcessedPropertyTime.set(System.currentTimeMillis());
        this.graph.flush();
        LOGGER.debug("Completed work on %s", propertyText);
    }

    private String getPropertyText(Property property) {
        return property == null ? "[none]" : property.getKey() + ":" + property.getName();
    }

    private void safeExecuteNonStreamingProperty(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers, GraphPropertyWorkData workData) throws Exception {
        for (GraphPropertyThreadedWrapper interestedWorkerWrapper1 : interestedWorkerWrappers) {
            interestedWorkerWrapper1.enqueueWork(null, workData);
        }
        for (GraphPropertyThreadedWrapper interestedWorkerWrapper : interestedWorkerWrappers) {
            interestedWorkerWrapper.dequeueResult(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void safeExecuteStreamingPropertyValue(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers, GraphPropertyWorkData workData, StreamingPropertyValue streamingPropertyValue) throws Exception {
        String[] workerNames = this.graphPropertyThreadedWrapperToNames(interestedWorkerWrappers);
        InputStream in = streamingPropertyValue.getInputStream();
        File tempFile = null;
        try {
            boolean requiresLocalFile = this.isLocalFileRequired(interestedWorkerWrappers);
            if (requiresLocalFile) {
                tempFile = this.copyToTempFile(in, workData);
                in = new FileInputStream(tempFile);
            }
            TeeInputStream teeInputStream = new TeeInputStream(in, workerNames);
            for (int i = 0; i < interestedWorkerWrappers.size(); ++i) {
                interestedWorkerWrappers.get(i).enqueueWork(teeInputStream.getTees()[i], workData);
            }
            teeInputStream.loopUntilTeesAreClosed();
            for (GraphPropertyThreadedWrapper interestedWorkerWrapper : interestedWorkerWrappers) {
                interestedWorkerWrapper.dequeueResult(false);
            }
            if (tempFile == null || tempFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (tempFile == null || tempFile.delete()) throw throwable;
            LOGGER.warn("Could not delete temp file %s", tempFile.getAbsolutePath());
            throw throwable;
        }
        LOGGER.warn("Could not delete temp file %s", tempFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyToTempFile(InputStream in, GraphPropertyWorkData workData) throws IOException {
        String fileExt = null;
        String fileName = (String)VisalloProperties.FILE_NAME.getOnlyPropertyValue(workData.getElement());
        if (fileName != null) {
            fileExt = FilenameUtils.getExtension((String)fileName);
        }
        if (fileExt == null) {
            fileExt = "data";
        }
        File tempFile = File.createTempFile("graphPropertyBolt", fileExt);
        workData.setLocalFile(tempFile);
        try (FileOutputStream tempFileOut = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)in, (OutputStream)tempFileOut);
        }
        finally {
            in.close();
        }
        return tempFile;
    }

    private boolean isLocalFileRequired(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers) {
        for (GraphPropertyThreadedWrapper worker : interestedWorkerWrappers) {
            if (!worker.getWorker().isLocalFileRequired()) continue;
            return true;
        }
        return false;
    }

    private List<GraphPropertyThreadedWrapper> findInterestedWorkers(Element element, Property property, ElementOrPropertyStatus status) {
        Set graphPropertyWorkerWhiteList = IterableUtils.toSet(VisalloProperties.GRAPH_PROPERTY_WORKER_WHITE_LIST.getPropertyValues(element));
        Set graphPropertyWorkerBlackList = IterableUtils.toSet(VisalloProperties.GRAPH_PROPERTY_WORKER_BLACK_LIST.getPropertyValues(element));
        ArrayList<GraphPropertyThreadedWrapper> interestedWorkers = new ArrayList<GraphPropertyThreadedWrapper>();
        for (GraphPropertyThreadedWrapper wrapper : this.workerWrappers) {
            String graphPropertyWorkerName = wrapper.getWorker().getClass().getName();
            if (graphPropertyWorkerWhiteList.size() > 0 && !graphPropertyWorkerWhiteList.contains(graphPropertyWorkerName) || graphPropertyWorkerBlackList.contains(graphPropertyWorkerName)) continue;
            GraphPropertyWorker worker = wrapper.getWorker();
            if (status == ElementOrPropertyStatus.DELETION) {
                this.addDeletedWorkers(interestedWorkers, worker, wrapper, element, property);
                continue;
            }
            if (status == ElementOrPropertyStatus.HIDDEN) {
                this.addHiddenWorkers(interestedWorkers, worker, wrapper, element, property);
                continue;
            }
            if (status == ElementOrPropertyStatus.UNHIDDEN) {
                this.addUnhiddenWorkers(interestedWorkers, worker, wrapper, element, property);
                continue;
            }
            if (!worker.isHandled(element, property)) continue;
            interestedWorkers.add(wrapper);
        }
        return interestedWorkers;
    }

    private void addDeletedWorkers(List<GraphPropertyThreadedWrapper> interestedWorkers, GraphPropertyWorker worker, GraphPropertyThreadedWrapper wrapper, Element element, Property property) {
        if (worker.isDeleteHandled(element, property)) {
            interestedWorkers.add(wrapper);
        }
    }

    private void addHiddenWorkers(List<GraphPropertyThreadedWrapper> interestedWorkers, GraphPropertyWorker worker, GraphPropertyThreadedWrapper wrapper, Element element, Property property) {
        if (worker.isHiddenHandled(element, property)) {
            interestedWorkers.add(wrapper);
        }
    }

    private void addUnhiddenWorkers(List<GraphPropertyThreadedWrapper> interestedWorkers, GraphPropertyWorker worker, GraphPropertyThreadedWrapper wrapper, Element element, Property property) {
        if (worker.isUnhiddenHandled(element, property)) {
            interestedWorkers.add(wrapper);
        }
    }

    private String[] graphPropertyThreadedWrapperToNames(List<GraphPropertyThreadedWrapper> interestedWorkerWrappers) {
        String[] names = new String[interestedWorkerWrappers.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = interestedWorkerWrappers.get(i).getWorker().getClass().getName();
        }
        return names;
    }

    private List<Element> getElement(GraphPropertyMessage message) {
        if (message.canHandleVertex()) {
            return this.getVerticesFromMessage(message);
        }
        if (message.canHandleEdge()) {
            return this.getEdgesFromMessage(message);
        }
        throw new VisalloException(String.format("Could not find %s or %s", "graphVertexId", "graphEdgeId"));
    }

    public void shutdown() {
        for (GraphPropertyThreadedWrapper wrapper : this.workerWrappers) {
            wrapper.stop();
        }
        super.stop();
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Inject
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Inject
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Inject
    public void setWorkQueueNames(WorkQueueNames workQueueNames) {
        this.workQueueNames = workQueueNames;
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setVisibilityTranslator(VisibilityTranslator visibilityTranslator) {
        this.visibilityTranslator = visibilityTranslator;
    }

    public void setAuthorizations(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    public long getLastProcessedTime() {
        return this.lastProcessedPropertyTime.get();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    protected String getQueueName() {
        return this.workQueueNames.getGraphPropertyQueueName();
    }

    public boolean isStarted() {
        return this.shouldRun();
    }

    public boolean canHandle(Element element, String propertyKey, String propertyName) {
        if (!this.isStarted()) {
            return true;
        }
        Property property = element.getProperty(propertyKey, propertyName);
        for (GraphPropertyWorker worker : this.getAllGraphPropertyWorkers()) {
            try {
                if (worker.isHandled(element, property)) {
                    return true;
                }
                if (worker.isDeleteHandled(element, property)) {
                    return true;
                }
                if (worker.isHiddenHandled(element, property)) {
                    return true;
                }
                if (!worker.isUnhiddenHandled(element, property)) continue;
                return true;
            }
            catch (Throwable t) {
                LOGGER.warn("Error checking to see if workers will handle graph property message.  Queueing anyways in case there was just a local error", t);
                return true;
            }
        }
        LOGGER.debug("No interested workers for %s %s %s so did not queue it", element.getId(), propertyKey, propertyName);
        return false;
    }

    private Collection<GraphPropertyWorker> getAllGraphPropertyWorkers() {
        return Lists.newArrayList(this.graphPropertyWorkers);
    }
}

