/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.lock;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.lock.LeaderListener;
import org.visallo.core.model.lock.Lock;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;

public class SingleJvmLockRepository
extends LockRepository
implements ShutdownListener {
    private WeakHashMap<Long, Thread> threads = new WeakHashMap();

    @VisibleForTesting
    public SingleJvmLockRepository() {
    }

    @Inject
    public SingleJvmLockRepository(ShutdownService shutdownService) {
        shutdownService.register(this);
    }

    @Override
    public Lock createLock(String lockName) {
        final Object synchronizationObject = this.getSynchronizationObject(lockName);
        return new Lock(lockName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T run(Callable<T> callable) {
                try {
                    Object object = synchronizationObject;
                    synchronized (object) {
                        return callable.call();
                    }
                }
                catch (Exception ex) {
                    throw new VisalloException("Failed to run in lock", ex);
                }
            }
        };
    }

    @Override
    public void leaderElection(String lockName, LeaderListener listener) {
        Object synchronizationObject = this.getSynchronizationObject(lockName);
        Thread t = new Thread(() -> {
            Object object = synchronizationObject;
            synchronized (object) {
                try {
                    listener.isLeader();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        t.setName(SingleJvmLockRepository.class.getSimpleName() + "-LeaderElection-" + lockName);
        t.setDaemon(true);
        t.start();
        this.threads.put(t.getId(), t);
    }

    @Override
    public void shutdown() {
        for (Thread thread : this.threads.values()) {
            thread.interrupt();
        }
    }
}

