/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.properties.types;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.core.model.properties.types.PropertyMetadata;

public abstract class MetadataVisalloProperty<TRaw, TGraph> {
    private final String metadataKey;

    protected MetadataVisalloProperty(String metadataKey) {
        this.metadataKey = metadataKey;
    }

    public abstract TGraph wrap(TRaw var1);

    public abstract TRaw unwrap(Object var1);

    public String getMetadataKey() {
        return this.metadataKey;
    }

    public TRaw getMetadataValue(Metadata metadata) {
        return this.unwrap(metadata.getValue(this.getMetadataKey()));
    }

    public Collection<TRaw> getMetadataValues(Metadata metadata) {
        return metadata.getValues(this.getMetadataKey()).stream().map(this::unwrap).collect(Collectors.toList());
    }

    public TRaw getMetadataValueOrDefault(Metadata metadata, TRaw defaultValue) {
        Object value = metadata.getValue(this.getMetadataKey());
        if (value == null) {
            return defaultValue;
        }
        return this.unwrap(value);
    }

    public TRaw getMetadataValue(Metadata metadata, TRaw defaultValue) {
        if (metadata.getEntry(this.getMetadataKey()) == null) {
            return defaultValue;
        }
        return this.unwrap(metadata.getValue(this.getMetadataKey()));
    }

    public TRaw getMetadataValue(Map<String, Object> metadata) {
        return (TRaw)metadata.get(this.getMetadataKey());
    }

    public void setMetadata(Metadata metadata, TRaw value, Visibility visibility) {
        metadata.add(this.getMetadataKey(), this.wrap(value), visibility);
    }

    public void setMetadata(PropertyMetadata metadata, TRaw value, Visibility visibility) {
        metadata.add(this.getMetadataKey(), this.wrap(value), visibility);
    }

    public void setMetadata(ExistingElementMutation m, Property property, TRaw value, Visibility visibility) {
        m.setPropertyMetadata(property, this.getMetadataKey(), this.wrap(value), visibility);
    }
}

