/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.search;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.model.search.SearchRunner;
import org.visallo.core.model.search.VertexFindRelatedSearchResults;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;

public class VertexFindRelatedSearchRunner
extends SearchRunner {
    public static final String URI = "/vertex/find-related";
    private final OntologyRepository ontologyRepository;
    private final Graph graph;

    @Inject
    public VertexFindRelatedSearchRunner(Graph graph, OntologyRepository ontologyRepository) {
        this.graph = graph;
        this.ontologyRepository = ontologyRepository;
    }

    @Override
    public String getUri() {
        return URI;
    }

    @Override
    public VertexFindRelatedSearchResults run(SearchOptions searchOptions, User user, Authorizations authorizations) {
        String[] graphVertexIds = searchOptions.getRequiredParameter("graphVertexIds[]", String[].class);
        String limitParentConceptId = (String)((Object)searchOptions.getOptionalParameter("limitParentConceptId", String.class));
        String limitEdgeLabel = (String)((Object)searchOptions.getOptionalParameter("limitEdgeLabel", String.class));
        long maxVerticesToReturn = searchOptions.getOptionalParameter("maxVerticesToReturn", 250L);
        HashSet<String> limitConceptIds = new HashSet<String>();
        if (limitParentConceptId != null) {
            Set<Concept> limitConcepts = this.ontologyRepository.getConceptAndAllChildrenByIri(limitParentConceptId);
            if (limitConcepts == null) {
                throw new RuntimeException("Bad 'limitParentConceptId', no concept found for id: " + limitParentConceptId);
            }
            for (Concept con : limitConcepts) {
                limitConceptIds.add(con.getIRI());
            }
        }
        return this.getSearchResults(searchOptions.getWorkspaceId(), graphVertexIds, limitEdgeLabel, limitConceptIds, maxVerticesToReturn, authorizations);
    }

    private VertexFindRelatedSearchResults getSearchResults(String workspaceId, String[] graphVertexIds, String limitEdgeLabel, Set<String> limitConceptIds, long maxVerticesToReturn, Authorizations authorizations) {
        HashSet<String> visitedIds = new HashSet<String>();
        long count = visitedIds.size();
        Iterable vertices = this.graph.getVertices((Iterable)Lists.newArrayList((Object[])graphVertexIds), FetchHint.EDGE_REFS, authorizations);
        ArrayList<Vertex> elements = new ArrayList<Vertex>();
        for (Vertex v : vertices) {
            Iterable relatedVertices = v.getVertices(Direction.BOTH, limitEdgeLabel, ClientApiConverter.SEARCH_FETCH_HINTS, authorizations);
            for (Vertex vertex : relatedVertices) {
                if (!visitedIds.add(vertex.getId()) || limitConceptIds.size() != 0 && this.isLimited(vertex, limitConceptIds)) continue;
                if (count < maxVerticesToReturn) {
                    elements.add(vertex);
                }
                ++count;
            }
        }
        return new VertexFindRelatedSearchResults(elements, count);
    }

    private boolean isLimited(Vertex vertex, Set<String> limitConceptIds) {
        String conceptId = (String)VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)vertex);
        return !limitConceptIds.contains(conceptId);
    }
}

