/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingEdgeMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Dashboard;
import org.visallo.core.model.workspace.DashboardItem;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceDiffHelper;
import org.visallo.core.model.workspace.WorkspaceEntity;
import org.visallo.core.model.workspace.WorkspaceUser;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.trace.Traced;
import org.visallo.core.user.User;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.core.util.StreamUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiPropertyPublishItem;
import org.visallo.web.clientapi.model.ClientApiPublishItem;
import org.visallo.web.clientapi.model.ClientApiRelationshipPublishItem;
import org.visallo.web.clientapi.model.ClientApiVertexPublishItem;
import org.visallo.web.clientapi.model.ClientApiWorkspace;
import org.visallo.web.clientapi.model.ClientApiWorkspaceDiff;
import org.visallo.web.clientapi.model.ClientApiWorkspacePublishResponse;
import org.visallo.web.clientapi.model.GraphPosition;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.clientapi.model.WorkspaceAccess;

public abstract class WorkspaceRepository {
    public static final String TO_ENTITY_ID_SEPARATOR = "_TO_ENTITY_";
    public static final String VISIBILITY_STRING = "workspace";
    public static final VisalloVisibility VISIBILITY = new VisalloVisibility("workspace");
    public static final String WORKSPACE_CONCEPT_IRI = "http://visallo.org/workspace#workspace";
    public static final String WORKSPACE_TO_ENTITY_RELATIONSHIP_IRI = "http://visallo.org/workspace#toEntity";
    public static final String WORKSPACE_TO_USER_RELATIONSHIP_IRI = "http://visallo.org/workspace#toUser";
    public static final String WORKSPACE_ID_PREFIX = "WORKSPACE_";
    public static final String OWL_IRI = "http://visallo.org/workspace";
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceRepository.class);
    private final Graph graph;
    private final VisibilityTranslator visibilityTranslator;
    private final TermMentionRepository termMentionRepository;
    private final OntologyRepository ontologyRepository;
    private final WorkQueueRepository workQueueRepository;
    private String entityHasImageIri;
    private final AuthorizationRepository authorizationRepository;

    protected WorkspaceRepository(Graph graph, VisibilityTranslator visibilityTranslator, TermMentionRepository termMentionRepository, OntologyRepository ontologyRepository, WorkQueueRepository workQueueRepository, AuthorizationRepository authorizationRepository) {
        this.graph = graph;
        this.visibilityTranslator = visibilityTranslator;
        this.termMentionRepository = termMentionRepository;
        this.ontologyRepository = ontologyRepository;
        this.workQueueRepository = workQueueRepository;
        this.entityHasImageIri = ontologyRepository.getRelationshipIRIByIntent("entityHasImage");
        this.authorizationRepository = authorizationRepository;
        if (this.entityHasImageIri == null) {
            LOGGER.warn("'entityHasImage' intent has not been defined. Please update your ontology.", new Object[0]);
        }
    }

    public static String getWorkspaceToEntityEdgeId(String workspaceVertexId, String entityVertexId) {
        return workspaceVertexId + TO_ENTITY_ID_SEPARATOR + entityVertexId;
    }

    public abstract void delete(Workspace var1, User var2);

    public Workspace findById(String workspaceId, User user) {
        return this.findById(workspaceId, false, user);
    }

    public abstract Workspace findById(String var1, boolean var2, User var3);

    public Iterable<Workspace> findByIds(Iterable<String> workspaceIds, final User user) {
        return new ConvertingIterable<String, Workspace>(workspaceIds){

            protected Workspace convert(String workspaceId) {
                if (workspaceId == null) {
                    return null;
                }
                try {
                    return WorkspaceRepository.this.findById(workspaceId, user);
                }
                catch (VisalloAccessDeniedException ex) {
                    return null;
                }
            }
        };
    }

    public abstract Workspace add(String var1, String var2, User var3);

    public Workspace add(String title, User user) {
        return this.add(null, title, user);
    }

    public abstract Iterable<Workspace> findAllForUser(User var1);

    public abstract Iterable<Workspace> findAll(User var1);

    public abstract void setTitle(Workspace var1, String var2, User var3);

    public abstract List<WorkspaceUser> findUsersWithAccess(String var1, User var2);

    public List<WorkspaceEntity> findEntities(Workspace workspace, User user) {
        return this.findEntities(workspace, false, user);
    }

    public abstract List<WorkspaceEntity> findEntities(Workspace var1, boolean var2, User var3);

    public Workspace copy(Workspace workspace, User user) {
        return this.copyTo(workspace, user, user);
    }

    public Workspace copyTo(Workspace workspace, User destinationUser, User user) {
        Workspace newWorkspace = this.add("Copy of " + workspace.getDisplayTitle(), destinationUser);
        List<WorkspaceEntity> entities = this.findEntities(workspace, user);
        List updates = Lists.transform(entities, (Function)new Function<WorkspaceEntity, Update>(){

            @Nullable
            public Update apply(WorkspaceEntity entity) {
                return new Update(entity.getEntityVertexId(), entity.isVisible(), new GraphPosition(entity.getGraphPositionX().intValue(), entity.getGraphPositionY().intValue()));
            }
        });
        this.updateEntitiesOnWorkspace(newWorkspace, updates, destinationUser);
        return newWorkspace;
    }

    public abstract void softDeleteEntitiesFromWorkspace(Workspace var1, List<String> var2, User var3);

    public abstract void deleteUserFromWorkspace(Workspace var1, String var2, User var3);

    public abstract UpdateUserOnWorkspaceResult updateUserOnWorkspace(Workspace var1, String var2, WorkspaceAccess var3, User var4);

    public abstract ClientApiWorkspaceDiff getDiff(Workspace var1, User var2, Locale var3, String var4);

    public String getCreatorUserId(String workspaceId, User user) {
        for (WorkspaceUser workspaceUser : this.findUsersWithAccess(workspaceId, user)) {
            if (!workspaceUser.isCreator()) continue;
            return workspaceUser.getUserId();
        }
        return null;
    }

    public abstract boolean hasCommentPermissions(String var1, User var2);

    public abstract boolean hasWritePermissions(String var1, User var2);

    public abstract boolean hasReadPermissions(String var1, User var2);

    public JSONArray toJson(Iterable<Workspace> workspaces, User user, boolean includeVertices) {
        JSONArray resultJson = new JSONArray();
        for (Workspace workspace : workspaces) {
            resultJson.put((Object)this.toJson(workspace, user, includeVertices));
        }
        return resultJson;
    }

    public JSONObject toJson(Workspace workspace, User user, boolean includeVertices) {
        Preconditions.checkNotNull((Object)workspace, (Object)"workspace cannot be null");
        Preconditions.checkNotNull((Object)user, (Object)"user cannot be null");
        try {
            JSONObject workspaceJson = new JSONObject();
            workspaceJson.put("workspaceId", (Object)workspace.getWorkspaceId());
            workspaceJson.put("title", (Object)workspace.getDisplayTitle());
            String creatorUserId = this.getCreatorUserId(workspace.getWorkspaceId(), user);
            if (creatorUserId != null) {
                workspaceJson.put("createdBy", (Object)creatorUserId);
                workspaceJson.put("sharedToUser", !creatorUserId.equals(user.getUserId()));
            }
            workspaceJson.put("editable", this.hasWritePermissions(workspace.getWorkspaceId(), user));
            JSONArray usersJson = new JSONArray();
            for (WorkspaceUser workspaceUser : this.findUsersWithAccess(workspace.getWorkspaceId(), user)) {
                String userId = workspaceUser.getUserId();
                JSONObject userJson = new JSONObject();
                userJson.put("userId", (Object)userId);
                userJson.put("access", (Object)workspaceUser.getWorkspaceAccess().toString().toLowerCase());
                usersJson.put((Object)userJson);
            }
            workspaceJson.put("users", (Object)usersJson);
            if (includeVertices) {
                JSONArray verticesJson = new JSONArray();
                for (WorkspaceEntity workspaceEntity : this.findEntities(workspace, user)) {
                    if (!workspaceEntity.isVisible()) continue;
                    JSONObject vertexJson = new JSONObject();
                    vertexJson.put("vertexId", (Object)workspaceEntity.getEntityVertexId());
                    Integer graphPositionX = workspaceEntity.getGraphPositionX();
                    Integer graphPositionY = workspaceEntity.getGraphPositionY();
                    if (graphPositionX != null && graphPositionY != null) {
                        JSONObject graphPositionJson = new JSONObject();
                        graphPositionJson.put("x", (Object)graphPositionX);
                        graphPositionJson.put("y", (Object)graphPositionY);
                        vertexJson.put("graphPosition", (Object)graphPositionJson);
                    }
                    verticesJson.put((Object)vertexJson);
                }
                workspaceJson.put("vertices", (Object)verticesJson);
            }
            return workspaceJson;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientApiWorkspace toClientApi(Workspace workspace, User user, boolean includeVertices, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)workspace, (Object)"workspace cannot be null");
        Preconditions.checkNotNull((Object)user, (Object)"user cannot be null");
        try {
            ClientApiWorkspace workspaceClientApi = new ClientApiWorkspace();
            workspaceClientApi.setWorkspaceId(workspace.getWorkspaceId());
            workspaceClientApi.setTitle(workspace.getDisplayTitle());
            String creatorUserId = this.getCreatorUserId(workspace.getWorkspaceId(), user);
            if (creatorUserId == null) {
                workspaceClientApi.setSharedToUser(true);
            } else {
                workspaceClientApi.setCreatedBy(creatorUserId);
                workspaceClientApi.setSharedToUser(!creatorUserId.equals(user.getUserId()));
            }
            workspaceClientApi.setEditable(this.hasWritePermissions(workspace.getWorkspaceId(), user));
            workspaceClientApi.setCommentable(this.hasCommentPermissions(workspace.getWorkspaceId(), user));
            for (WorkspaceUser u : this.findUsersWithAccess(workspace.getWorkspaceId(), user)) {
                String userId = u.getUserId();
                ClientApiWorkspace.User workspaceUser = new ClientApiWorkspace.User();
                workspaceUser.setUserId(userId);
                workspaceUser.setAccess(u.getWorkspaceAccess());
                workspaceClientApi.addUser(workspaceUser);
            }
            if (includeVertices) {
                List<WorkspaceEntity> workspaceEntities = this.findEntities(workspace, user);
                Iterable workspaceEntityIds = workspaceEntities.stream().map(workspaceEntity -> workspaceEntity.getEntityVertexId()).collect(Collectors.toList());
                Map viewableVertices = this.getGraph().doVerticesExist(workspaceEntityIds, authorizations);
                for (WorkspaceEntity workspaceEntity2 : workspaceEntities) {
                    if (!workspaceEntity2.isVisible() || !((Boolean)viewableVertices.get(workspaceEntity2.getEntityVertexId())).booleanValue()) continue;
                    ClientApiWorkspace.Vertex v = new ClientApiWorkspace.Vertex();
                    v.setVertexId(workspaceEntity2.getEntityVertexId());
                    v.setVisible(workspaceEntity2.isVisible());
                    Integer graphPositionX = workspaceEntity2.getGraphPositionX();
                    Integer graphPositionY = workspaceEntity2.getGraphPositionY();
                    if (graphPositionX != null && graphPositionY != null) {
                        GraphPosition graphPosition = new GraphPosition(graphPositionX.intValue(), graphPositionY.intValue());
                        v.setGraphPosition(graphPosition);
                        v.setGraphLayoutJson(null);
                    } else {
                        v.setGraphPosition(null);
                        String graphLayoutJson = workspaceEntity2.getGraphLayoutJson();
                        if (graphLayoutJson != null) {
                            v.setGraphLayoutJson(graphLayoutJson);
                        } else {
                            v.setGraphLayoutJson("{}");
                        }
                    }
                    workspaceClientApi.addVertex(v);
                }
            } else {
                workspaceClientApi.removeVertices();
            }
            return workspaceClientApi;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected Graph getGraph() {
        return this.graph;
    }

    public abstract void updateEntitiesOnWorkspace(Workspace var1, Collection<Update> var2, User var3);

    public void updateEntityOnWorkspace(Workspace workspace, Update update, User user) {
        ArrayList<Update> updates = new ArrayList<Update>();
        updates.add(update);
        this.updateEntitiesOnWorkspace(workspace, updates, user);
    }

    public void updateEntityOnWorkspace(Workspace workspace, String vertexId, Boolean visible, GraphPosition graphPosition, User user) {
        this.updateEntityOnWorkspace(workspace, new Update(vertexId, visible, graphPosition), user);
    }

    public void updateEntityOnWorkspace(String workspaceId, String vertexId, Boolean visible, GraphPosition graphPosition, User user) {
        Workspace workspace = this.findById(workspaceId, user);
        this.updateEntityOnWorkspace(workspace, vertexId, visible, graphPosition, user);
    }

    public ClientApiWorkspacePublishResponse publish(ClientApiPublishItem[] publishData, String workspaceId, Authorizations authorizations) {
        if (this.entityHasImageIri == null) {
            this.entityHasImageIri = this.ontologyRepository.getRequiredRelationshipIRIByIntent("entityHasImage");
        }
        ClientApiWorkspacePublishResponse workspacePublishResponse = new ClientApiWorkspacePublishResponse();
        this.publishVertices(publishData, ClientApiPublishItem.Action.ADD_OR_UPDATE, workspacePublishResponse, workspaceId, authorizations);
        this.publishEdges(publishData, ClientApiPublishItem.Action.ADD_OR_UPDATE, workspacePublishResponse, workspaceId, authorizations);
        this.publishProperties(publishData, workspacePublishResponse, workspaceId, authorizations);
        this.publishEdges(publishData, ClientApiPublishItem.Action.DELETE, workspacePublishResponse, workspaceId, authorizations);
        this.publishVertices(publishData, ClientApiPublishItem.Action.DELETE, workspacePublishResponse, workspaceId, authorizations);
        return workspacePublishResponse;
    }

    private void publishVertices(ClientApiPublishItem[] publishData, ClientApiPublishItem.Action action, ClientApiWorkspacePublishResponse workspacePublishResponse, String workspaceId, Authorizations authorizations) {
        LOGGER.debug("BEGIN publishVertices", new Object[0]);
        for (ClientApiPublishItem data : publishData) {
            try {
                if (!(data instanceof ClientApiVertexPublishItem) || data.getAction() != action) continue;
                ClientApiVertexPublishItem vertexPublishItem = (ClientApiVertexPublishItem)data;
                String vertexId = vertexPublishItem.getVertexId();
                Preconditions.checkNotNull((Object)vertexId);
                Vertex vertex = this.graph.getVertex(vertexId, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
                Preconditions.checkNotNull((Object)vertex);
                if (SandboxStatusUtil.getSandboxStatus((Element)vertex, workspaceId) == SandboxStatus.PUBLIC && !WorkspaceDiffHelper.isPublicDelete(vertex, authorizations)) {
                    String msg = data.getAction() == ClientApiPublishItem.Action.DELETE ? "Cannot delete public vertex " + vertexId : "Vertex " + vertexId + " is already public";
                    LOGGER.warn(msg, new Object[0]);
                    data.setErrorMessage(msg);
                    workspacePublishResponse.addFailure(data);
                    continue;
                }
                this.publishVertex(vertex, data.getAction(), authorizations, workspaceId);
            }
            catch (Exception ex) {
                LOGGER.error("Error publishing %s", data.toString(), ex);
                data.setErrorMessage(ex.getMessage());
                workspacePublishResponse.addFailure(data);
            }
        }
        LOGGER.debug("END publishVertices", new Object[0]);
        this.graph.flush();
    }

    private void publishEdges(ClientApiPublishItem[] publishData, ClientApiPublishItem.Action action, ClientApiWorkspacePublishResponse workspacePublishResponse, String workspaceId, Authorizations authorizations) {
        LOGGER.debug("BEGIN publishEdges", new Object[0]);
        for (ClientApiPublishItem data : publishData) {
            try {
                String error_msg;
                if (!(data instanceof ClientApiRelationshipPublishItem) || data.getAction() != action) continue;
                ClientApiRelationshipPublishItem relationshipPublishItem = (ClientApiRelationshipPublishItem)data;
                Edge edge = this.graph.getEdge(relationshipPublishItem.getEdgeId(), FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
                Vertex outVertex = edge.getVertex(Direction.OUT, authorizations);
                Vertex inVertex = edge.getVertex(Direction.IN, authorizations);
                if (SandboxStatusUtil.getSandboxStatus((Element)edge, workspaceId) == SandboxStatus.PUBLIC && !WorkspaceDiffHelper.isPublicDelete(edge, authorizations)) {
                    error_msg = data.getAction() == ClientApiPublishItem.Action.DELETE ? "Cannot delete a public edge" : "Edge is already public";
                    LOGGER.warn(error_msg, new Object[0]);
                    data.setErrorMessage(error_msg);
                    workspacePublishResponse.addFailure(data);
                    continue;
                }
                if (outVertex != null && inVertex != null && SandboxStatusUtil.getSandboxStatus((Element)outVertex, workspaceId) != SandboxStatus.PUBLIC && SandboxStatusUtil.getSandboxStatus((Element)inVertex, workspaceId) != SandboxStatus.PUBLIC) {
                    error_msg = "Cannot publish edge, " + edge.getId() + ", because either source and/or dest vertex are not public";
                    LOGGER.warn(error_msg, new Object[0]);
                    data.setErrorMessage(error_msg);
                    workspacePublishResponse.addFailure(data);
                    continue;
                }
                this.publishEdge(edge, outVertex, inVertex, data.getAction(), workspaceId, authorizations);
            }
            catch (Exception ex) {
                LOGGER.error("Error publishing %s", data.toString(), ex);
                data.setErrorMessage(ex.getMessage());
                workspacePublishResponse.addFailure(data);
            }
        }
        LOGGER.debug("END publishEdges", new Object[0]);
        this.graph.flush();
    }

    private void publishProperties(ClientApiPublishItem[] publishData, ClientApiWorkspacePublishResponse workspacePublishResponse, String workspaceId, Authorizations authorizations) {
        LOGGER.debug("BEGIN publishProperties", new Object[0]);
        for (ClientApiPublishItem data : publishData) {
            try {
                if (!(data instanceof ClientApiPropertyPublishItem)) continue;
                ClientApiPropertyPublishItem propertyPublishItem = (ClientApiPropertyPublishItem)data;
                Element element = this.getPropertyElement(propertyPublishItem, authorizations);
                String propertyKey = propertyPublishItem.getKey();
                String propertyName = propertyPublishItem.getName();
                OntologyProperty ontologyProperty = this.ontologyRepository.getPropertyByIRI(propertyName);
                Preconditions.checkNotNull((Object)ontologyProperty, (Object)("Could not find ontology property: " + propertyName));
                if (!ontologyProperty.getUserVisible() || propertyName.equals(VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName())) continue;
                if (SandboxStatusUtil.getSandboxStatus(element, workspaceId) != SandboxStatus.PUBLIC) {
                    String errorMessage = "Cannot publish a modification of a property on a private element: " + element.getId();
                    VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue(element);
                    LOGGER.warn("%s: visibilityJson: %s, workspaceId: %s", errorMessage, visibilityJson == null ? null : visibilityJson.toString(), workspaceId);
                    data.setErrorMessage(errorMessage);
                    workspacePublishResponse.addFailure(data);
                    continue;
                }
                this.publishProperty(element, data.getAction(), propertyKey, propertyName, workspaceId, authorizations);
            }
            catch (Exception ex) {
                LOGGER.error("Error publishing %s", data.toString(), ex);
                data.setErrorMessage(ex.getMessage());
                workspacePublishResponse.addFailure(data);
            }
        }
        LOGGER.debug("END publishProperties", new Object[0]);
        this.graph.flush();
    }

    private Element getPropertyElement(ClientApiPropertyPublishItem data, Authorizations authorizations) {
        Edge element = null;
        String elementId = data.getEdgeId();
        if (elementId != null) {
            element = this.graph.getEdge(elementId, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        }
        if (element == null && (elementId = data.getVertexId()) != null) {
            element = this.graph.getVertex(elementId, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        }
        if (element == null) {
            elementId = data.getElementId();
            Preconditions.checkNotNull((Object)elementId, (Object)"elementId, vertexId, or edgeId is required to publish a property");
            element = this.graph.getVertex(elementId, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
            if (element == null) {
                element = this.graph.getEdge(elementId, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
            }
        }
        Preconditions.checkNotNull((Object)element, (Object)("Could not find edge/vertex with id: " + elementId));
        return element;
    }

    private void publishVertex(Vertex vertex, ClientApiPublishItem.Action action, Authorizations authorizations, String workspaceId) throws IOException {
        if (action == ClientApiPublishItem.Action.DELETE || WorkspaceDiffHelper.isPublicDelete(vertex, authorizations)) {
            long beforeDeletionTimestamp = System.currentTimeMillis() - 1L;
            this.graph.softDeleteVertex(vertex, authorizations);
            this.graph.flush();
            this.workQueueRepository.pushPublishedVertexDeletion(vertex, beforeDeletionTimestamp, Priority.HIGH);
            return;
        }
        Authorizations authWithVideoFrame = this.graph.createAuthorizations(authorizations, new String[]{"videoFrame"});
        vertex = this.graph.getVertex(vertex.getId(), authWithVideoFrame);
        LOGGER.debug("publishing vertex %s(%s)", vertex.getId(), vertex.getVisibility().toString());
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)vertex);
        if (!visibilityJson.getWorkspaces().contains(workspaceId)) {
            throw new VisalloException(String.format("vertex with id '%s' is not local to workspace '%s'", vertex.getId(), workspaceId));
        }
        visibilityJson = VisibilityJson.removeFromAllWorkspace((VisibilityJson)visibilityJson);
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        ExistingElementMutation vertexElementMutation = vertex.prepareMutation();
        vertexElementMutation.alterElementVisibility(visalloVisibility.getVisibility());
        for (Property property : vertex.getProperties()) {
            OntologyProperty ontologyProperty = this.ontologyRepository.getPropertyByIRI(property.getName());
            Preconditions.checkNotNull((Object)ontologyProperty, (Object)("Could not find ontology property " + property.getName()));
            boolean userVisible = ontologyProperty.getUserVisible();
            if (!this.shouldAutoPublishElementProperty(property, userVisible)) continue;
            this.publishNewProperty(vertexElementMutation, property, workspaceId);
        }
        Metadata metadata = new Metadata();
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation<?>)vertexElementMutation, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
        vertexElementMutation.save(authWithVideoFrame);
        for (Vertex termMention : this.termMentionRepository.findByVertexId(vertex.getId(), authorizations)) {
            this.termMentionRepository.updateVisibility(termMention, visalloVisibility.getVisibility(), authorizations);
        }
        this.graph.flush();
        this.workQueueRepository.broadcastPublishVertex(vertex);
    }

    private void publishProperty(Element element, ClientApiPublishItem.Action action, String key, String name, String workspaceId, Authorizations authorizations) {
        long beforeActionTimestamp = System.currentTimeMillis() - 1L;
        if (action == ClientApiPublishItem.Action.DELETE) {
            element.softDeleteProperty(key, name, authorizations);
            this.graph.flush();
            this.workQueueRepository.pushPublishedPropertyDeletion(element, key, name, beforeActionTimestamp, Priority.HIGH);
            return;
        }
        ExistingElementMutation elementMutation = element.prepareMutation();
        List properties = IterableUtils.toList((Iterable)element.getProperties(key, name));
        SandboxStatus[] sandboxStatuses = SandboxStatusUtil.getPropertySandboxStatuses(properties, workspaceId);
        boolean foundProperty = false;
        Property publicProperty = null;
        for (Property property : properties) {
            if (!WorkspaceDiffHelper.isPublicDelete(property, authorizations) || !WorkspaceDiffHelper.isPublicPropertyEdited(properties, sandboxStatuses, property)) continue;
            publicProperty = property;
            break;
        }
        for (int i = 0; i < properties.size(); ++i) {
            Property property;
            property = (Property)properties.get(i);
            Visibility propertyVisibility = property.getVisibility();
            SandboxStatus sandboxStatus = sandboxStatuses[i];
            if (WorkspaceDiffHelper.isPublicDelete(property, authorizations)) {
                if (publicProperty == null) {
                    element.softDeleteProperty(key, name, new Visibility(workspaceId), authorizations);
                    this.graph.flush();
                    this.workQueueRepository.pushPublishedPropertyDeletion(element, key, name, beforeActionTimestamp, Priority.HIGH);
                    foundProperty = true;
                }
            } else if (sandboxStatus == SandboxStatus.PUBLIC_CHANGED) {
                element.softDeleteProperty(key, name, propertyVisibility, authorizations);
                this.workQueueRepository.pushPublishedPropertyDeletion(element, key, name, beforeActionTimestamp, Priority.HIGH);
                if (publicProperty != null) {
                    element.markPropertyVisible(publicProperty, new Visibility(workspaceId), authorizations);
                    Visibility publicVisibility = publicProperty.getVisibility();
                    Metadata metadata = property.getMetadata();
                    VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(metadata);
                    VisibilityJson.removeFromWorkspace((VisibilityJson)visibilityJson, (String)workspaceId);
                    VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
                    Visibility newVisibility = this.visibilityTranslator.toVisibility(visibilityJson).getVisibility();
                    if (!publicVisibility.equals((Object)newVisibility)) {
                        element.softDeleteProperty(key, name, publicVisibility, authorizations);
                    } else {
                        newVisibility = publicVisibility;
                    }
                    element.addPropertyValue(key, name, property.getValue(), metadata, newVisibility, authorizations);
                    this.workQueueRepository.pushGraphPropertyQueue(element, key, name, ElementOrPropertyStatus.UNHIDDEN, beforeActionTimestamp, Priority.HIGH);
                }
                this.graph.flush();
                this.workQueueRepository.broadcastPublishProperty(element, key, name);
                foundProperty = true;
            } else if (this.publishNewProperty(elementMutation, property, workspaceId)) {
                elementMutation.save(authorizations);
                this.graph.flush();
                this.workQueueRepository.broadcastPublishProperty(element, key, name);
                foundProperty = true;
            }
            if (!foundProperty) continue;
            Iterable<Vertex> termMentions = element instanceof Vertex ? this.termMentionRepository.findByVertexIdAndProperty(element.getId(), property.getKey(), property.getName(), propertyVisibility, authorizations) : this.termMentionRepository.findByEdgeIdAndProperty((Edge)element, property.getKey(), property.getName(), propertyVisibility, authorizations);
            for (Vertex termMention : termMentions) {
                this.termMentionRepository.updateVisibility(termMention, property.getVisibility(), authorizations);
            }
        }
        if (!foundProperty) {
            throw new VisalloException(String.format("no property with key '%s' and name '%s' found on workspace '%s'", key, name, workspaceId));
        }
    }

    private boolean publishNewProperty(ExistingElementMutation elementMutation, Property property, String workspaceId) {
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata());
        if (visibilityJson == null) {
            LOGGER.warn("skipping property %s. no visibility json property", property.toString());
            return false;
        }
        if (!visibilityJson.getWorkspaces().contains(workspaceId)) {
            LOGGER.warn("skipping property %s. doesn't have workspace in json or is not hidden from this workspace.", property.toString());
            return false;
        }
        LOGGER.debug("publishing property %s:%s(%s)", property.getKey(), property.getName(), property.getVisibility().toString());
        visibilityJson = VisibilityJson.removeFromAllWorkspace((VisibilityJson)visibilityJson);
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        elementMutation.alterPropertyVisibility(property, visalloVisibility.getVisibility()).setPropertyMetadata(property, VisalloProperties.VISIBILITY_JSON.getPropertyName(), (Object)visibilityJson.toString(), this.visibilityTranslator.getDefaultVisibility());
        return true;
    }

    private void publishEdge(Edge edge, Vertex outVertex, Vertex inVertex, ClientApiPublishItem.Action action, String workspaceId, Authorizations authorizations) {
        if (action == ClientApiPublishItem.Action.DELETE || WorkspaceDiffHelper.isPublicDelete(edge, authorizations)) {
            long beforeDeletionTimestamp = System.currentTimeMillis() - 1L;
            this.graph.softDeleteEdge(edge, authorizations);
            this.graph.flush();
            this.workQueueRepository.pushPublishedEdgeDeletion(edge, beforeDeletionTimestamp, Priority.HIGH);
            return;
        }
        LOGGER.debug("publishing edge %s(%s)", edge.getId(), edge.getVisibility().toString());
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)edge);
        if (!visibilityJson.getWorkspaces().contains(workspaceId)) {
            throw new VisalloException(String.format("edge with id '%s' is not local to workspace '%s'", edge.getId(), workspaceId));
        }
        if (edge.getLabel().equals(this.entityHasImageIri)) {
            this.publishGlyphIconProperties(edge, workspaceId, authorizations);
        }
        edge.softDeleteProperty("", VisalloProperties.VISIBILITY_JSON.getPropertyName(), authorizations);
        visibilityJson = VisibilityJson.removeFromAllWorkspace((VisibilityJson)visibilityJson);
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        ExistingEdgeMutation edgeExistingElementMutation = edge.prepareMutation();
        edgeExistingElementMutation.alterElementVisibility(visalloVisibility.getVisibility());
        for (Property property : edge.getProperties()) {
            boolean userVisible;
            if (VisalloProperties.JUSTIFICATION.getPropertyName().equals(property.getName())) {
                userVisible = false;
            } else {
                OntologyProperty ontologyProperty = this.ontologyRepository.getPropertyByIRI(property.getName());
                Preconditions.checkNotNull((Object)ontologyProperty, (Object)("Could not find ontology property " + property.getName() + " on property " + property));
                userVisible = ontologyProperty.getUserVisible();
            }
            if (!this.shouldAutoPublishElementProperty(property, userVisible)) continue;
            this.publishNewProperty((ExistingElementMutation)edgeExistingElementMutation, property, workspaceId);
        }
        Metadata metadata = new Metadata();
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation<?>)edgeExistingElementMutation, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
        edge = (Edge)edgeExistingElementMutation.save(authorizations);
        for (Vertex termMention : this.termMentionRepository.findResolvedTo(inVertex.getId(), authorizations)) {
            this.termMentionRepository.updateVisibility(termMention, visalloVisibility.getVisibility(), authorizations);
        }
        for (Vertex termMention : this.termMentionRepository.findByEdgeForEdge(edge, authorizations)) {
            this.termMentionRepository.updateVisibility(termMention, visalloVisibility.getVisibility(), authorizations);
        }
        this.graph.flush();
        this.workQueueRepository.broadcastPublishEdge(edge);
    }

    private boolean shouldAutoPublishElementProperty(Property property, boolean userVisible) {
        if (userVisible) {
            return false;
        }
        String propertyName = property.getName();
        if (propertyName.equals(VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName())) {
            return false;
        }
        if (propertyName.equals(VisalloProperties.CONCEPT_TYPE.getPropertyName()) || propertyName.equals(VisalloProperties.MODIFIED_BY.getPropertyName()) || propertyName.equals(VisalloProperties.MODIFIED_DATE.getPropertyName()) || propertyName.equals(VisalloProperties.VISIBILITY_JSON.getPropertyName())) {
            VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata());
            if (visibilityJson != null) {
                LOGGER.warn("Property %s should not have visibility JSON metadata set", property.toString());
                return true;
            }
            if (!property.getVisibility().equals((Object)this.visibilityTranslator.getDefaultVisibility())) {
                LOGGER.warn("Property %s should have default visibility", property.toString());
                return true;
            }
            return false;
        }
        return true;
    }

    private void publishGlyphIconProperties(Edge hasImageEdge, String workspaceId, Authorizations authorizations) {
        Vertex entityVertex = hasImageEdge.getVertex(Direction.OUT, authorizations);
        Preconditions.checkNotNull((Object)entityVertex, (Object)("Could not find has image source vertex " + hasImageEdge.getVertexId(Direction.OUT)));
        ExistingElementMutation elementMutation = entityVertex.prepareMutation();
        Iterable glyphIconProperties = entityVertex.getProperties(VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName());
        for (Property glyphIconProperty : glyphIconProperties) {
            if (!this.publishNewProperty(elementMutation, glyphIconProperty, workspaceId)) continue;
            elementMutation.save(authorizations);
            return;
        }
        LOGGER.warn("new has image edge without a glyph icon property being set on vertex %s", entityVertex.getId());
    }

    public List<String> findEntityVertexIds(Workspace workspace, User user) {
        List<WorkspaceEntity> workspaceEntities = this.findEntities(workspace, user);
        return IterableUtils.toList((Iterable)new ConvertingIterable<WorkspaceEntity, String>(workspaceEntities){

            protected String convert(WorkspaceEntity workspaceEntity) {
                return workspaceEntity.getEntityVertexId();
            }
        });
    }

    @Traced
    protected Iterable<Edge> findModifiedEdges(Workspace workspace, List<WorkspaceEntity> workspaceEntities, boolean includeHidden, User user) {
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, VISIBILITY_STRING, workspace.getWorkspaceId());
        Iterable vertices = StreamUtil.stream(WorkspaceEntity.toVertices(workspaceEntities, this.getGraph(), authorizations)).filter(vertex -> vertex != null).collect(Collectors.toList());
        Iterable edgeIds = this.getGraph().findRelatedEdgeIdsForVertices(vertices, authorizations);
        return this.getGraph().getEdges(edgeIds, includeHidden ? FetchHint.ALL_INCLUDING_HIDDEN : FetchHint.ALL, authorizations);
    }

    public abstract Dashboard findDashboardById(String var1, String var2, User var3);

    public abstract void deleteDashboard(String var1, String var2, User var3);

    public abstract Collection<Dashboard> findAllDashboardsForWorkspace(String var1, User var2);

    public abstract DashboardItem findDashboardItemById(String var1, String var2, User var3);

    public abstract void deleteDashboardItem(String var1, String var2, User var3);

    protected VisibilityTranslator getVisibilityTranslator() {
        return this.visibilityTranslator;
    }

    protected TermMentionRepository getTermMentionRepository() {
        return this.termMentionRepository;
    }

    protected OntologyRepository getOntologyRepository() {
        return this.ontologyRepository;
    }

    protected WorkQueueRepository getWorkQueueRepository() {
        return this.workQueueRepository;
    }

    public abstract String addOrUpdateDashboardItem(String var1, String var2, String var3, String var4, String var5, String var6, User var7);

    public abstract String addOrUpdateDashboard(String var1, String var2, String var3, User var4);

    protected AuthorizationRepository getAuthorizationRepository() {
        return this.authorizationRepository;
    }

    public static class Update {
        private final String vertexId;
        private final Boolean visible;
        private final GraphPosition graphPosition;
        private final String graphLayoutJson;

        public Update(String vertexId, Boolean visible, GraphPosition graphPosition) {
            this.vertexId = vertexId;
            this.visible = visible;
            this.graphPosition = graphPosition;
            this.graphLayoutJson = null;
        }

        public Update(String vertexId, Boolean visible, GraphPosition graphPosition, String graphLayoutJson) {
            this.vertexId = vertexId;
            this.visible = visible;
            this.graphPosition = graphPosition;
            this.graphLayoutJson = graphLayoutJson;
        }

        public String getVertexId() {
            return this.vertexId;
        }

        public Boolean getVisible() {
            return this.visible;
        }

        public GraphPosition getGraphPosition() {
            return this.graphPosition;
        }

        public String getGraphLayoutJson() {
            return this.graphLayoutJson;
        }
    }

    public static enum UpdateUserOnWorkspaceResult {
        ADD,
        UPDATE;

    }
}

