/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.trace;

import java.util.HashMap;
import java.util.Map;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.trace.DefaultTraceRepository;
import org.visallo.core.trace.TraceRepository;
import org.visallo.core.trace.TraceSpan;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class Trace {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(Trace.class);
    private static TraceRepository traceRepository;

    public static void on(String description) {
        Trace.getTraceRepository().on(description, new HashMap<String, String>());
    }

    public static TraceSpan on(String description, Map<String, String> data) {
        return Trace.getTraceRepository().on(description, data);
    }

    public static void off() {
        Trace.getTraceRepository().off();
    }

    public static TraceSpan start(String description) {
        return Trace.getTraceRepository().start(description);
    }

    public static boolean isEnabled() {
        return Trace.getTraceRepository().isEnabled();
    }

    private static TraceRepository getTraceRepository() {
        if (traceRepository == null) {
            try {
                traceRepository = InjectHelper.getInstance(TraceRepository.class);
            }
            catch (VisalloException e) {
                LOGGER.warn("TraceRepository not found through injection. Using no-op DefaultTraceRepository", new Object[0]);
                traceRepository = new DefaultTraceRepository();
            }
        }
        return traceRepository;
    }
}

