/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.Collection;
import java.util.List;
import org.vertexium.Element;
import org.vertexium.Property;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.VisibilityJson;

public class SandboxStatusUtil {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(SandboxStatusUtil.class);

    public static SandboxStatus getSandboxStatus(Element element, String workspaceId) {
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue(element);
        return SandboxStatus.getFromVisibilityJsonString((VisibilityJson)visibilityJson, (String)workspaceId);
    }

    public static SandboxStatus[] getPropertySandboxStatuses(List<Property> properties, String workspaceId) {
        Property property;
        int i;
        SandboxStatus[] sandboxStatuses = new SandboxStatus[properties.size()];
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            Collection<VisibilityJson> visibilityJsons = VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValues(property.getMetadata());
            if (visibilityJsons.size() > 1) {
                LOGGER.error("Multiple %s found on property %s. Choosing the best match.", VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataKey(), property);
            }
            sandboxStatuses[i] = SandboxStatusUtil.getMostExclusiveSandboxStatus(visibilityJsons, workspaceId);
        }
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            if (sandboxStatuses[i] != SandboxStatus.PRIVATE) continue;
            for (int j = 0; j < properties.size(); ++j) {
                Property p = properties.get(j);
                if (i == j || sandboxStatuses[j] != SandboxStatus.PUBLIC || sandboxStatuses[i] != SandboxStatus.PRIVATE || !property.getKey().equals(p.getKey()) || !property.getName().equals(p.getName())) continue;
                sandboxStatuses[i] = SandboxStatus.PUBLIC_CHANGED;
            }
        }
        return sandboxStatuses;
    }

    private static SandboxStatus getMostExclusiveSandboxStatus(Collection<VisibilityJson> visibilityJsons, String workspaceId) {
        for (VisibilityJson visibilityJson : visibilityJsons) {
            SandboxStatus status = SandboxStatus.getFromVisibilityJsonString((VisibilityJson)visibilityJson, (String)workspaceId);
            switch (status) {
                case PUBLIC: {
                    break;
                }
                case PUBLIC_CHANGED: 
                case PRIVATE: {
                    return status;
                }
            }
        }
        return SandboxStatus.PUBLIC;
    }
}

