/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.bootstrap;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.v5analytics.simpleorm.SimpleOrmSession;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.vertexium.Graph;
import org.visallo.core.bootstrap.BootstrapBindingProvider;
import org.visallo.core.bootstrap.GraphShutdownListener;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.bootstrap.SimpleOrmSessionShutdownListener;
import org.visallo.core.config.Configuration;
import org.visallo.core.email.EmailRepository;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.geocoding.GeocoderRepository;
import org.visallo.core.http.HttpRepository;
import org.visallo.core.model.directory.DirectoryRepository;
import org.visallo.core.model.file.FileSystemRepository;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRepository;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.search.SearchRepository;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.user.UserSessionCounterRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.ACLProvider;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.status.JmxMetricsManager;
import org.visallo.core.status.MetricsManager;
import org.visallo.core.status.StatusRepository;
import org.visallo.core.time.TimeRepository;
import org.visallo.core.trace.TraceRepository;
import org.visallo.core.trace.Traced;
import org.visallo.core.trace.TracedMethodInterceptor;
import org.visallo.core.user.User;
import org.visallo.core.util.ServiceLoaderUtil;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class VisalloBootstrap
extends AbstractModule {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VisalloBootstrap.class);
    private static final String GRAPH_METADATA_VISALLO_GRAPH_VERSION_KEY = "visallo.graph.version";
    private static final Integer GRAPH_METADATA_VISALLO_GRAPH_VERSION = 1;
    private static VisalloBootstrap visalloBootstrap;
    private final Configuration configuration;

    public static synchronized VisalloBootstrap bootstrap(Configuration configuration) {
        if (visalloBootstrap == null) {
            LOGGER.debug("Initializing VisalloBootstrap with Configuration:\n%s", configuration);
            visalloBootstrap = new VisalloBootstrap(configuration);
        }
        return visalloBootstrap;
    }

    public static InjectHelper.ModuleMaker bootstrapModuleMaker(final Configuration configuration) {
        return new InjectHelper.ModuleMaker(){

            @Override
            public Module createModule() {
                return VisalloBootstrap.bootstrap(configuration);
            }

            @Override
            public Configuration getConfiguration() {
                return configuration;
            }
        };
    }

    private VisalloBootstrap(Configuration config) {
        this.configuration = config;
    }

    protected void configure() {
        LOGGER.info("Configuring VisalloBootstrap.", new Object[0]);
        Preconditions.checkNotNull((Object)this.configuration, (Object)"configuration cannot be null");
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        LOGGER.debug("binding %s", JmxMetricsManager.class.getName());
        JmxMetricsManager metricsManager = new JmxMetricsManager();
        this.bind(MetricsManager.class).toInstance((Object)metricsManager);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Traced.class), new MethodInterceptor[]{new TracedMethodInterceptor()});
        this.bind(TraceRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.trace")).in(Scopes.SINGLETON);
        this.bind(Graph.class).toProvider(this.getGraphProvider(this.configuration, "graph")).in(Scopes.SINGLETON);
        this.bind(LockRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.lock")).in(Scopes.SINGLETON);
        this.bind(WorkQueueRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.workQueue")).in(Scopes.SINGLETON);
        this.bind(LongRunningProcessRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.longRunningProcess")).in(Scopes.SINGLETON);
        this.bind(DirectoryRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.directory")).in(Scopes.SINGLETON);
        this.bind(VisibilityTranslator.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "security.visibilityTranslator")).in(Scopes.SINGLETON);
        this.bind(UserRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.user")).in(Scopes.SINGLETON);
        this.bind(UserSessionCounterRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.userSessionCounter")).in(Scopes.SINGLETON);
        this.bind(SearchRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.search")).in(Scopes.SINGLETON);
        this.bind(WorkspaceRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.workspace")).in(Scopes.SINGLETON);
        this.bind(GraphAuthorizationRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.graphAuthorization")).in(Scopes.SINGLETON);
        this.bind(OntologyRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.ontology")).in(Scopes.SINGLETON);
        this.bind(SimpleOrmSession.class).toProvider(this.getSimpleOrmSessionProvider(this.configuration, "simpleOrmSession")).in(Scopes.SINGLETON);
        this.bind(HttpRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.http")).in(Scopes.SINGLETON);
        this.bind(GeocoderRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.geocoder")).in(Scopes.SINGLETON);
        this.bind(EmailRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.email")).in(Scopes.SINGLETON);
        this.bind(StatusRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.status")).in(Scopes.SINGLETON);
        this.bind(ACLProvider.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.acl")).in(Scopes.SINGLETON);
        this.bind(FileSystemRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.fileSystem")).in(Scopes.SINGLETON);
        this.bind(AuthorizationRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.authorization")).in(Scopes.SINGLETON);
        this.bind(PrivilegeRepository.class).toProvider(VisalloBootstrap.getConfigurableProvider(this.configuration, "repository.privilege")).in(Scopes.SINGLETON);
        this.bind(TimeRepository.class).toInstance((Object)new TimeRepository());
        this.injectProviders();
    }

    private Provider<? extends SimpleOrmSession> getSimpleOrmSessionProvider(Configuration configuration, String simpleOrmSessionConfigurationName) {
        return () -> {
            Provider provider = VisalloBootstrap.getConfigurableProvider(configuration, simpleOrmSessionConfigurationName);
            SimpleOrmSession simpleOrmSession = (SimpleOrmSession)provider.get();
            this.getShutdownService().register(new SimpleOrmSessionShutdownListener(simpleOrmSession));
            return simpleOrmSession;
        };
    }

    private Provider<? extends Graph> getGraphProvider(Configuration configuration, String configurationPrefix) {
        Method createMethod;
        Class<?> graphClass;
        String graphClassName = configuration.get(configurationPrefix, null);
        if (graphClassName == null) {
            throw new VisalloException("Could not find graph configuration: " + configurationPrefix);
        }
        Map<String, String> configurationSubset = configuration.getSubset(configurationPrefix);
        try {
            LOGGER.debug("Loading graph class \"%s\"", graphClassName);
            graphClass = Class.forName(graphClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find graph class with name: " + graphClassName, e);
        }
        try {
            createMethod = graphClass.getDeclaredMethod("create", Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find create(Map) method on class: " + graphClass.getName(), e);
        }
        return () -> {
            Graph g;
            try {
                LOGGER.debug("creating graph", new Object[0]);
                g = (Graph)createMethod.invoke(null, configurationSubset);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create graph " + graphClass.getName(), e);
            }
            this.checkVisalloGraphVersion(g);
            this.getShutdownService().register(new GraphShutdownListener(g));
            return g;
        };
    }

    private ShutdownService getShutdownService() {
        return InjectHelper.getInstance(ShutdownService.class);
    }

    public void checkVisalloGraphVersion(Graph g) {
        Object visalloGraphVersionObj = g.getMetadata(GRAPH_METADATA_VISALLO_GRAPH_VERSION_KEY);
        if (visalloGraphVersionObj == null) {
            g.setMetadata(GRAPH_METADATA_VISALLO_GRAPH_VERSION_KEY, (Object)GRAPH_METADATA_VISALLO_GRAPH_VERSION);
        } else if (visalloGraphVersionObj instanceof Integer) {
            Integer visalloGraphVersion = (Integer)visalloGraphVersionObj;
            if (!GRAPH_METADATA_VISALLO_GRAPH_VERSION.equals(visalloGraphVersion)) {
                throw new VisalloException("Invalid visallo.graph.version expected " + GRAPH_METADATA_VISALLO_GRAPH_VERSION + " found " + visalloGraphVersion);
            }
        } else {
            throw new VisalloException("Invalid visallo.graph.version expected Integer found " + visalloGraphVersionObj.getClass().getName());
        }
    }

    private void injectProviders() {
        LOGGER.info("Running %s", BootstrapBindingProvider.class.getName());
        Iterable<BootstrapBindingProvider> bindingProviders = ServiceLoaderUtil.loadWithoutInjecting(BootstrapBindingProvider.class, this.configuration);
        for (BootstrapBindingProvider provider : bindingProviders) {
            LOGGER.debug("Configuring bindings from BootstrapBindingProvider: %s", provider.getClass().getName());
            provider.addBindings(this.binder(), this.configuration);
        }
    }

    public static void shutdown() {
        visalloBootstrap = null;
    }

    public static <T> Provider<? extends T> getConfigurableProvider(Configuration config, String key) {
        Class configuredClass = config.getClass(key);
        return configuredClass != null ? new ConfigurableProvider(configuredClass, config, key, null) : new NullProvider();
    }

    private static class ConfigurableProvider<T>
    implements Provider<T> {
        private final Class<? extends T> clazz;
        private final Method initMethod;
        private final Object[] initMethodArgs;
        private final Configuration config;
        private final String keyPrefix;

        public ConfigurableProvider(Class<? extends T> clazz, Configuration config, String keyPrefix, User user) {
            this.config = config;
            this.keyPrefix = keyPrefix;
            Object[] initArgs = null;
            Method init = this.findInit(clazz, Configuration.class, User.class);
            if (init != null) {
                initArgs = new Object[]{config, user};
            } else {
                init = this.findInit(clazz, Map.class, User.class);
                if (init != null) {
                    initArgs = new Object[]{config.toMap(), user};
                } else {
                    init = this.findInit(clazz, Configuration.class);
                    if (init != null) {
                        initArgs = new Object[]{config};
                    } else {
                        init = this.findInit(clazz, Map.class);
                        if (init != null) {
                            initArgs = new Object[]{config.toMap()};
                        }
                    }
                }
            }
            this.clazz = clazz;
            this.initMethod = init;
            this.initMethodArgs = initArgs;
        }

        private Method findInit(Class<? extends T> target, Class<?> ... paramTypes) {
            try {
                return target.getMethod("init", paramTypes);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
            catch (SecurityException ex) {
                ArrayList<String> paramNames = new ArrayList<String>();
                for (Class<?> pc : paramTypes) {
                    paramNames.add(pc.getSimpleName());
                }
                throw new VisalloException(String.format("Error accessing init(%s) method in %s.", paramNames, this.clazz.getName()), ex);
            }
        }

        public T get() {
            Exception error;
            try {
                T impl;
                LOGGER.debug("creating %s", this.clazz.getName());
                if (InjectHelper.getInjector() != null) {
                    impl = InjectHelper.getInstance(this.clazz);
                } else {
                    Constructor<T> constructor = this.clazz.getConstructor(new Class[0]);
                    impl = constructor.newInstance(new Object[0]);
                }
                if (this.initMethod != null) {
                    this.initMethod.invoke(impl, this.initMethodArgs);
                }
                this.config.setConfigurables(impl, this.keyPrefix);
                return impl;
            }
            catch (IllegalAccessException iae) {
                LOGGER.error("Unable to access default constructor for %s", this.clazz.getName(), iae);
                error = iae;
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Unable to initialize instance of %s.", this.clazz.getName(), iae);
                error = iae;
            }
            catch (InvocationTargetException ite) {
                LOGGER.error("Error initializing instance of %s.", this.clazz.getName(), ite);
                error = ite;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Could not find constructor for %s.", this.clazz.getName(), e);
                error = e;
            }
            catch (InstantiationException e) {
                LOGGER.error("Could not create %s.", this.clazz.getName(), e);
                error = e;
            }
            throw new VisalloException(String.format("Unable to initialize instance of %s", this.clazz.getName()), error);
        }
    }

    private static class NullProvider<T>
    implements Provider<T> {
        private NullProvider() {
        }

        public T get() {
            return null;
        }
    }
}

