/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.visallo.core.config.VisalloResourceBundle;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class VisalloResourceBundleManager {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VisalloResourceBundleManager.class);
    public static final String RESOURCE_BUNDLE_BASE_NAME = "MessageBundle";
    private Properties unlocalizedProperties = new Properties();
    private Map<Locale, Properties> localizedProperties = new HashMap<Locale, Properties>();

    public void register(InputStream inputStream) throws IOException {
        this.unlocalizedProperties.load(new InputStreamReader(inputStream, "UTF-8"));
    }

    public void register(InputStream inputStream, Locale locale) throws IOException {
        Properties properties = this.localizedProperties.get(locale);
        if (properties == null) {
            properties = new Properties();
            this.localizedProperties.put(locale, properties);
        }
        properties.load(new InputStreamReader(inputStream, "UTF-8"));
    }

    public ResourceBundle getBundle() {
        Locale defaultLocale = Locale.getDefault();
        LOGGER.debug("returning a bundle configured for the default locale: %s ", defaultLocale);
        return this.createBundle(defaultLocale);
    }

    public ResourceBundle getBundle(Locale locale) {
        LOGGER.debug("returning a bundle configured for locale: %s ", locale);
        return this.createBundle(locale);
    }

    private ResourceBundle createBundle(Locale locale) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.unlocalizedProperties);
        properties.putAll((Map<?, ?>)this.getLocaleProperties(locale));
        return new VisalloResourceBundle(properties, this.getRootBundle(locale));
    }

    private Properties getLocaleProperties(Locale locale) {
        Properties languageCountryVariantProperties;
        Properties languageCountryProperties;
        Properties properties = new Properties();
        Properties languageProperties = this.localizedProperties.get(new Locale(locale.getLanguage()));
        if (languageProperties != null) {
            properties.putAll((Map<?, ?>)languageProperties);
        }
        if ((languageCountryProperties = this.localizedProperties.get(new Locale(locale.getLanguage(), locale.getCountry()))) != null) {
            properties.putAll((Map<?, ?>)languageCountryProperties);
        }
        if ((languageCountryVariantProperties = this.localizedProperties.get(new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant()))) != null) {
            properties.putAll((Map<?, ?>)languageCountryVariantProperties);
        }
        return properties;
    }

    private ResourceBundle getRootBundle(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, locale, new UTF8PropertiesControl());
    }

    private class UTF8PropertiesControl
    extends ResourceBundle.Control {
        private UTF8PropertiesControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (format.equals("java.properties")) {
                String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
                InputStream inputStream = null;
                if (reload) {
                    URLConnection urlConnection;
                    URL url = loader.getResource(resourceName);
                    if (url != null && (urlConnection = url.openConnection()) != null) {
                        urlConnection.setUseCaches(false);
                        inputStream = urlConnection.getInputStream();
                    }
                } else {
                    inputStream = loader.getResourceAsStream(resourceName);
                }
                if (inputStream != null) {
                    try {
                        PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, "UTF-8"));
                        return propertyResourceBundle;
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    }
}

