/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.artifactThumbnails;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.v5analytics.simpleorm.SimpleOrmSession;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.artifactThumbnails.ArtifactThumbnail;
import org.visallo.core.model.artifactThumbnails.ImageUtils;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.types.BooleanVisalloProperty;
import org.visallo.core.model.properties.types.IntegerVisalloProperty;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class ArtifactThumbnailRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ArtifactThumbnailRepository.class);
    private static final String VISIBILITY_STRING = "";
    public static int FRAMES_PER_PREVIEW = 20;
    public static int PREVIEW_FRAME_WIDTH = 360;
    public static int PREVIEW_FRAME_HEIGHT = 240;
    private final SimpleOrmSession simpleOrmSession;
    private final UserRepository userRepository;
    private BooleanVisalloProperty yAxisFlippedProperty;
    private IntegerVisalloProperty clockwiseRotationProperty;

    @Inject
    public ArtifactThumbnailRepository(SimpleOrmSession simpleOrmSession, UserRepository userRepository, OntologyRepository ontologyRepository) {
        String clockwiseRotationPropertyIri;
        this.simpleOrmSession = simpleOrmSession;
        this.userRepository = userRepository;
        String yAxisFlippedPropertyIri = ontologyRepository.getPropertyIRIByIntent("media.yAxisFlipped");
        if (yAxisFlippedPropertyIri != null) {
            this.yAxisFlippedProperty = new BooleanVisalloProperty(yAxisFlippedPropertyIri);
        }
        if ((clockwiseRotationPropertyIri = ontologyRepository.getPropertyIRIByIntent("media.clockwiseRotation")) != null) {
            this.clockwiseRotationProperty = new IntegerVisalloProperty(clockwiseRotationPropertyIri);
        }
    }

    public ArtifactThumbnail getThumbnail(String artifactVertexId, String thumbnailType, int width, int height, User user) {
        String id = ArtifactThumbnail.createId(artifactVertexId, thumbnailType, width, height);
        return (ArtifactThumbnail)this.simpleOrmSession.findById(ArtifactThumbnail.class, id, this.userRepository.getSimpleOrmContext(user));
    }

    public byte[] getThumbnailData(String artifactVertexId, String thumbnailType, int width, int height, User user) {
        ArtifactThumbnail artifactThumbnail = this.getThumbnail(artifactVertexId, thumbnailType, width, height, user);
        if (artifactThumbnail == null) {
            return null;
        }
        return artifactThumbnail.getData();
    }

    public ArtifactThumbnail createThumbnail(Vertex artifactVertex, String propertyKey, String thumbnailType, InputStream in, int[] boundaryDims, User user) throws IOException {
        ArtifactThumbnail thumbnail = this.generateThumbnail(artifactVertex, propertyKey, thumbnailType, in, boundaryDims);
        this.simpleOrmSession.save((Object)thumbnail, VISIBILITY_STRING, this.userRepository.getSimpleOrmContext(user));
        return thumbnail;
    }

    public ArtifactThumbnail generateThumbnail(Vertex artifactVertex, String propertyKey, String thumbnailType, InputStream in, int[] boundaryDims) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BufferedImage originalImage = ImageIO.read(in);
            Preconditions.checkNotNull((Object)originalImage, (Object)("Could not generateThumbnail: read original image for artifact " + artifactVertex.getId()));
            int type = ImageUtils.thumbnailType(originalImage);
            String format = ImageUtils.thumbnailFormat(originalImage);
            BufferedImage transformedImage = this.getTransformedImage(originalImage, artifactVertex, propertyKey);
            int[] transformedImageDims = new int[]{transformedImage.getWidth(), transformedImage.getHeight()};
            int[] newImageDims = this.getScaledDimension(transformedImageDims, boundaryDims);
            if (newImageDims[0] >= transformedImageDims[0] || newImageDims[1] >= transformedImageDims[1]) {
                LOGGER.info("Original image dimensions %d x %d are smaller than requested dimensions %d x %d returning original.", transformedImageDims[0], transformedImageDims[1], newImageDims[0], newImageDims[1]);
            }
            BufferedImage resizedImage = new BufferedImage(newImageDims[0], newImageDims[1], type);
            Graphics2D g = resizedImage.createGraphics();
            int width = resizedImage.getWidth();
            int height = resizedImage.getHeight();
            if (transformedImage.getColorModel().getNumComponents() > 3) {
                g.drawImage(transformedImage, 0, 0, width, height, null);
            } else {
                g.drawImage(transformedImage, 0, 0, width, height, Color.BLACK, null);
            }
            g.dispose();
            ImageIO.write((RenderedImage)resizedImage, format, out);
            return new ArtifactThumbnail(artifactVertex.getId(), thumbnailType, out.toByteArray(), format, width, height);
        }
        catch (IOException e) {
            throw new VisalloResourceNotFoundException("Error reading InputStream");
        }
    }

    public BufferedImage getTransformedImage(BufferedImage originalImage, Vertex artifactVertex, String propertyKey) {
        Boolean nullable;
        Integer nullable2;
        int cwRotationNeeded = 0;
        if (this.clockwiseRotationProperty != null && (nullable2 = (Integer)this.clockwiseRotationProperty.getPropertyValue((Element)artifactVertex, propertyKey)) != null) {
            cwRotationNeeded = nullable2;
        }
        boolean yAxisFlipNeeded = false;
        if (this.yAxisFlippedProperty != null && (nullable = (Boolean)this.yAxisFlippedProperty.getPropertyValue((Element)artifactVertex, propertyKey)) != null) {
            yAxisFlipNeeded = nullable;
        }
        return ImageUtils.reOrientImage(originalImage, yAxisFlipNeeded, cwRotationNeeded);
    }

    public int[] getScaledDimension(int[] imgSize, int[] boundary) {
        int originalWidth = imgSize[0];
        int originalHeight = imgSize[1];
        int boundWidth = boundary[0];
        int boundHeight = boundary[1];
        int newWidth = originalWidth;
        int newHeight = originalHeight;
        if (originalWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originalHeight / originalWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originalWidth / originalHeight;
        }
        return new int[]{newWidth, newHeight};
    }
}

