/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.search;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.query.CompositeGraphQuery;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.Query;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.directory.DirectoryRepository;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.search.ElementSearchRunnerBase;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class ElementSearchRunnerWithRelatedBase
extends ElementSearchRunnerBase {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ElementSearchRunnerWithRelatedBase.class);

    protected ElementSearchRunnerWithRelatedBase(OntologyRepository ontologyRepository, Graph graph, Configuration configuration, DirectoryRepository directoryRepository) {
        super(ontologyRepository, graph, configuration, directoryRepository);
    }

    @Override
    protected ElementSearchRunnerBase.QueryAndData getQuery(SearchOptions searchOptions, Authorizations authorizations) {
        ImmutableList relatedToVertexIds;
        String queryString;
        Object[] relatedToVertexIdsParam = (String[])searchOptions.getOptionalParameter("relatedToVertexIds[]", String[].class);
        JSONArray filterJson = this.getFilterJson(searchOptions);
        if (relatedToVertexIdsParam == null) {
            queryString = searchOptions.getRequiredParameter("q", String.class);
            relatedToVertexIds = ImmutableList.of();
        } else {
            queryString = (String)((Object)searchOptions.getOptionalParameter("q", String.class));
            relatedToVertexIds = ImmutableList.copyOf((Object[])relatedToVertexIdsParam);
        }
        LOGGER.debug("search %s (relatedToVertexIds: %s)\n%s", queryString, Joiner.on((String)",").join((Iterable)relatedToVertexIds), filterJson.toString(2));
        Object graphQuery = relatedToVertexIds.isEmpty() ? this.query(queryString, null, authorizations) : (relatedToVertexIds.size() == 1 ? this.query(queryString, (String)relatedToVertexIds.get(0), authorizations) : new CompositeGraphQuery((Collection)Lists.transform((List)relatedToVertexIds, relatedToVertexId -> this.query(queryString, (String)relatedToVertexId, authorizations))));
        return new ElementSearchRunnerBase.QueryAndData((Query)graphQuery);
    }

    private Query query(String query, String relatedToVertexId, Authorizations authorizations) {
        GraphQuery graphQuery;
        if (relatedToVertexId == null) {
            graphQuery = this.getGraph().query(query, authorizations);
        } else if (StringUtils.isBlank((String)query)) {
            Vertex relatedToVertex = this.getGraph().getVertex(relatedToVertexId, authorizations);
            Preconditions.checkNotNull((Object)relatedToVertex, (Object)("Could not find vertex: " + relatedToVertexId));
            graphQuery = relatedToVertex.query(authorizations);
        } else {
            Vertex relatedToVertex = this.getGraph().getVertex(relatedToVertexId, authorizations);
            Preconditions.checkNotNull((Object)relatedToVertex, (Object)("Could not find vertex: " + relatedToVertexId));
            graphQuery = relatedToVertex.query(query, authorizations);
        }
        return graphQuery;
    }
}

