/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import com.v5analytics.simpleorm.SimpleOrmContext;
import com.v5analytics.simpleorm.SimpleOrmSession;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.util.IterableUtils;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRepository;
import org.visallo.core.model.user.AuthorizationContext;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.UserListener;
import org.visallo.core.model.user.UserPasswordUtil;
import org.visallo.core.model.user.UserSessionCounterRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.user.SystemUser;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.JSONUtil;
import org.visallo.web.clientapi.model.ClientApiUser;
import org.visallo.web.clientapi.model.ClientApiUsers;
import org.visallo.web.clientapi.model.Privilege;
import org.visallo.web.clientapi.model.UserStatus;

public abstract class UserRepository {
    public static final String GRAPH_USER_ID_PREFIX = "USER_";
    public static final String VISIBILITY_STRING = "user";
    public static final VisalloVisibility VISIBILITY = new VisalloVisibility("user");
    public static final String OWL_IRI = "http://visallo.org/user";
    public static final String USER_CONCEPT_IRI = "http://visallo.org/user#user";
    private final SimpleOrmSession simpleOrmSession;
    private final UserSessionCounterRepository userSessionCounterRepository;
    private final WorkQueueRepository workQueueRepository;
    private final LockRepository lockRepository;
    private final Configuration configuration;
    private final AuthorizationRepository authorizationRepository;
    private final PrivilegeRepository privilegeRepository;
    private LongRunningProcessRepository longRunningProcessRepository;
    private Collection<UserListener> userListeners;

    protected UserRepository(Configuration configuration, SimpleOrmSession simpleOrmSession, UserSessionCounterRepository userSessionCounterRepository, WorkQueueRepository workQueueRepository, LockRepository lockRepository, AuthorizationRepository authorizationRepository, PrivilegeRepository privilegeRepository) {
        this.configuration = configuration;
        this.simpleOrmSession = simpleOrmSession;
        this.userSessionCounterRepository = userSessionCounterRepository;
        this.workQueueRepository = workQueueRepository;
        this.lockRepository = lockRepository;
        this.authorizationRepository = authorizationRepository;
        this.privilegeRepository = privilegeRepository;
    }

    public abstract User findByUsername(String var1);

    public abstract Iterable<User> find(int var1, int var2);

    public Iterable<User> findByStatus(int skip, int limit, UserStatus status) {
        List allUsers = IterableUtils.toList(this.find(skip, limit));
        ArrayList<User> matchingUsers = new ArrayList<User>();
        for (User user : allUsers) {
            if (user.getUserStatus() != status) continue;
            matchingUsers.add(user);
        }
        return matchingUsers;
    }

    public abstract User findById(String var1);

    protected abstract User addUser(String var1, String var2, String var3, String var4);

    public void setPassword(User user, String password) {
        byte[] salt = UserPasswordUtil.getSalt();
        byte[] passwordHash = UserPasswordUtil.hashPassword(password, salt);
        this.setPassword(user, salt, passwordHash);
    }

    public abstract void setPassword(User var1, byte[] var2, byte[] var3);

    public abstract boolean isPasswordValid(User var1, String var2);

    public abstract void updateUser(User var1, AuthorizationContext var2);

    public abstract User setCurrentWorkspace(String var1, String var2);

    public abstract String getCurrentWorkspaceId(String var1);

    public abstract User setStatus(String var1, UserStatus var2);

    public abstract void setDisplayName(User var1, String var2);

    public abstract void setEmailAddress(User var1, String var2);

    public abstract void setUiPreferences(User var1, JSONObject var2);

    public JSONObject toJsonWithAuths(User user) {
        JSONObject json = UserRepository.toJson(user);
        JSONArray authorizations = new JSONArray();
        for (String a : this.authorizationRepository.getAuthorizations(user)) {
            authorizations.put((Object)a);
        }
        json.put("authorizations", (Object)authorizations);
        json.put("uiPreferences", (Object)user.getUiPreferences());
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        json.put("privileges", (Object)Privilege.toJson(privileges));
        return json;
    }

    public ClientApiUser toClientApiPrivate(User user) {
        ClientApiUser u = this.toClientApi(user);
        for (String a : this.authorizationRepository.getAuthorizations(user)) {
            u.addAuthorization(a);
        }
        for (JSONObject json : this.getLongRunningProcesses(user)) {
            u.getLongRunningProcesses().add(ClientApiConverter.toClientApiValue((JSONObject)json));
        }
        u.setUiPreferences(JSONUtil.toJsonNode(user.getUiPreferences()));
        u.getProperties().putAll(user.getCustomProperties());
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        u.getPrivileges().addAll(privileges);
        return u;
    }

    private List<JSONObject> getLongRunningProcesses(User user) {
        return this.getLongRunningProcessRepository().getLongRunningProcesses(user);
    }

    private LongRunningProcessRepository getLongRunningProcessRepository() {
        if (this.longRunningProcessRepository == null) {
            this.longRunningProcessRepository = InjectHelper.getInstance(LongRunningProcessRepository.class);
        }
        return this.longRunningProcessRepository;
    }

    public ClientApiUser toClientApi(User user) {
        return this.toClientApi(user, null);
    }

    private ClientApiUser toClientApi(User user, Map<String, String> workspaceNames) {
        ClientApiUser u = new ClientApiUser();
        u.setId(user.getUserId());
        u.setUserName(user.getUsername());
        u.setDisplayName(user.getDisplayName());
        u.setStatus(user.getUserStatus());
        u.setUserType(user.getUserType());
        u.setEmail(user.getEmailAddress());
        u.setCurrentWorkspaceId(user.getCurrentWorkspaceId());
        u.getProperties().putAll(user.getCustomProperties());
        if (workspaceNames != null) {
            String workspaceName = workspaceNames.get(user.getCurrentWorkspaceId());
            u.setCurrentWorkspaceName(workspaceName);
        }
        return u;
    }

    protected String formatUsername(String username) {
        return username.trim().toLowerCase();
    }

    public ClientApiUsers toClientApi(Iterable<User> users, Map<String, String> workspaceNames) {
        ClientApiUsers clientApiUsers = new ClientApiUsers();
        for (User user : users) {
            clientApiUsers.getUsers().add(this.toClientApi(user, workspaceNames));
        }
        return clientApiUsers;
    }

    public static JSONObject toJson(User user) {
        return UserRepository.toJson(user, null);
    }

    public static JSONObject toJson(User user, Map<String, String> workspaceNames) {
        try {
            JSONObject json = new JSONObject();
            json.put("id", (Object)user.getUserId());
            json.put("userName", (Object)user.getUsername());
            json.put("displayName", (Object)user.getDisplayName());
            json.put("status", (Object)user.getUserStatus());
            json.put("userType", (Object)user.getUserType());
            json.put("email", (Object)user.getEmailAddress());
            json.put("currentWorkspaceId", (Object)user.getCurrentWorkspaceId());
            if (workspaceNames != null) {
                String workspaceName = workspaceNames.get(user.getCurrentWorkspaceId());
                json.put("currentWorkspaceName", (Object)workspaceName);
            }
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleOrmContext getSimpleOrmContext(User user) {
        Set<String> authorizationsSet = this.authorizationRepository.getAuthorizations(user);
        String[] authorizations = authorizationsSet.toArray(new String[authorizationsSet.size()]);
        return this.getSimpleOrmContext(authorizations);
    }

    public SimpleOrmContext getSimpleOrmContext(String ... authorizations) {
        return this.simpleOrmSession.createContext(authorizations);
    }

    public User getSystemUser() {
        return new SystemUser();
    }

    public User findOrAddUser(String username, String displayName, String emailAddress, String password) {
        return this.lockRepository.lock("findOrAddUser", () -> {
            User user = this.findByUsername(username);
            if (user == null) {
                user = this.addUser(username, displayName, emailAddress, password);
            }
            return user;
        });
    }

    public final void delete(User user) {
        this.internalDelete(user);
        this.userSessionCounterRepository.deleteSessions(user.getUserId());
        this.workQueueRepository.pushUserStatusChange(user, UserStatus.OFFLINE);
        this.fireUserDeletedEvent(user);
    }

    protected abstract void internalDelete(User var1);

    public Iterable<User> find(String query) {
        List users;
        String lowerCaseQuery = query == null ? null : query.toLowerCase();
        int skip = 0;
        int limit = 100;
        ArrayList<User> foundUsers = new ArrayList<User>();
        while ((users = IterableUtils.toList(this.find(skip, limit))).size() != 0) {
            for (User user : users) {
                if (lowerCaseQuery != null && !user.getDisplayName().toLowerCase().contains(lowerCaseQuery)) continue;
                foundUsers.add(user);
            }
            skip += limit;
        }
        return foundUsers;
    }

    public static String createRandomPassword() {
        return new BigInteger(120, new SecureRandom()).toString(32);
    }

    public abstract User findByPasswordResetToken(String var1);

    public abstract void setPasswordResetTokenAndExpirationDate(User var1, String var2, Date var3);

    public abstract void clearPasswordResetTokenAndExpirationDate(User var1);

    protected void afterNewUserAdded(User newUser) {
        this.fireNewUserAddedEvent(newUser);
    }

    private void fireNewUserAddedEvent(User user) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.newUserAdded(user);
        }
    }

    private void fireUserDeletedEvent(User user) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userDeleted(user);
        }
    }

    protected void fireUserLoginEvent(User user, AuthorizationContext authorizationContext) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userLogin(user, authorizationContext);
        }
    }

    protected void fireUserStatusChangeEvent(User user, UserStatus status) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userStatusChange(user, status);
        }
    }

    private Collection<UserListener> getUserListeners() {
        if (this.userListeners == null) {
            this.userListeners = InjectHelper.getInjectedServices(UserListener.class, this.configuration);
        }
        return this.userListeners;
    }

    public abstract void setPropertyOnUser(User var1, String var2, Object var3);

    protected AuthorizationRepository getAuthorizationRepository() {
        return this.authorizationRepository;
    }

    protected PrivilegeRepository getPrivilegeRepository() {
        return this.privilegeRepository;
    }
}

