/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.ArrayList;
import org.json.JSONObject;
import org.vertexium.type.GeoPoint;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class FFprobeGeoLocationUtil {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(FFprobeGeoLocationUtil.class);

    public static GeoPoint getGeoPoint(JSONObject json) {
        GeoPoint geoPoint;
        String locationString;
        JSONObject tagsObject;
        if (json == null) {
            return null;
        }
        JSONObject formatObject = json.optJSONObject("format");
        if (formatObject != null && (tagsObject = formatObject.optJSONObject("tags")) != null && !(locationString = tagsObject.optString("location")).equals("") && (geoPoint = FFprobeGeoLocationUtil.parseGeoLocationString(locationString)) != null) {
            return geoPoint;
        }
        LOGGER.debug("Could not retrieve a \"geoLocation\" value from the JSON object.", new Object[0]);
        return null;
    }

    private static GeoPoint parseGeoLocationString(String locationString) {
        String myRegularExpression = "(\\+|\\-|/)";
        String[] tempValues = locationString.split(myRegularExpression);
        String[] values = FFprobeGeoLocationUtil.removeNullsFromStringArray(tempValues);
        if (values.length < 2) {
            return null;
        }
        String latitudeValue = values[0];
        String latitudeSign = "";
        int indexOfLatitude = locationString.indexOf(latitudeValue);
        if (indexOfLatitude != 0) {
            latitudeSign = locationString.substring(0, 1);
        }
        String latitudeString = latitudeSign + latitudeValue;
        Double latitude = Double.parseDouble(latitudeString);
        String longitudeValue = values[1];
        String longitudeSign = "";
        int indexOfLongitude = locationString.indexOf(longitudeValue, indexOfLatitude + latitudeValue.length());
        String longitudePreviousChar = locationString.substring(indexOfLongitude - 1, indexOfLongitude);
        if (longitudePreviousChar.equals("-") || longitudePreviousChar.equals("+")) {
            longitudeSign = longitudePreviousChar;
        }
        String longitudeString = longitudeSign + longitudeValue;
        Double longitude = Double.parseDouble(longitudeString);
        String altitudeValue = null;
        Double altitude = null;
        if (values.length == 3) {
            altitudeValue = values[2];
            String altitudeSign = "";
            int indexOfAltitude = locationString.indexOf(altitudeValue, indexOfLongitude + longitudeValue.length());
            String altitudePreviousChar = locationString.substring(indexOfAltitude - 1, indexOfAltitude);
            if (altitudePreviousChar.equals("-") || altitudePreviousChar.equals("+")) {
                altitudeSign = altitudePreviousChar;
            }
            String altitudeString = altitudeSign + altitudeValue;
            altitude = Double.parseDouble(altitudeString);
        }
        if (latitude != null && longitude != null && altitude != null) {
            return new GeoPoint(latitude.doubleValue(), longitude.doubleValue(), altitude);
        }
        if (latitude != null && longitude != null && altitude == null) {
            return new GeoPoint(latitude.doubleValue(), longitude.doubleValue());
        }
        return null;
    }

    public static String[] removeNullsFromStringArray(String[] array) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || array[i].equals("")) continue;
            arrayList.add(array[i]);
        }
        String[] newArray = arrayList.toArray(new String[arrayList.size()]);
        return newArray;
    }
}

