/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.bootstrap.VisalloBootstrap;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

@Singleton
public class ShutdownService {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ShutdownService.class);
    private LinkedHashSet<ShutdownListener> shutdownListeners = new LinkedHashSet();

    public void shutdown() {
        List shutdownListenersList = Lists.reverse(new ArrayList<ShutdownListener>(this.shutdownListeners));
        for (ShutdownListener shutdownListener : shutdownListenersList) {
            try {
                LOGGER.info("Shutdown: " + shutdownListener.getClass().getName(), new Object[0]);
                shutdownListener.shutdown();
            }
            catch (Exception e) {
                LOGGER.error("Unable to shutdown: " + shutdownListener.getClass().getName(), e);
            }
        }
        LOGGER.info("Shutdown: InjectHelper", new Object[0]);
        InjectHelper.shutdown();
        LOGGER.info("Shutdown: VisalloBootstrap", new Object[0]);
        VisalloBootstrap.shutdown();
    }

    public void register(ShutdownListener shutdownListener) {
        this.shutdownListeners.add(shutdownListener);
    }
}

