/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.video;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoTranscript
implements Serializable {
    private SortedSet<TimedText> entries = new TreeSet<TimedText>();

    public VideoTranscript() {
    }

    public VideoTranscript(JSONObject json) {
        try {
            JSONArray entriesJson = (JSONArray)json.get("entries");
            for (int i = 0; i < entriesJson.length(); ++i) {
                JSONObject entryJson = (JSONObject)entriesJson.get(i);
                this.entries.add(new TimedText(entryJson));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not parse video transcript JSON", e);
        }
    }

    public List<TimedText> getEntries() {
        return new ArrayList<TimedText>(this.entries);
    }

    public void add(Time time, String text) {
        this.entries.add(new TimedText(time, text));
    }

    public VideoTranscript merge(VideoTranscript videoTranscript) {
        for (TimedText entry : videoTranscript.entries) {
            this.entries.add(entry);
        }
        return this;
    }

    public static VideoTranscript merge(VideoTranscript a, VideoTranscript b) {
        VideoTranscript result = new VideoTranscript();
        if (a != null) {
            result.merge(a);
        }
        if (b != null) {
            result.merge(b);
        }
        return result;
    }

    public JSONObject toJson() {
        try {
            JSONObject result = new JSONObject();
            JSONArray entriesJson = new JSONArray();
            for (TimedText entry : this.entries) {
                entriesJson.put((Object)entry.toJson());
            }
            result.put("entries", (Object)entriesJson);
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not create JSON", e);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TimedText entry : this.entries) {
            result.append(entry.getTime().toString());
            result.append("\n");
            result.append(entry.getText());
            result.append("\n");
        }
        return result.toString();
    }

    public long getDuration() {
        if (this.getEntries().size() > 0) {
            long start = this.getEntries().get(0).getTime().getStart();
            long end = this.getEntries().get(this.getEntries().size() - 1).getTime().getEnd();
            return end - start;
        }
        return 0L;
    }

    public Integer findEntryIndexFromStartTime(long frameStartTime) {
        int entryIndex = 0;
        for (TimedText entry : this.getEntries()) {
            if (entry.getTime().getStart() == frameStartTime) {
                return entryIndex;
            }
            ++entryIndex;
        }
        return null;
    }

    public static class Time
    implements Serializable {
        private Long start;
        private Long end;

        public Time(Long start, Long end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.toString(this.start) + "-" + this.toString(this.end);
        }

        private String toString(Long t) {
            if (t == null) {
                return "";
            }
            return String.format("%02d:%02d:%02d.%03d", t / 60L / 60L / 1000L, t / 60L / 1000L % 60L, t / 1000L % 60L, t % 1000L);
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }
    }

    public static class TimedText
    implements Comparable<TimedText>,
    Serializable {
        private Time time;
        private String text;

        public TimedText(Time time, String text) {
            this.time = time;
            this.text = text;
        }

        public TimedText(JSONObject json) {
            try {
                Long start = null;
                Long end = null;
                if (json.has("start")) {
                    start = json.getLong("start");
                }
                if (json.has("end")) {
                    end = json.getLong("end");
                }
                this.time = new Time(start, end);
                this.text = json.getString("text");
            }
            catch (JSONException e) {
                throw new RuntimeException("Could not parse TimedText JSON", e);
            }
        }

        public Time getTime() {
            return this.time;
        }

        public String getText() {
            return this.text;
        }

        public JSONObject toJson() {
            try {
                JSONObject result = new JSONObject();
                if (this.getTime().getStart() != null) {
                    result.put("start", this.getTime().getStart().longValue());
                }
                if (this.getTime().getEnd() != null) {
                    result.put("end", this.getTime().getEnd().longValue());
                }
                result.put("text", (Object)this.getText());
                return result;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int compareTo(TimedText other) {
            Time time = this.getTime();
            Time timeOther = other.getTime();
            int result = time.getStart().compareTo(timeOther.getStart());
            if (result != 0) {
                return result;
            }
            if (time.getEnd() == null && timeOther.getEnd() == null) {
                return 0;
            }
            if (time.getEnd() == null) {
                return -1;
            }
            if (timeOther.getEnd() == null) {
                return 1;
            }
            return time.getEnd().compareTo(timeOther.getEnd());
        }
    }
}

