/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import org.json.JSONArray;
import org.json.JSONObject;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class FFprobeDimensionsUtil {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(FFprobeDimensionsUtil.class);

    public static Integer getWidth(JSONObject json) {
        Integer width = FFprobeDimensionsUtil.getDimension(json, "width");
        if (width == null) {
            LOGGER.debug("Could not retrieve a \"width\" value from the JSON object.", new Object[0]);
        }
        return width;
    }

    public static Integer getHeight(JSONObject json) {
        Integer height = FFprobeDimensionsUtil.getDimension(json, "height");
        if (height == null) {
            LOGGER.debug("Could not retrieve a \"height\" value from the JSON object.", new Object[0]);
        }
        return height;
    }

    private static Integer getDimension(JSONObject json, String dimension) {
        if (json == null) {
            return null;
        }
        JSONArray streamsJson = json.optJSONArray("streams");
        if (streamsJson != null) {
            for (int i = 0; i < streamsJson.length(); ++i) {
                Double optionalDimension;
                JSONObject streamsIndexJson = streamsJson.optJSONObject(i);
                if (streamsIndexJson == null || Double.isNaN(optionalDimension = Double.valueOf(streamsIndexJson.optDouble(dimension)))) continue;
                return optionalDimension.intValue();
            }
        }
        return null;
    }
}

