/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.io.UnsupportedEncodingException;
import org.visallo.core.exception.VisalloException;

public class LenientURLDecoder {
    public static String decode(String s, String enc) {
        try {
            boolean needToChange = false;
            StringBuilder sb = new StringBuilder();
            int numChars = s.length();
            int i = 0;
            if (enc.length() == 0) {
                throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
            }
            block8: while (i < numChars) {
                char c = s.charAt(i);
                switch (c) {
                    case '+': {
                        sb.append(' ');
                        ++i;
                        needToChange = true;
                        continue block8;
                    }
                    case '%': {
                        byte[] bytes = new byte[(numChars - i) / 3];
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            String hex = s.substring(i + 1, i + 3);
                            try {
                                bytes[pos] = (byte)Integer.parseInt(hex, 16);
                                ++pos;
                            }
                            catch (NumberFormatException e) {
                                sb.append(new String(bytes, 0, pos, enc));
                                sb.append("%");
                                sb.append(hex);
                                pos = 0;
                            }
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                        if (i < numChars && c == '%') {
                            while (i < numChars) {
                                sb.append(s.charAt(i));
                                ++i;
                            }
                        }
                        needToChange = true;
                        continue block8;
                    }
                }
                sb.append(c);
                ++i;
            }
            return needToChange ? sb.toString() : s;
        }
        catch (Exception ex) {
            throw new VisalloException("Could not url decode string \"" + s + "\"", ex);
        }
    }
}

