/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.util.IterableUtils;
import org.visallo.core.config.Configuration;
import org.visallo.core.ingest.FileImportSupportingFileHandler;
import org.visallo.core.ingest.MetadataFileImportSupportingFileHandler;
import org.visallo.core.ingest.PostFileImportHandler;
import org.visallo.core.model.WorkQueueNames;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.properties.types.PropertyMetadata;
import org.visallo.core.model.properties.types.VisalloProperty;
import org.visallo.core.model.properties.types.VisalloPropertyUpdate;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.RowKeyHelper;
import org.visallo.core.util.ServiceLoaderUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiImportProperty;
import org.visallo.web.clientapi.model.VisibilityJson;

public class FileImport {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(FileImport.class);
    public static final String MULTI_VALUE_KEY = FileImport.class.getName();
    private final VisibilityTranslator visibilityTranslator;
    private final Graph graph;
    private final WorkQueueRepository workQueueRepository;
    private final WorkspaceRepository workspaceRepository;
    private final WorkQueueNames workQueueNames;
    private final OntologyRepository ontologyRepository;
    private final Configuration configuration;
    private List<FileImportSupportingFileHandler> fileImportSupportingFileHandlers;
    private List<PostFileImportHandler> postFileImportHandlers;

    @Inject
    public FileImport(VisibilityTranslator visibilityTranslator, Graph graph, WorkQueueRepository workQueueRepository, WorkspaceRepository workspaceRepository, WorkQueueNames workQueueNames, OntologyRepository ontologyRepository, Configuration configuration) {
        this.visibilityTranslator = visibilityTranslator;
        this.graph = graph;
        this.workQueueRepository = workQueueRepository;
        this.workspaceRepository = workspaceRepository;
        this.workQueueNames = workQueueNames;
        this.ontologyRepository = ontologyRepository;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDirectory(File dataDir, boolean queueDuplicates, String conceptTypeIRI, String visibilitySource, Workspace workspace, Priority priority, User user, Authorizations authorizations) throws IOException {
        this.ensureInitialized();
        LOGGER.debug("Importing files from %s", dataDir);
        File[] files = dataDir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        int totalFileCount = files.length;
        int fileCount = 0;
        int importedFileCount = 0;
        try {
            for (File f : files) {
                if (f.getName().startsWith(".") || f.length() == 0L || this.isSupportingFile(f)) continue;
                LOGGER.debug("Importing file (%d/%d): %s", fileCount + 1, totalFileCount, f.getAbsolutePath());
                try {
                    ClientApiImportProperty[] properties = null;
                    boolean findExistingByFileHash = true;
                    boolean addToWorkspace = false;
                    this.importFile(f, queueDuplicates, conceptTypeIRI, properties, visibilitySource, workspace, addToWorkspace, findExistingByFileHash, priority, user, authorizations);
                    ++importedFileCount;
                }
                catch (Exception ex) {
                    LOGGER.error("Could not import %s", f.getAbsolutePath(), ex);
                }
                ++fileCount;
            }
        }
        finally {
            this.graph.flush();
        }
        LOGGER.debug(String.format("Imported %d, skipped %d files from %s", importedFileCount, fileCount - importedFileCount, dataDir), new Object[0]);
    }

    private boolean isSupportingFile(File f) {
        for (FileImportSupportingFileHandler fileImportSupportingFileHandler : this.fileImportSupportingFileHandlers) {
            if (!fileImportSupportingFileHandler.isSupportingFile(f)) continue;
            return true;
        }
        return false;
    }

    public Vertex importFile(File f, boolean queueDuplicates, String visibilitySource, Workspace workspace, Priority priority, User user, Authorizations authorizations) throws Exception {
        String conceptId = null;
        ClientApiImportProperty[] properties = null;
        boolean findExistingByFileHash = true;
        boolean addToWorkspace = false;
        return this.importFile(f, queueDuplicates, conceptId, properties, visibilitySource, workspace, addToWorkspace, findExistingByFileHash, priority, user, authorizations);
    }

    /*
     * Loose catch block
     */
    public Vertex importFile(File f, boolean queueDuplicates, String conceptId, ClientApiImportProperty[] properties, String visibilitySource, Workspace workspace, boolean addToWorkspace, boolean findExistingByFileHash, Priority priority, User user, Authorizations authorizations) throws Exception {
        Vertex vertex;
        this.ensureInitialized();
        String hash = this.calculateFileHash(f);
        if (findExistingByFileHash && (vertex = this.findExistingVertexWithHash(hash, authorizations)) != null) {
            LOGGER.debug("vertex already exists with hash %s", hash);
            if (queueDuplicates) {
                LOGGER.debug("pushing %s on to %s queue", vertex.getId(), this.workQueueNames.getGraphPropertyQueueName());
                if (workspace != null) {
                    this.workspaceRepository.updateEntityOnWorkspace(workspace, vertex.getId(), addToWorkspace ? Boolean.valueOf(true) : null, null, user);
                    this.workQueueRepository.broadcastElement((Element)vertex, workspace.getWorkspaceId());
                    this.workQueueRepository.pushGraphPropertyQueue((Element)vertex, MULTI_VALUE_KEY, VisalloProperties.RAW.getPropertyName(), workspace.getWorkspaceId(), visibilitySource, priority);
                } else {
                    this.workQueueRepository.pushGraphPropertyQueue((Element)vertex, MULTI_VALUE_KEY, VisalloProperties.RAW.getPropertyName(), priority);
                }
            }
            return vertex;
        }
        ArrayList<FileImportSupportingFileHandler.AddSupportingFilesResult> addSupportingFilesResults = new ArrayList<FileImportSupportingFileHandler.AddSupportingFilesResult>();
        try {
            try (FileInputStream fileInputStream = new FileInputStream(f);){
                JSONObject metadataJson = this.loadMetadataJson(f);
                String predefinedId = null;
                if (metadataJson != null) {
                    predefinedId = metadataJson.optString("id", null);
                    String metadataVisibilitySource = metadataJson.optString("visibilitySource", null);
                    if (metadataVisibilitySource != null) {
                        visibilitySource = metadataVisibilitySource;
                    }
                }
                StreamingPropertyValue rawValue = new StreamingPropertyValue((InputStream)fileInputStream, byte[].class);
                rawValue.searchIndex(false);
                VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, (String)visibilitySource, (String)(workspace == null ? null : workspace.getWorkspaceId()));
                VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
                Visibility visibility = visalloVisibility.getVisibility();
                Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
                PropertyMetadata propertyMetadata = new PropertyMetadata(user, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
                VisalloProperties.CONFIDENCE_METADATA.setMetadata(propertyMetadata, Double.valueOf(0.1), this.visibilityTranslator.getDefaultVisibility());
                VertexBuilder vertexBuilder = predefinedId == null ? this.graph.prepareVertex(visibility) : this.graph.prepareVertex(predefinedId, visibility);
                ArrayList<VisalloPropertyUpdate> changedProperties = new ArrayList<VisalloPropertyUpdate>();
                VisalloProperties.RAW.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, rawValue, propertyMetadata, visibility);
                VisalloProperties.CONTENT_HASH.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, MULTI_VALUE_KEY, hash, propertyMetadata, visibility);
                VisalloProperties.FILE_NAME.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, MULTI_VALUE_KEY, f.getName(), propertyMetadata, visibility);
                VisalloProperties.MODIFIED_DATE.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, new Date(f.lastModified()), (Metadata)null, defaultVisibility);
                VisalloProperties.MODIFIED_BY.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, user.getUserId(), (Metadata)null, defaultVisibility);
                VisalloProperties.VISIBILITY_JSON.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, visibilityJson, (Metadata)null, defaultVisibility);
                if (conceptId != null) {
                    VisalloProperties.CONCEPT_TYPE.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, conceptId, (Metadata)null, defaultVisibility);
                }
                if (properties != null) {
                    this.addProperties(properties, changedProperties, vertexBuilder, visibilityJson, workspace, user);
                }
                for (FileImportSupportingFileHandler fileImportSupportingFileHandler : this.fileImportSupportingFileHandlers) {
                    FileImportSupportingFileHandler.AddSupportingFilesResult addSupportingFilesResult = fileImportSupportingFileHandler.addSupportingFiles(vertexBuilder, f, visibility);
                    if (addSupportingFilesResult == null) continue;
                    addSupportingFilesResults.add(addSupportingFilesResult);
                }
                vertex = vertexBuilder.save(authorizations);
                for (PostFileImportHandler postFileImportHandler : this.postFileImportHandlers) {
                    postFileImportHandler.handle(this.graph, vertex, changedProperties, workspace, propertyMetadata, visibility, user, authorizations);
                }
                this.graph.flush();
                String workspaceId = null;
                if (workspace != null) {
                    this.workspaceRepository.updateEntityOnWorkspace(workspace, vertex.getId(), addToWorkspace ? Boolean.valueOf(true) : null, null, user);
                    workspaceId = workspace.getWorkspaceId();
                }
                LOGGER.debug("File %s imported. vertex id: %s", f.getAbsolutePath(), vertex.getId());
                LOGGER.debug("pushing %s on to %s queue", vertex.getId(), this.workQueueNames.getGraphPropertyQueueName());
                this.workQueueRepository.broadcastElement((Element)vertex, workspaceId);
                this.workQueueRepository.pushGraphVisalloPropertyQueue((Element)vertex, changedProperties, workspace == null ? null : workspace.getWorkspaceId(), visibilitySource, priority);
                Vertex vertex2 = vertex;
                return vertex2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            for (FileImportSupportingFileHandler.AddSupportingFilesResult addSupportingFilesResult : addSupportingFilesResults) {
                addSupportingFilesResult.close();
            }
        }
    }

    private void addProperties(ClientApiImportProperty[] properties, List<VisalloPropertyUpdate> changedProperties, VertexBuilder vertexBuilder, VisibilityJson visibilityJson, Workspace workspace, User user) throws ParseException {
        for (ClientApiImportProperty property : properties) {
            OntologyProperty ontologyProperty = this.ontologyRepository.getPropertyByIRI(property.getName());
            if (ontologyProperty == null) {
                ontologyProperty = this.ontologyRepository.getRequiredPropertyByIntent(property.getName());
            }
            Object value = ontologyProperty.convertString(property.getValue());
            VisalloProperty prop = ontologyProperty.getVisalloProperty();
            VisibilityJson propertyVisibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, (String)property.getVisibilitySource(), (String)(workspace == null ? null : workspace.getWorkspaceId()));
            VisalloVisibility propertyVisibility = this.visibilityTranslator.toVisibility(propertyVisibilityJson);
            PropertyMetadata propMetadata = new PropertyMetadata(user, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
            for (Map.Entry metadataEntry : property.getMetadata().entrySet()) {
                propMetadata.add((String)metadataEntry.getKey(), metadataEntry.getValue(), propertyVisibility.getVisibility());
            }
            prop.updateProperty(changedProperties, null, (ElementMutation)vertexBuilder, property.getKey(), value, propMetadata, propertyVisibility.getVisibility());
        }
    }

    public List<Vertex> importVertices(Workspace workspace, List<FileOptions> files, Priority priority, boolean addToWorkspace, boolean findExistingByFileHash, User user, Authorizations authorizations) throws Exception {
        this.ensureInitialized();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (FileOptions file : files) {
            if (this.isSupportingFile(file.getFile())) {
                LOGGER.debug("Skipping file: %s (supporting file)", file.getFile().getAbsolutePath());
                continue;
            }
            LOGGER.debug("Processing file: %s", file.getFile().getAbsolutePath());
            Vertex vertex = this.importFile(file.getFile(), true, file.getConceptId(), file.getProperties(), file.getVisibilitySource(), workspace, addToWorkspace, findExistingByFileHash, priority, user, authorizations);
            vertices.add(vertex);
        }
        return vertices;
    }

    private JSONObject loadMetadataJson(File f) throws IOException {
        File metadataFile = MetadataFileImportSupportingFileHandler.getMetadataFile(f);
        if (metadataFile.exists()) {
            try (FileInputStream in = new FileInputStream(metadataFile);){
                String fileContents = IOUtils.toString((InputStream)in);
                JSONObject jSONObject = new JSONObject(fileContents);
                return jSONObject;
            }
        }
        return null;
    }

    private void ensureInitialized() {
        if (this.fileImportSupportingFileHandlers == null) {
            this.fileImportSupportingFileHandlers = this.getFileImportSupportingFileHandlers();
        }
        if (this.postFileImportHandlers == null) {
            this.postFileImportHandlers = this.getPostFileImportHandlers();
        }
    }

    protected List<PostFileImportHandler> getPostFileImportHandlers() {
        return IterableUtils.toList(ServiceLoaderUtil.load(PostFileImportHandler.class, this.configuration));
    }

    protected List<FileImportSupportingFileHandler> getFileImportSupportingFileHandlers() {
        return IterableUtils.toList(ServiceLoaderUtil.load(FileImportSupportingFileHandler.class, this.configuration));
    }

    private Vertex findExistingVertexWithHash(String hash, Authorizations authorizations) {
        Iterator existingVertices = this.graph.query(authorizations).has(VisalloProperties.CONTENT_HASH.getPropertyName(), (Object)hash).vertices().iterator();
        if (existingVertices.hasNext()) {
            return (Vertex)existingVertices.next();
        }
        return null;
    }

    private String calculateFileHash(File f) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(f);){
            String string = RowKeyHelper.buildSHA256KeyString(fileInputStream);
            return string;
        }
    }

    public static class FileOptions {
        private File file;
        private String visibilitySource;
        private String conceptId;
        private ClientApiImportProperty[] properties;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getConceptId() {
            return this.conceptId;
        }

        public void setConceptId(String conceptId) {
            this.conceptId = conceptId;
        }

        public String getVisibilitySource() {
            return this.visibilitySource;
        }

        public void setVisibilitySource(String visibilitySource) {
            this.visibilitySource = visibilitySource;
        }

        public void setProperties(ClientApiImportProperty[] properties) {
            this.properties = properties;
        }

        public ClientApiImportProperty[] getProperties() {
            return this.properties;
        }
    }
}

