/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.ontology;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.vertexium.Authorizations;
import org.vertexium.query.Query;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyPropertyDefinition;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.properties.types.VisalloProperty;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.web.clientapi.model.ClientApiOntology;

public interface OntologyRepository {
    public static final String ENTITY_CONCEPT_IRI = "http://www.w3.org/2002/07/owl#Thing";
    public static final String ROOT_CONCEPT_IRI = "http://visallo.org#root";
    public static final String TYPE_RELATIONSHIP = "relationship";
    public static final String TYPE_CONCEPT = "concept";
    public static final String TYPE_PROPERTY = "property";
    public static final String VISIBILITY_STRING = "ontology";
    public static final String CONFIG_INTENT_CONCEPT_PREFIX = "ontology.intent.concept.";
    public static final String CONFIG_INTENT_RELATIONSHIP_PREFIX = "ontology.intent.relationship.";
    public static final String CONFIG_INTENT_PROPERTY_PREFIX = "ontology.intent.property.";
    public static final VisalloVisibility VISIBILITY = new VisalloVisibility("ontology");

    public void clearCache();

    public Iterable<Relationship> getRelationships();

    public Iterable<OntologyProperty> getProperties();

    public String getDisplayNameForLabel(String var1);

    public OntologyProperty getPropertyByIRI(String var1);

    public OntologyProperty getRequiredPropertyByIRI(String var1);

    public Relationship getRelationshipByIRI(String var1);

    public boolean hasRelationshipByIRI(String var1);

    public Iterable<Concept> getConceptsWithProperties();

    public Concept getEntityConcept();

    public Concept getParentConcept(Concept var1);

    public Concept getConceptByIRI(String var1);

    public Set<Concept> getConceptAndAllChildrenByIri(String var1);

    public Set<Concept> getConceptAndAllChildren(Concept var1);

    public Set<Relationship> getRelationshipAndAllChildren(Relationship var1);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, File var4);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, File var4, boolean var5);

    public Relationship getOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4);

    public OntologyProperty getOrCreateProperty(OntologyPropertyDefinition var1);

    public OWLOntologyManager createOwlOntologyManager(OWLOntologyLoaderConfiguration var1, IRI var2) throws Exception;

    public void resolvePropertyIds(JSONArray var1) throws JSONException;

    public void importResourceOwl(Class var1, String var2, String var3, Authorizations var4);

    public void importFile(File var1, IRI var2, Authorizations var3) throws Exception;

    public void importFileData(byte[] var1, IRI var2, File var3, Authorizations var4) throws Exception;

    public void writePackage(File var1, IRI var2, Authorizations var3) throws Exception;

    public ClientApiOntology getClientApiObject();

    public String guessDocumentIRIFromPackage(File var1) throws Exception;

    public Concept getConceptByIntent(String var1);

    public String getConceptIRIByIntent(String var1);

    public Concept getRequiredConceptByIntent(String var1);

    public Concept getRequiredConceptByIRI(String var1);

    public String getRequiredConceptIRIByIntent(String var1);

    public Relationship getRelationshipByIntent(String var1);

    public String getRelationshipIRIByIntent(String var1);

    public Relationship getRequiredRelationshipByIntent(String var1);

    public String getRequiredRelationshipIRIByIntent(String var1);

    public OntologyProperty getPropertyByIntent(String var1);

    public String getPropertyIRIByIntent(String var1);

    public <T extends VisalloProperty> T getVisalloPropertyByIntent(String var1, Class<T> var2);

    public <T extends VisalloProperty> T getRequiredVisalloPropertyByIntent(String var1, Class<T> var2);

    public List<OntologyProperty> getPropertiesByIntent(String var1);

    public OntologyProperty getRequiredPropertyByIntent(String var1);

    public String getRequiredPropertyIRIByIntent(String var1);

    public boolean isOntologyDefined(String var1);

    public OntologyProperty getDependentPropertyParent(String var1);

    public void addConceptTypeFilterToQuery(Query var1, String var2, boolean var3);

    public void addEdgeLabelFilterToQuery(Query var1, String var2, boolean var3);

    public void updatePropertyDependentIris(OntologyProperty var1, Collection<String> var2);

    public void updatePropertyDomainIris(OntologyProperty var1, Set<String> var2);
}

