/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.properties.types;

import com.google.common.base.Function;
import org.vertexium.Property;

public abstract class VisalloPropertyBase<TRaw, TGraph> {
    private final String propertyName;
    private final Function<Object, TRaw> rawConverter;

    protected VisalloPropertyBase(String propertyName) {
        this.propertyName = propertyName;
        this.rawConverter = new RawConverter();
    }

    public abstract TGraph wrap(TRaw var1);

    public abstract TRaw unwrap(Object var1);

    public final String getPropertyName() {
        return this.propertyName;
    }

    public boolean isSameName(Property property) {
        return this.isSameName(property.getName());
    }

    public boolean isSameName(String propertyName) {
        return this.propertyName.equals(propertyName);
    }

    protected Function<Object, TRaw> getRawConverter() {
        return this.rawConverter;
    }

    public TRaw getPropertyValue(Property property) {
        return this.unwrap(property.getValue());
    }

    public String toString() {
        return this.getClass().getName() + "{propertyName='" + this.propertyName + "'}";
    }

    protected class RawConverter
    implements Function<Object, TRaw> {
        protected RawConverter() {
        }

        public TRaw apply(Object input) {
            return VisalloPropertyBase.this.unwrap(input);
        }
    }
}

