/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;

public abstract class AuthorizationRepositoryBase
implements AuthorizationRepository {
    private final Graph graph;
    private UserRepository userRepository;

    protected AuthorizationRepositoryBase(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Authorizations getGraphAuthorizations(User user, String ... additionalAuthorizations) {
        Preconditions.checkNotNull((Object)user, (Object)"User cannot be null");
        Set<String> userAuthorizations = this.getAuthorizations(user);
        Collections.addAll(userAuthorizations, additionalAuthorizations);
        return this.graph.createAuthorizations(userAuthorizations);
    }

    protected UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }
}

