/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.type.GeoPoint;
import org.vertexium.util.IterableUtils;
import org.visallo.core.ingest.video.VideoFrameInfo;
import org.visallo.core.ingest.video.VideoPropertyHelper;
import org.visallo.core.ingest.video.VideoTranscript;
import org.visallo.core.model.PropertyJustificationMetadata;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.util.ConfidencePropertyComparator;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.VisibilityJson;

public class JsonSerializer {
    public static JSONArray toJson(Iterable<? extends Element> elements, String workspaceId, Authorizations authorizations) {
        JSONArray result = new JSONArray();
        for (Element element : elements) {
            result.put((Object)JsonSerializer.toJson(element, workspaceId, authorizations));
        }
        return result;
    }

    public static JSONObject toJson(Element element, String workspaceId, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)element, (Object)"element cannot be null");
        if (element instanceof Vertex) {
            return JsonSerializer.toJsonVertex((Vertex)element, workspaceId, authorizations);
        }
        if (element instanceof Edge) {
            return JsonSerializer.toJsonEdge((Edge)element, workspaceId);
        }
        throw new RuntimeException("Unexpected element type: " + element.getClass().getName());
    }

    public static JSONObject toJsonVertex(Vertex vertex, String workspaceId, Authorizations authorizations) {
        try {
            JSONObject json = JsonSerializer.toJsonElement((Element)vertex, workspaceId);
            JSONArray vertexEdgeLabelsJson = JsonSerializer.getVertexEdgeLabelsJson(vertex, authorizations);
            if (vertexEdgeLabelsJson != null) {
                json.put("edgeLabels", (Object)vertexEdgeLabelsJson);
            }
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONArray getVertexEdgeLabelsJson(Vertex vertex, Authorizations authorizations) {
        if (authorizations == null) {
            return null;
        }
        Iterable edgeLabels = vertex.getEdgeLabels(Direction.BOTH, authorizations);
        JSONArray result = new JSONArray();
        for (String edgeLabel : edgeLabels) {
            result.put((Object)edgeLabel);
        }
        return result;
    }

    public static JSONObject toJsonEdge(Edge edge, String workspaceId) {
        try {
            JSONObject json = JsonSerializer.toJsonElement((Element)edge, workspaceId);
            json.put("label", (Object)edge.getLabel());
            json.put("outVertexId", (Object)edge.getVertexId(Direction.OUT));
            json.put("inVertexId", (Object)edge.getVertexId(Direction.IN));
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject toJsonElement(Element element, String workspaceId) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)element.getId());
        json.put("properties", (Object)JsonSerializer.toJsonProperties(element.getProperties(), workspaceId));
        json.put("sandboxStatus", (Object)SandboxStatusUtil.getSandboxStatus(element, workspaceId).toString());
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue(element);
        if (visibilityJson != null) {
            json.put("visibilitySource", (Object)visibilityJson.getSource());
        }
        return json;
    }

    public static JSONArray toJsonProperties(Iterable<Property> properties, String workspaceId) {
        JSONArray resultsJson = new JSONArray();
        List propertiesList = IterableUtils.toList(properties);
        Collections.sort(propertiesList, new ConfidencePropertyComparator());
        SandboxStatus[] sandboxStatuses = SandboxStatusUtil.getPropertySandboxStatuses(propertiesList, workspaceId);
        for (int i = 0; i < propertiesList.size(); ++i) {
            Property property = (Property)propertiesList.get(i);
            String sandboxStatus = sandboxStatuses[i].toString();
            VideoFrameInfo videoFrameInfo = VideoPropertyHelper.getVideoFrameInfoFromProperty(property);
            if (videoFrameInfo != null) {
                String textDescription = VisalloProperties.TEXT_DESCRIPTION_METADATA.getMetadataValueOrDefault(property.getMetadata(), null);
                JsonSerializer.addVideoFramePropertyToResults(resultsJson, videoFrameInfo.getPropertyKey(), textDescription, sandboxStatus);
                continue;
            }
            JSONObject propertyJson = JsonSerializer.toJsonProperty(property);
            propertyJson.put("sandboxStatus", (Object)sandboxStatus);
            resultsJson.put((Object)propertyJson);
        }
        return resultsJson;
    }

    public static VideoTranscript getSynthesisedVideoTranscription(Vertex artifactVertex, String propertyKey) throws IOException {
        VideoTranscript videoTranscript = new VideoTranscript();
        for (Property property : artifactVertex.getProperties()) {
            VideoFrameInfo videoFrameInfo = VideoPropertyHelper.getVideoFrameInfoFromProperty(property);
            if (videoFrameInfo == null || !videoFrameInfo.getPropertyKey().equals(propertyKey)) continue;
            Object value = property.getValue();
            String text = value instanceof StreamingPropertyValue ? IOUtils.toString((InputStream)((StreamingPropertyValue)value).getInputStream()) : value.toString();
            videoTranscript.add(new VideoTranscript.Time(videoFrameInfo.getFrameStartTime(), videoFrameInfo.getFrameEndTime()), text);
        }
        if (videoTranscript.getEntries().size() > 0) {
            return videoTranscript;
        }
        return null;
    }

    private static void addVideoFramePropertyToResults(JSONArray resultsJson, String propertyKey, String textDescription, String sandboxStatus) {
        JSONObject json = JsonSerializer.findProperty(resultsJson, MediaVisalloProperties.VIDEO_TRANSCRIPT.getPropertyName(), propertyKey);
        if (json == null) {
            json = new JSONObject();
            json.put("key", (Object)propertyKey);
            json.put("name", (Object)MediaVisalloProperties.VIDEO_TRANSCRIPT.getPropertyName());
            json.put("sandboxStatus", (Object)sandboxStatus);
            json.put(VisalloProperties.TEXT_DESCRIPTION_METADATA.getMetadataKey(), (Object)textDescription);
            json.put("streamingPropertyValue", true);
            resultsJson.put((Object)json);
        }
    }

    private static JSONObject findProperty(JSONArray resultsJson, String propertyName, String propertyKey) {
        for (int i = 0; i < resultsJson.length(); ++i) {
            JSONObject json = resultsJson.getJSONObject(i);
            if (!json.getString("name").equals(propertyName) || !json.getString("key").equals(propertyKey)) continue;
            return json;
        }
        return null;
    }

    public static JSONObject toJsonProperty(Property property) {
        Preconditions.checkNotNull((Object)property, (Object)"property cannot be null");
        JSONObject result = new JSONObject();
        result.put("key", (Object)property.getKey());
        result.put("name", (Object)property.getName());
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            result.put("streamingPropertyValue", true);
        } else {
            result.put("value", JsonSerializer.toJsonValue(propertyValue));
        }
        for (Metadata.Entry metadataEntry : property.getMetadata().entrySet()) {
            result.put(metadataEntry.getKey(), JsonSerializer.toJsonValue(metadataEntry.getValue()));
        }
        return result;
    }

    private static Object toJsonValue(Object value) {
        if (value instanceof GeoPoint) {
            GeoPoint geoPoint = (GeoPoint)value;
            JSONObject result = new JSONObject();
            result.put("latitude", geoPoint.getLatitude());
            result.put("longitude", geoPoint.getLongitude());
            if (geoPoint.getAltitude() != null) {
                result.put("altitude", (Object)geoPoint.getAltitude());
            }
            if (geoPoint.getDescription() != null) {
                result.put("description", (Object)geoPoint.getDescription());
            }
            return result;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof PropertyJustificationMetadata) {
            return ((PropertyJustificationMetadata)value).toJson();
        }
        if (value instanceof String) {
            try {
                String valueString = (String)value;
                valueString = valueString.trim();
                if (valueString.startsWith("{") && valueString.endsWith("}")) {
                    return new JSONObject(valueString);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }
}

