/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import org.vertexium.Element;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkData;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorker;
import org.visallo.core.status.MetricsManager;
import org.visallo.core.status.PausableTimerContext;
import org.visallo.core.status.PausableTimerContextAware;
import org.visallo.core.status.StatusServer;
import org.visallo.core.status.model.GraphPropertyRunnerStatus;
import org.visallo.core.status.model.Status;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class GraphPropertyThreadedWrapper
implements Runnable {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphPropertyThreadedWrapper.class);
    private final GraphPropertyWorker worker;
    private Counter totalProcessedCounter = null;
    private Counter processingCounter;
    private Counter totalErrorCounter;
    private Timer processingTimeTimer;
    private boolean stopped;
    private final Queue<Work> workItems = new LinkedList<Work>();
    private final Queue<WorkResult> workResults = new LinkedList<WorkResult>();
    private MetricsManager metricsManager;

    public GraphPropertyThreadedWrapper(GraphPropertyWorker worker) {
        this.worker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.ensureMetricsInitialized();
        this.stopped = false;
        block33: while (true) {
            try {
                while (!this.stopped) {
                    Work work;
                    Queue<Work> queue = this.workItems;
                    synchronized (queue) {
                        if (this.workItems.size() == 0) {
                            this.workItems.wait(1000L);
                            continue;
                        }
                        work = this.workItems.remove();
                    }
                    InputStream in = work.getIn();
                    String workerClassName = this.worker.getClass().getName();
                    Element element = work.getData() == null ? null : work.getData().getElement();
                    String elementId = element == null ? null : element.getId();
                    try {
                        LOGGER.debug("BEGIN doWork (%s): %s", workerClassName, elementId);
                        PausableTimerContext timerContext = new PausableTimerContext(this.processingTimeTimer);
                        if (in instanceof PausableTimerContextAware) {
                            ((PausableTimerContextAware)((Object)in)).setPausableTimerContext(timerContext);
                        }
                        this.processingCounter.inc();
                        long startTime = System.currentTimeMillis();
                        try {
                            this.worker.execute(in, work.getData());
                        }
                        catch (Throwable throwable) {
                            long endTime = System.currentTimeMillis();
                            long time = endTime - startTime;
                            LOGGER.debug("END doWork (%s): %s (%dms)", workerClassName, elementId, time);
                            this.processingCounter.dec();
                            this.totalProcessedCounter.inc();
                            timerContext.stop();
                            throw throwable;
                        }
                        long endTime = System.currentTimeMillis();
                        long time = endTime - startTime;
                        LOGGER.debug("END doWork (%s): %s (%dms)", workerClassName, elementId, time);
                        this.processingCounter.dec();
                        this.totalProcessedCounter.inc();
                        timerContext.stop();
                        Queue<WorkResult> queue2 = this.workResults;
                        synchronized (queue2) {
                            this.workResults.add(new WorkResult(null));
                            this.workResults.notifyAll();
                            continue block33;
                        }
                    }
                    catch (Throwable ex) {
                        LOGGER.error("failed to complete work (%s): %s", workerClassName, elementId, ex);
                        this.totalErrorCounter.inc();
                        Queue<WorkResult> queue3 = this.workResults;
                        synchronized (queue3) {
                            this.workResults.add(new WorkResult(ex));
                            this.workResults.notifyAll();
                            continue block33;
                        }
                    }
                    finally {
                        try {
                            if (in == null) continue block33;
                            in.close();
                            continue block33;
                        }
                        catch (IOException ex) {
                            Queue<WorkResult> queue4 = this.workResults;
                            synchronized (queue4) {
                                this.workResults.add(new WorkResult(ex));
                                this.workResults.notifyAll();
                                continue block33;
                            }
                        }
                    }
                }
                break;
            }
            catch (InterruptedException ex) {
                LOGGER.error("thread was interrupted", ex);
                break;
            }
        }
    }

    private void ensureMetricsInitialized() {
        if (this.totalProcessedCounter == null) {
            String namePrefix = this.metricsManager.getNamePrefix(this.worker);
            this.totalProcessedCounter = this.metricsManager.counter(namePrefix + "total-processed");
            this.processingCounter = this.metricsManager.counter(namePrefix + "processing");
            this.totalErrorCounter = this.metricsManager.counter(namePrefix + "total-errors");
            this.processingTimeTimer = this.metricsManager.timer(namePrefix + "processing-time");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(InputStream in, GraphPropertyWorkData data) {
        Queue<Work> queue = this.workItems;
        synchronized (queue) {
            this.workItems.add(new Work(in, data));
            this.workItems.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult dequeueResult(boolean waitForever) {
        Queue<WorkResult> queue = this.workResults;
        synchronized (queue) {
            if (this.workResults.size() == 0) {
                long startTime = new Date().getTime();
                while (this.workResults.size() == 0 && (waitForever || new Date().getTime() - startTime < 10000L)) {
                    try {
                        if (new Date().getTime() - startTime > 5000L) {
                            LOGGER.warn("worker has zero results. sleeping waiting for results.", new Object[0]);
                        } else {
                            LOGGER.debug("worker has zero results. sleeping waiting for results.", new Object[0]);
                        }
                        this.workResults.wait(waitForever ? 30000L : 1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return this.workResults.remove();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public GraphPropertyWorker getWorker() {
        return this.worker;
    }

    public GraphPropertyRunnerStatus.GraphPropertyWorkerStatus getStatus() {
        GraphPropertyRunnerStatus.GraphPropertyWorkerStatus status = new GraphPropertyRunnerStatus.GraphPropertyWorkerStatus();
        StatusServer.getGeneralInfo(status, this.worker.getClass());
        status.getMetrics().put("totalProcessed", Status.Metric.create((Metric)this.totalProcessedCounter));
        status.getMetrics().put("processing", Status.Metric.create((Metric)this.processingCounter));
        status.getMetrics().put("totalErrors", Status.Metric.create((Metric)this.totalErrorCounter));
        status.getMetrics().put("processingTime", Status.Metric.create((Metric)this.processingTimeTimer));
        return status;
    }

    @Inject
    public void setMetricsManager(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public String toString() {
        return "GraphPropertyThreadedWrapper{worker=" + this.worker + '}';
    }

    public static class WorkResult {
        private final Throwable error;

        public WorkResult(Throwable error) {
            this.error = error;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    private class Work {
        private final InputStream in;
        private final GraphPropertyWorkData data;

        public Work(InputStream in, GraphPropertyWorkData data) {
            this.in = in;
            this.data = data;
        }

        private InputStream getIn() {
            return this.in;
        }

        private GraphPropertyWorkData getData() {
            return this.data;
        }
    }
}

