/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.notification;

import com.google.inject.Inject;
import com.v5analytics.simpleorm.SimpleOrmSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;
import org.visallo.core.model.notification.NotificationRepository;
import org.visallo.core.model.notification.SystemNotification;
import org.visallo.core.model.notification.SystemNotificationSeverity;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class SystemNotificationRepository
extends NotificationRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(SystemNotificationRepository.class);
    private static final String VISIBILITY_STRING = "";
    private final UserRepository userRepository;

    @Inject
    public SystemNotificationRepository(SimpleOrmSession simpleOrmSession, UserRepository userRepository) {
        super(simpleOrmSession);
        this.userRepository = userRepository;
    }

    public List<SystemNotification> getActiveNotifications(User user) {
        Date now = new Date();
        ArrayList<SystemNotification> activeNotifications = new ArrayList<SystemNotification>();
        for (SystemNotification notification : this.getSimpleOrmSession().findAll(SystemNotification.class, this.userRepository.getSimpleOrmContext(user))) {
            if (!notification.getStartDate().before(now) || notification.getEndDate() != null && !notification.getEndDate().after(now)) continue;
            activeNotifications.add(notification);
        }
        LOGGER.debug("returning %d active system notifications", activeNotifications.size());
        return activeNotifications;
    }

    public SystemNotification createNotification(SystemNotificationSeverity severity, String title, String message, String actionEvent, JSONObject actionPayload, Date startDate, Date endDate, User user) {
        if (startDate == null) {
            startDate = new Date();
        }
        SystemNotification notification = new SystemNotification(startDate, title, message, actionEvent, actionPayload);
        notification.setSeverity(severity);
        notification.setStartDate(startDate);
        notification.setEndDate(endDate);
        this.getSimpleOrmSession().save((Object)notification, VISIBILITY_STRING, this.userRepository.getSimpleOrmContext(user));
        return notification;
    }

    public SystemNotification createNotification(SystemNotificationSeverity severity, String title, String message, String externalUrl, Date startDate, Date endDate, User user) {
        String actionEvent = null;
        JSONObject actionPayload = null;
        if (externalUrl != null) {
            actionEvent = "EXTERNAL_URL";
            actionPayload = new JSONObject();
            actionPayload.put("url", (Object)externalUrl);
        }
        return this.createNotification(severity, title, message, actionEvent, actionPayload, startDate, endDate, user);
    }

    public SystemNotification getNotification(String rowKey, User user) {
        return (SystemNotification)this.getSimpleOrmSession().findById(SystemNotification.class, rowKey, this.userRepository.getSimpleOrmContext(user));
    }

    public SystemNotification updateNotification(SystemNotification notification, User user) {
        this.getSimpleOrmSession().save((Object)notification, VISIBILITY_STRING, this.userRepository.getSimpleOrmContext(user));
        return notification;
    }

    public void endNotification(SystemNotification notification, User user) {
        notification.setEndDate(new Date());
        this.updateNotification(notification, user);
    }

    public List<SystemNotification> getFutureNotifications(Date maxDate, User user) {
        Date now = new Date();
        ArrayList<SystemNotification> futureNotifications = new ArrayList<SystemNotification>();
        for (SystemNotification notification : this.getSimpleOrmSession().findAll(SystemNotification.class, this.userRepository.getSimpleOrmContext(user))) {
            if (!notification.getStartDate().after(now) || !notification.getStartDate().before(maxDate)) continue;
            futureNotifications.add(notification);
        }
        LOGGER.debug("returning %d future system notifications", futureNotifications.size());
        return futureNotifications;
    }
}

