/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.properties.types;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.core.model.properties.types.PropertyMetadata;
import org.visallo.core.model.properties.types.VisalloPropertyBase;
import org.visallo.core.model.properties.types.VisalloPropertyUpdate;
import org.visallo.core.model.properties.types.VisalloPropertyUpdateRemove;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiProperty;

public abstract class SingleValueVisalloProperty<TRaw, TGraph>
extends VisalloPropertyBase<TRaw, TGraph> {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(SingleValueVisalloProperty.class);

    protected SingleValueVisalloProperty(String propertyName) {
        super(propertyName);
    }

    public final void setProperty(ElementMutation<?> mutation, TRaw value, Visibility visibility) {
        mutation.setProperty(this.getPropertyName(), this.wrap(value), visibility);
    }

    public final void setProperty(ElementMutation<?> mutation, TRaw value, Metadata metadata, Visibility visibility) {
        this.setProperty(mutation, value, metadata, null, visibility);
    }

    public final void setProperty(ElementMutation<?> mutation, TRaw value, Metadata metadata, Long timestamp, Visibility visibility) {
        mutation.addPropertyValue("", this.getPropertyName(), this.wrap(value), metadata, timestamp, visibility);
    }

    public final void setProperty(Element element, TRaw value, Visibility visibility, Authorizations authorizations) {
        element.setProperty(this.getPropertyName(), this.wrap(value), visibility, authorizations);
    }

    public final void setProperty(Element element, TRaw value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        element.setProperty(this.getPropertyName(), this.wrap(value), metadata, visibility, authorizations);
    }

    public void setProperty(Map<String, Object> properties, Object value) {
        properties.put(this.getPropertyName(), value);
    }

    public final TRaw getPropertyValue(Element element) {
        Object value = element != null ? element.getPropertyValue(this.getPropertyName()) : null;
        return (TRaw)(value != null ? this.getRawConverter().apply(value) : null);
    }

    public final TRaw getPropertyValueRequired(Element element) {
        Preconditions.checkNotNull((Object)element, (Object)"Element cannot be null");
        Object value = element.getPropertyValue(this.getPropertyName());
        Preconditions.checkNotNull((Object)value, (Object)("Property value of property " + this.getPropertyName() + " cannot be null"));
        return (TRaw)this.getRawConverter().apply(value);
    }

    public final TRaw getPropertyValue(Map<String, Object> map) {
        Object value = map != null ? map.get(this.getPropertyName()) : null;
        return (TRaw)(value != null ? this.getRawConverter().apply(value) : null);
    }

    public TRaw getPropertyValue(ClientApiElement clientApiElement) {
        return this.getPropertyValue(clientApiElement, null);
    }

    public TRaw getPropertyValue(ClientApiElement clientApiElement, TRaw defaultValue) {
        ClientApiProperty property = clientApiElement.getProperty("", this.getPropertyName());
        if (property == null) {
            return defaultValue;
        }
        return (TRaw)property.getValue();
    }

    public boolean hasProperty(Element element) {
        return element.getProperty("", this.getPropertyName()) != null;
    }

    public Property getProperty(Element element) {
        return element.getProperty(this.getPropertyName());
    }

    public void removeProperty(Element element, Authorizations authorizations) {
        element.softDeleteProperty("", this.getPropertyName(), authorizations);
    }

    public void removeProperty(ElementMutation m, Visibility visibility) {
        m.softDeleteProperty(this.getPropertyName(), visibility);
    }

    public void removeMetadata(Metadata metadata) {
        metadata.remove(this.getPropertyName());
    }

    public void removeMetadata(Metadata metadata, Visibility visibility) {
        metadata.remove(this.getPropertyName(), visibility);
    }

    public void alterVisibility(ExistingElementMutation<?> elementMutation, Visibility newVisibility) {
        elementMutation.alterPropertyVisibility(this.getPropertyName(), newVisibility);
    }

    public void removeProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, Visibility visibility) {
        TRaw currentValue = this.getPropertyValue(element);
        if (currentValue != null) {
            long beforeDeletionTimestamp = System.currentTimeMillis() - 1L;
            this.removeProperty(m, visibility);
            changedPropertiesOut.add(new VisalloPropertyUpdateRemove(this, beforeDeletionTimestamp, true, false));
        }
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, PropertyMetadata metadata, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata, null, visibility);
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, PropertyMetadata metadata, Long timestamp, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata.createMetadata(), timestamp, visibility);
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, Metadata metadata, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata, null, visibility);
    }

    public void updateProperty(List<VisalloPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, Metadata metadata, Long timestamp, Visibility visibility) {
        if (newValue == null) {
            LOGGER.error("passing a null value to updateProperty will not be allowed in the future: %s", this);
            return;
        }
        if (newValue instanceof String && ((String)newValue).length() == 0) {
            LOGGER.error("passing an empty string value to updateProperty will not be allowed in the future: %s", this);
            return;
        }
        Object currentValue = null;
        if (element != null) {
            currentValue = this.getPropertyValue(element);
        }
        if (currentValue == null || !newValue.equals(currentValue)) {
            this.setProperty(m, newValue, metadata, timestamp, visibility);
            changedPropertiesOut.add(new VisalloPropertyUpdate(this));
        }
    }
}

