/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.properties.types;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.properties.types.IdentityVisalloProperty;

public class StreamingVisalloProperty
extends IdentityVisalloProperty<StreamingPropertyValue> {
    public StreamingVisalloProperty(String key) {
        super(key);
    }

    public byte[] getFirstPropertyValueAsBytes(Vertex vertex) {
        StreamingPropertyValue propertyValue = (StreamingPropertyValue)this.getFirstPropertyValue((Element)vertex);
        if (propertyValue == null) {
            return null;
        }
        try {
            return IOUtils.toByteArray((InputStream)propertyValue.getInputStream());
        }
        catch (IOException e) {
            throw new VisalloException("Could not get byte[] from StreamingPropertyValue", e);
        }
    }

    public String getFirstPropertyValueAsString(Vertex vertex) {
        StreamingPropertyValue propertyValue = (StreamingPropertyValue)this.getFirstPropertyValue((Element)vertex);
        if (propertyValue == null) {
            return null;
        }
        try {
            return IOUtils.toString((InputStream)propertyValue.getInputStream());
        }
        catch (IOException e) {
            throw new VisalloException("Could not get string from StreamingPropertyValue", e);
        }
    }
}

