/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace;

import java.io.Serializable;
import org.visallo.core.model.workspace.DashboardItem;
import org.visallo.core.util.StreamUtil;

public abstract class Dashboard
implements Serializable {
    static long serialVersionUID = 1L;
    private final String id;
    private final String workspaceId;

    public Dashboard(String id, String workspaceId) {
        this.id = id;
        this.workspaceId = workspaceId;
    }

    public String getId() {
        return this.id;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public abstract String getTitle();

    public abstract Iterable<? extends DashboardItem> getItems();

    public DashboardItem getItemById(String dashboardItemId) {
        return StreamUtil.stream(this.getItems()).filter(dashboardItem -> dashboardItem.getId().equals(dashboardItemId)).findFirst().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dashboard dashboard = (Dashboard)o;
        return this.id.equals(dashboard.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Dashboard{title='" + this.getTitle() + '\'' + ", id='" + this.id + '\'' + ", workspaceId='" + this.workspaceId + '\'' + '}';
    }
}

