/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloJsonParseException;
import org.visallo.web.clientapi.util.ObjectMapperFactory;

public class JSONUtil {
    private static ObjectMapper mapper = ObjectMapperFactory.getInstance();

    public static JSONArray getOrCreateJSONArray(JSONObject json, String name) {
        JSONArray arr = json.optJSONArray(name);
        if (arr == null) {
            arr = new JSONArray();
            json.put(name, (Object)arr);
        }
        return arr;
    }

    public static boolean areEqual(Object o1, Object o2) throws JSONException {
        return JSONUtil.fromJson(o1).equals(JSONUtil.fromJson(o2));
    }

    public static void addToJSONArrayIfDoesNotExist(JSONArray jsonArray, Object value) {
        if (!JSONUtil.arrayContains(jsonArray, value)) {
            jsonArray.put(value);
        }
    }

    public static boolean isInArray(JSONArray jsonArray, Object value) {
        return JSONUtil.arrayIndexOf(jsonArray, value) >= 0;
    }

    public static int arrayIndexOf(JSONArray jsonArray, Object value) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (!jsonArray.get(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public static boolean arrayContains(JSONArray jsonArray, Object value) {
        return JSONUtil.arrayIndexOf(jsonArray, value) != -1;
    }

    public static void removeFromJSONArray(JSONArray jsonArray, Object value) {
        int idx = JSONUtil.arrayIndexOf(jsonArray, value);
        if (idx >= 0) {
            jsonArray.remove(idx);
        }
    }

    public static JSONObject parse(String jsonString) {
        try {
            return new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            throw new VisalloJsonParseException(jsonString, ex);
        }
    }

    public static JSONArray parseArray(String s) {
        try {
            return new JSONArray(s);
        }
        catch (JSONException ex) {
            throw new VisalloJsonParseException(s, ex);
        }
    }

    public static JsonNode toJsonNode(JSONObject json) {
        try {
            if (json == null) {
                return null;
            }
            return mapper.readTree(json.toString());
        }
        catch (IOException e) {
            throw new VisalloException("Could not create json node from: " + json.toString(), e);
        }
    }

    public static Map<String, String> toStringMap(JSONObject json) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Object key : json.keySet()) {
            String keyStr = (String)key;
            results.put(keyStr, json.getString(keyStr));
        }
        return results;
    }

    public static List<String> toStringList(JSONArray arr) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < arr.length(); ++i) {
            result.add(arr.getString(i));
        }
        return result;
    }

    public static List<Object> toList(JSONArray arr) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < arr.length(); ++i) {
            list.add(JSONUtil.fromJson(arr.get(i)));
        }
        return list;
    }

    public static Map<String, Object> toMap(JSONObject obj) {
        Iterator keys = obj.keys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, JSONUtil.fromJson(obj.get(key)));
        }
        return map;
    }

    public static JSONObject toJson(Map<String, ?> map) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, ?> e : map.entrySet()) {
            json.put(e.getKey(), JSONUtil.toJson(e.getValue()));
        }
        return json;
    }

    public static Object toJson(Object value) {
        if (value instanceof Map) {
            return JSONUtil.toJson((Map)value);
        }
        if (value instanceof Iterable) {
            return JSONUtil.toJson((Iterable)value);
        }
        return value;
    }

    public static JSONArray toJson(Iterable iterable) {
        JSONArray json = new JSONArray();
        for (Object o : iterable) {
            json.put(JSONUtil.toJson(o));
        }
        return json;
    }

    public static Long getOptionalLong(JSONObject json, String fieldName) {
        if (!json.has(fieldName) || json.isNull(fieldName)) {
            return null;
        }
        return json.getLong(fieldName);
    }

    private static Object fromJson(Object elem) throws JSONException {
        if (elem instanceof JSONObject) {
            return JSONUtil.toMap((JSONObject)elem);
        }
        if (elem instanceof JSONArray) {
            return JSONUtil.toList((JSONArray)elem);
        }
        return elem;
    }
}

