/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.search;

import com.google.inject.Inject;
import java.util.EnumSet;
import org.json.JSONArray;
import org.vertexium.Authorizations;
import org.vertexium.ElementType;
import org.vertexium.Graph;
import org.vertexium.query.Query;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.directory.DirectoryRepository;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.search.ElementSearchRunnerBase;
import org.visallo.core.model.search.ElementSearchRunnerWithRelatedBase;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class ElementSearchRunner
extends ElementSearchRunnerWithRelatedBase {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ElementSearchRunner.class);
    public static final String URI = "/element/search";

    @Inject
    public ElementSearchRunner(OntologyRepository ontologyRepository, Graph graph, Configuration configuration, DirectoryRepository directoryRepository) {
        super(ontologyRepository, graph, configuration, directoryRepository);
    }

    @Override
    protected EnumSet<ElementType> getResultType() {
        return EnumSet.of(ElementType.EDGE, ElementType.VERTEX);
    }

    @Override
    public String getUri() {
        return URI;
    }

    @Override
    protected ElementSearchRunnerBase.QueryAndData getQuery(SearchOptions searchOptions, Authorizations authorizations) {
        JSONArray filterJson = this.getFilterJson(searchOptions);
        String queryString = searchOptions.getRequiredParameter("q", String.class);
        LOGGER.debug("search %s\n%s", queryString, filterJson.toString(2));
        Query graphQuery = this.query(queryString, authorizations);
        return new ElementSearchRunnerBase.QueryAndData(graphQuery);
    }

    private Query query(String query, Authorizations authorizations) {
        return this.getGraph().query(query, authorizations);
    }
}

