/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.user;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.UserStatus;
import org.visallo.web.clientapi.model.UserType;

public class ProxyUser
implements User {
    private static final long serialVersionUID = -7652656758524792116L;
    private final String userId;
    private final UserRepository userRepository;
    private User proxiedUser;

    public ProxyUser(String userId, UserRepository userRepository) {
        Preconditions.checkNotNull((Object)userId, (Object)"userId cannot be null");
        Preconditions.checkNotNull((Object)userRepository, (Object)"userRepository cannot be null");
        this.userId = userId;
        this.userRepository = userRepository;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public User getProxiedUser() {
        this.ensureUser();
        return this.proxiedUser;
    }

    @Override
    public String getUsername() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getUsername();
    }

    @Override
    public String getDisplayName() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getDisplayName();
    }

    @Override
    public String getEmailAddress() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getEmailAddress();
    }

    @Override
    public Date getCreateDate() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getCreateDate();
    }

    @Override
    public Date getCurrentLoginDate() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getCurrentLoginDate();
    }

    @Override
    public String getCurrentLoginRemoteAddr() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getCurrentLoginRemoteAddr();
    }

    @Override
    public Date getPreviousLoginDate() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getPreviousLoginDate();
    }

    @Override
    public String getPreviousLoginRemoteAddr() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getPreviousLoginRemoteAddr();
    }

    @Override
    public int getLoginCount() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return 0;
        }
        return this.proxiedUser.getLoginCount();
    }

    @Override
    public UserType getUserType() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getUserType();
    }

    @Override
    public UserStatus getUserStatus() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getUserStatus();
    }

    @Override
    public String getCurrentWorkspaceId() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getCurrentWorkspaceId();
    }

    @Override
    public JSONObject getUiPreferences() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getUiPreferences();
    }

    @Override
    public String getPasswordResetToken() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getPasswordResetToken();
    }

    @Override
    public Date getPasswordResetTokenExpirationDate() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getPasswordResetTokenExpirationDate();
    }

    @Override
    public Object getProperty(String propertyName) {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getProperty(propertyName);
    }

    @Override
    public Map<String, Object> getCustomProperties() {
        this.ensureUser();
        if (this.proxiedUser == null) {
            return null;
        }
        return this.proxiedUser.getCustomProperties();
    }

    private void ensureUser() {
        if (this.proxiedUser == null) {
            this.proxiedUser = this.userRepository.findById(this.userId);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        return this.getUserId().equals(other.getUserId());
    }

    public int hashCode() {
        return this.getUserId().hashCode();
    }

    public String toString() {
        return "ProxyUser{userId='" + this.userId + '\'' + '}';
    }
}

