/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

public class VisalloTime {
    private final String hours;
    private final String minutes;
    private final String seconds;
    private final String milliseconds;

    public VisalloTime(Integer hours, Integer minutes, Integer seconds, Integer milliseconds) {
        this(hours == null ? null : hours.toString(), minutes == null ? null : minutes.toString(), seconds == null ? null : seconds.toString(), milliseconds == null ? null : milliseconds.toString());
    }

    public VisalloTime(String hours, String minutes, String seconds, String milliseconds) {
        this.hours = VisalloTime.cleanHoursString(hours);
        this.minutes = VisalloTime.cleanMinutesString(minutes);
        this.seconds = VisalloTime.cleanSecondsString(seconds);
        this.milliseconds = VisalloTime.cleanMillisecondsString(milliseconds);
    }

    private static String cleanMillisecondsString(String milliseconds) {
        String string = milliseconds = milliseconds == null ? "???" : milliseconds;
        if (milliseconds.length() == 1) {
            milliseconds = milliseconds.charAt(0) == '?' ? "?" + milliseconds : "0" + milliseconds;
        }
        if (milliseconds.length() == 2) {
            milliseconds = milliseconds.charAt(0) == '?' ? "?" + milliseconds : "0" + milliseconds;
        }
        return milliseconds;
    }

    private static String cleanHoursString(String hours) {
        String string = hours = hours == null ? "??" : hours;
        if (hours.length() == 1) {
            hours = hours.charAt(0) == '?' ? "?" + hours : "0" + hours;
        }
        return hours;
    }

    private static String cleanMinutesString(String minutes) {
        String string = minutes = minutes == null ? "??" : minutes;
        if (minutes.length() == 1) {
            minutes = minutes.charAt(0) == '?' ? "?" + minutes : "0" + minutes;
        }
        return minutes;
    }

    private static String cleanSecondsString(String seconds) {
        String string = seconds = seconds == null ? "??" : seconds;
        if (seconds.length() == 1) {
            seconds = seconds.charAt(0) == '?' ? "?" + seconds : "0" + seconds;
        }
        return seconds;
    }

    public String getHours() {
        return this.hours;
    }

    public int getHoursInt() {
        return Integer.parseInt(this.getHours());
    }

    public String getMinutes() {
        return this.minutes;
    }

    public int getMinutesInt() {
        return Integer.parseInt(this.getMinutes());
    }

    public String getSeconds() {
        return this.seconds;
    }

    public int getSecondsInt() {
        return Integer.parseInt(this.getSeconds());
    }

    public String getMilliseconds() {
        return this.milliseconds;
    }

    public int getMillisecondsInt() {
        return Integer.parseInt(this.getMilliseconds());
    }

    public String toString() {
        return this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() + "." + this.getMilliseconds();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisalloTime that = (VisalloTime)o;
        if (!this.hours.equals(that.hours)) {
            return false;
        }
        if (!this.minutes.equals(that.minutes)) {
            return false;
        }
        if (!this.seconds.equals(that.seconds)) {
            return false;
        }
        return this.milliseconds.equals(that.milliseconds);
    }

    public int hashCode() {
        int result = this.hours.hashCode();
        result = 31 * result + this.minutes.hashCode();
        result = 31 * result + this.seconds.hashCode();
        result = 31 * result + this.milliseconds.hashCode();
        return result;
    }
}

