/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.ingest.ArtifactDetectedObject;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.VisibilityJson;

@Singleton
public class WorkspaceHelper {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceHelper.class);
    private static final String DETECTED_OBJECT_MULTI_VALUE_KEY_PREFIX = "org.visallo.web.routes.vertex.ResolveDetectedObject";
    private final TermMentionRepository termMentionRepository;
    private final WorkQueueRepository workQueueRepository;
    private final Graph graph;
    private final OntologyRepository ontologyRepository;
    private final WorkspaceRepository workspaceRepository;
    private final PrivilegeRepository privilegeRepository;
    private String entityHasImageIri;
    private final AuthorizationRepository authorizationRepository;
    private String artifactContainsImageOfEntityIri;

    @Inject
    public WorkspaceHelper(TermMentionRepository termMentionRepository, WorkQueueRepository workQueueRepository, Graph graph, OntologyRepository ontologyRepository, WorkspaceRepository workspaceRepository, PrivilegeRepository privilegeRepository, AuthorizationRepository authorizationRepository) {
        this.termMentionRepository = termMentionRepository;
        this.workQueueRepository = workQueueRepository;
        this.graph = graph;
        this.ontologyRepository = ontologyRepository;
        this.workspaceRepository = workspaceRepository;
        this.privilegeRepository = privilegeRepository;
        this.authorizationRepository = authorizationRepository;
        this.entityHasImageIri = ontologyRepository.getRelationshipIRIByIntent("entityHasImage");
        if (this.entityHasImageIri == null) {
            LOGGER.warn("'entityHasImage' intent has not been defined. Please update your ontology.", new Object[0]);
        }
        this.artifactContainsImageOfEntityIri = ontologyRepository.getRelationshipIRIByIntent("artifactContainsImageOfEntity");
        if (this.artifactContainsImageOfEntityIri == null) {
            LOGGER.warn("'artifactContainsImageOfEntity' intent has not been defined. Please update your ontology.", new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getWorkspaceIdOrNullIfPublish(String workspaceId, boolean shouldPublish, User user) {
        if (shouldPublish) {
            if (!this.privilegeRepository.hasPrivilege(user, "PUBLISH")) throw new VisalloAccessDeniedException("The publish parameter was sent in the request, but the user does not have publish privilege.", user, "publish");
            return null;
        }
        if (workspaceId != null) return workspaceId;
        throw new VisalloException("workspaceId parameter required");
    }

    public void unresolveTerm(Vertex termMention, Authorizations authorizations) {
        Vertex outVertex = this.termMentionRepository.findOutVertex(termMention, authorizations);
        if (outVertex == null) {
            return;
        }
        String resolveEdgeId = VisalloProperties.TERM_MENTION_RESOLVED_EDGE_ID.getPropertyValue((Element)termMention, null);
        if (resolveEdgeId != null) {
            Edge resolveEdge = this.graph.getEdge(resolveEdgeId, authorizations);
            long beforeDeletionTimestamp = System.currentTimeMillis() - 1L;
            this.graph.softDeleteEdge(resolveEdge, authorizations);
            this.graph.flush();
            this.workQueueRepository.pushEdgeDeletion(resolveEdge, beforeDeletionTimestamp, Priority.HIGH);
        }
        this.termMentionRepository.delete(termMention, authorizations);
        this.workQueueRepository.pushTextUpdated(outVertex.getId());
        this.graph.flush();
    }

    public void deleteProperty(Element e, Property property, boolean propertyIsPublic, String workspaceId, Priority priority, Authorizations authorizations) {
        ElementOrPropertyStatus status;
        long beforeActionTimestamp = System.currentTimeMillis() - 1L;
        if (propertyIsPublic && workspaceId != null) {
            e.markPropertyHidden(property, new Visibility(workspaceId), authorizations);
            status = ElementOrPropertyStatus.HIDDEN;
        } else {
            e.softDeleteProperty(property.getKey(), property.getName(), property.getVisibility(), authorizations);
            status = ElementOrPropertyStatus.DELETION;
        }
        if (e instanceof Vertex) {
            this.unresolveTermMentionsForProperty((Vertex)e, property, authorizations);
        }
        this.graph.flush();
        this.workQueueRepository.pushGraphPropertyQueue(e, property, status, (Long)beforeActionTimestamp, priority);
    }

    public void deleteEdge(String workspaceId, Edge edge, Vertex outVertex, Vertex inVertex, boolean isPublicEdge, Priority priority, Authorizations authorizations, User user) {
        this.ensureOntologyIrisInitialized();
        long beforeActionTimestamp = System.currentTimeMillis() - 1L;
        this.deleteProperties((Element)edge, workspaceId, priority, authorizations);
        this.unresolveDetectedObjects(workspaceId, edge, outVertex, inVertex, priority, authorizations);
        this.workspaceRepository.updateEntityOnWorkspace(workspaceId, edge.getVertexId(Direction.IN), null, null, user);
        this.workspaceRepository.updateEntityOnWorkspace(workspaceId, edge.getVertexId(Direction.OUT), null, null, user);
        if (isPublicEdge) {
            Object entityHasImage;
            Visibility workspaceVisibility = new Visibility(workspaceId);
            this.graph.markEdgeHidden(edge, workspaceVisibility, authorizations);
            if (edge.getLabel().equals(this.entityHasImageIri) && (entityHasImage = outVertex.getProperty(VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName())) != null) {
                outVertex.markPropertyHidden((Property)entityHasImage, workspaceVisibility, authorizations);
                this.workQueueRepository.pushElementImageQueue((Element)outVertex, (Property)entityHasImage, priority);
            }
            for (Vertex termMention : this.termMentionRepository.findByEdgeId(outVertex.getId(), edge.getId(), authorizations)) {
                this.termMentionRepository.markHidden(termMention, workspaceVisibility, authorizations);
                this.workQueueRepository.pushTextUpdated(outVertex.getId());
            }
            this.graph.flush();
            this.workQueueRepository.pushEdgeHidden(edge, beforeActionTimestamp, Priority.HIGH);
        } else {
            Property entityHasImage;
            this.graph.softDeleteEdge(edge, authorizations);
            if (edge.getLabel().equals(this.entityHasImageIri) && (entityHasImage = outVertex.getProperty(VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName())) != null) {
                outVertex.softDeleteProperty(entityHasImage.getKey(), entityHasImage.getName(), authorizations);
                this.workQueueRepository.pushElementImageQueue((Element)outVertex, entityHasImage, priority);
            }
            for (Vertex termMention : this.termMentionRepository.findByEdgeId(outVertex.getId(), edge.getId(), authorizations)) {
                this.termMentionRepository.delete(termMention, authorizations);
                this.workQueueRepository.pushTextUpdated(outVertex.getId());
            }
            this.graph.flush();
            this.workQueueRepository.pushEdgeDeletion(edge, beforeActionTimestamp, Priority.HIGH);
        }
    }

    private void ensureOntologyIrisInitialized() {
        if (this.entityHasImageIri == null) {
            this.entityHasImageIri = this.ontologyRepository.getRelationshipIRIByIntent("entityHasImage");
        }
        if (this.artifactContainsImageOfEntityIri == null) {
            this.artifactContainsImageOfEntityIri = this.ontologyRepository.getRelationshipIRIByIntent("artifactContainsImageOfEntity");
        }
    }

    public void deleteProperties(Element e, String propertyKey, String propertyName, OntologyProperty ontologyProperty, String workspaceId, Authorizations authorizations, User user) {
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.addAll(IterableUtils.toList((Iterable)e.getProperties(propertyKey, propertyName)));
        if (ontologyProperty != null) {
            for (String dependentPropertyIri : ontologyProperty.getDependentPropertyIris()) {
                properties.addAll(IterableUtils.toList((Iterable)e.getProperties(propertyKey, dependentPropertyIri)));
            }
        }
        if (properties.size() == 0) {
            throw new VisalloResourceNotFoundException(String.format("Could not find property %s:%s on %s", propertyName, propertyKey, e));
        }
        if (workspaceId != null) {
            if (e instanceof Edge) {
                Edge edge = (Edge)e;
                this.workspaceRepository.updateEntityOnWorkspace(workspaceId, edge.getVertexId(Direction.IN), null, null, user);
                this.workspaceRepository.updateEntityOnWorkspace(workspaceId, edge.getVertexId(Direction.OUT), null, null, user);
            } else if (e instanceof Vertex) {
                this.workspaceRepository.updateEntityOnWorkspace(workspaceId, e.getId(), null, null, user);
            } else {
                throw new VisalloException("element is not an edge or vertex: " + e);
            }
        }
        SandboxStatus[] sandboxStatuses = SandboxStatusUtil.getPropertySandboxStatuses(properties, workspaceId);
        for (int i = 0; i < sandboxStatuses.length; ++i) {
            boolean propertyIsPublic = sandboxStatuses[i] == SandboxStatus.PUBLIC;
            Property property = (Property)properties.get(i);
            this.deleteProperty(e, property, propertyIsPublic, workspaceId, Priority.HIGH, authorizations);
        }
    }

    private void deleteProperties(Element e, String workspaceId, Priority priority, Authorizations authorizations) {
        List properties = IterableUtils.toList((Iterable)e.getProperties());
        SandboxStatus[] sandboxStatuses = SandboxStatusUtil.getPropertySandboxStatuses(properties, workspaceId);
        for (int i = 0; i < sandboxStatuses.length; ++i) {
            boolean propertyIsPublic = sandboxStatuses[i] == SandboxStatus.PUBLIC;
            Property property = (Property)properties.get(i);
            this.deleteProperty(e, property, propertyIsPublic, workspaceId, priority, authorizations);
        }
    }

    public void deleteVertex(Vertex vertex, String workspaceId, boolean isPublicVertex, Priority priority, Authorizations authorizations, User user) {
        LOGGER.debug("BEGIN deleteVertex(vertexId: %s, workspaceId: %s, isPublicVertex: %b, user: %s)", vertex.getId(), workspaceId, isPublicVertex, user.getUsername());
        this.ensureOntologyIrisInitialized();
        long beforeActionTimestamp = System.currentTimeMillis() - 1L;
        this.deleteProperties((Element)vertex, workspaceId, priority, authorizations);
        this.workspaceRepository.updateEntityOnWorkspace(workspaceId, vertex.getId(), null, null, user);
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)vertex);
        visibilityJson = VisibilityJson.removeFromAllWorkspace((VisibilityJson)visibilityJson);
        LOGGER.debug("change entity image properties", new Object[0]);
        for (Edge edge : vertex.getEdges(Direction.BOTH, this.entityHasImageIri, authorizations)) {
            if (!edge.getVertexId(Direction.IN).equals(vertex.getId())) continue;
            Vertex outVertex = edge.getVertex(Direction.OUT, authorizations);
            Property entityHasImage = outVertex.getProperty(VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName());
            outVertex.softDeleteProperty(entityHasImage.getKey(), entityHasImage.getName(), authorizations);
            this.workQueueRepository.pushElementImageQueue((Element)outVertex, entityHasImage, priority);
            this.graph.softDeleteEdge(edge, authorizations);
            this.workQueueRepository.pushEdgeDeletion(edge, beforeActionTimestamp, Priority.HIGH);
        }
        LOGGER.debug("change artifact contains image of entity", new Object[0]);
        for (Edge edge : vertex.getEdges(Direction.BOTH, this.artifactContainsImageOfEntityIri, authorizations)) {
            for (Property rowKeyProperty : vertex.getProperties(VisalloProperties.ROW_KEY.getPropertyName())) {
                String multiValueKey = rowKeyProperty.getValue().toString();
                if (!edge.getVertexId(Direction.IN).equals(vertex.getId())) continue;
                Vertex outVertex = edge.getVertex(Direction.OUT, authorizations);
                VisalloProperties.DETECTED_OBJECT.removeProperty((Element)outVertex, multiValueKey, authorizations);
                this.graph.softDeleteEdge(edge, authorizations);
                this.workQueueRepository.pushEdgeDeletion(edge, beforeActionTimestamp, Priority.HIGH);
                this.workQueueRepository.pushGraphPropertyQueue((Element)outVertex, multiValueKey, VisalloProperties.DETECTED_OBJECT.getPropertyName(), workspaceId, visibilityJson.getSource(), ElementOrPropertyStatus.DELETION, (Long)beforeActionTimestamp, priority);
            }
        }
        LOGGER.debug("unresolve terms", new Object[0]);
        for (Vertex termMention : this.termMentionRepository.findResolvedTo(vertex.getId(), authorizations)) {
            this.unresolveTerm(termMention, authorizations);
        }
        if (isPublicVertex) {
            Visibility workspaceVisibility = new Visibility(workspaceId);
            this.graph.markVertexHidden(vertex, workspaceVisibility, authorizations);
            this.graph.flush();
            this.workQueueRepository.pushVertexHidden(vertex, beforeActionTimestamp, Priority.HIGH);
        } else {
            LOGGER.debug("soft delete edges", new Object[0]);
            Authorizations systemAuthorization = this.authorizationRepository.getGraphAuthorizations(user, "workspace", workspaceId);
            Vertex workspaceVertex = this.graph.getVertex(workspaceId, systemAuthorization);
            for (Edge edge : workspaceVertex.getEdges(vertex, Direction.BOTH, systemAuthorization)) {
                this.graph.softDeleteEdge(edge, systemAuthorization);
            }
            LOGGER.debug("soft delete vertex", new Object[0]);
            this.graph.softDeleteVertex(vertex, authorizations);
            this.graph.flush();
            this.workQueueRepository.pushVertexDeletion(vertex, beforeActionTimestamp, Priority.HIGH);
        }
        this.graph.flush();
        LOGGER.debug("END deleteVertex", new Object[0]);
    }

    private void unresolveTermMentionsForProperty(Vertex vertex, Property property, Authorizations authorizations) {
        for (Vertex termMention : this.termMentionRepository.findResolvedTo(vertex.getId(), authorizations)) {
            String key = (String)VisalloProperties.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue((Element)termMention);
            String name = (String)VisalloProperties.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue((Element)termMention);
            String visibility = (String)VisalloProperties.TERM_MENTION_REF_PROPERTY_VISIBILITY.getPropertyValue((Element)termMention);
            if (!property.getKey().equals(key) || !property.getName().equals(name) || !property.getVisibility().getVisibilityString().equals(visibility)) continue;
            this.unresolveTerm(termMention, authorizations);
        }
    }

    private void unresolveDetectedObjects(String workspaceId, Edge edge, Vertex outVertex, Vertex inVertex, Priority priority, Authorizations authorizations) {
        for (ArtifactDetectedObject artifactDetectedObject : VisalloProperties.DETECTED_OBJECT.getPropertyValues((Element)outVertex)) {
            if (!edge.getId().equals(artifactDetectedObject.getEdgeId())) continue;
            this.unresolveDetectedObject(artifactDetectedObject, workspaceId, edge, outVertex, inVertex, priority, authorizations);
        }
    }

    private void unresolveDetectedObject(ArtifactDetectedObject artifactDetectedObject, String workspaceId, Edge edge, Vertex outVertex, Vertex inVertex, Priority priority, Authorizations authorizations) {
        VisibilityJson visibilityJson;
        String multiValueKey = artifactDetectedObject.getMultivalueKey(DETECTED_OBJECT_MULTI_VALUE_KEY_PREFIX);
        SandboxStatus vertexSandboxStatus = SandboxStatusUtil.getSandboxStatus((Element)inVertex, workspaceId);
        if (vertexSandboxStatus == SandboxStatus.PUBLIC) {
            visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)edge);
            visibilityJson = VisibilityJson.removeFromWorkspace((VisibilityJson)visibilityJson, (String)workspaceId);
        } else {
            visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)inVertex);
            visibilityJson = VisibilityJson.removeFromWorkspace((VisibilityJson)visibilityJson, (String)workspaceId);
        }
        VisalloProperties.DETECTED_OBJECT.removeProperty((Element)outVertex, multiValueKey, authorizations);
        this.workQueueRepository.pushGraphPropertyQueue((Element)outVertex, multiValueKey, VisalloProperties.DETECTED_OBJECT.getPropertyName(), workspaceId, visibilityJson.getSource(), priority);
    }
}

